# This an autogenerated file
# 
# Generated with RegularWaveLoading
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.regularwaveloading import RegularWaveLoadingBlueprint
from typing import Dict
from sima.riflex.kinematicsinwavezone import KinematicsInWaveZone
from sima.riflex.riserposition import RiserPosition
from sima.riflex.wavetheory import WaveTheory
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue

class RegularWaveLoading(MOAO):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    waveTheory : WaveTheory
         Wave theory:\n - Airy linear wave theory\n - Stoke 5th order wave theory
    seaSurfaceDefinition : KinematicsInWaveZone
         Kinematics In Wave Zone:\n - Integration of wave forces to mean water level\n - Integration of wave forces to wave surface by stretching and compression of the wave potential\n - Integration of wave forces to wave surface by moving the potential to actual surface\n - Integration of wave forces to wave surface by keeping the potential constant from mean water level to water surface
    riserPosition : RiserPosition
         Kinematics Position:\n - Wave induced velocities and accelerations calculated at static riser position, but the riser is kept fixed in static position for computation of surface penetrating element\n - Wave induced velocities and accelerations calculated at static riser position\n - Wave induced velocities and accelerations calculated at updated (dynamic) positions
    """

    def __init__(self , name="", description="", _id="", waveTheory=WaveTheory.AIRY_LINEAR, seaSurfaceDefinition=KinematicsInWaveZone.MEAN_WATER_LEVEL, riserPosition=RiserPosition.DYNAMIC_POSITIONS, **kwargs):
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self._id = _id
        self.scriptableValues = list()
        self.waveTheory = waveTheory
        self.seaSurfaceDefinition = seaSurfaceDefinition
        self.riserPosition = riserPosition
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return RegularWaveLoadingBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def waveTheory(self) -> WaveTheory:
        """Wave theory:
 - Airy linear wave theory
 - Stoke 5th order wave theory"""
        return self.__waveTheory

    @waveTheory.setter
    def waveTheory(self, value: WaveTheory):
        """Set waveTheory"""
        self.__waveTheory = value

    @property
    def seaSurfaceDefinition(self) -> KinematicsInWaveZone:
        """Kinematics In Wave Zone:
 - Integration of wave forces to mean water level
 - Integration of wave forces to wave surface by stretching and compression of the wave potential
 - Integration of wave forces to wave surface by moving the potential to actual surface
 - Integration of wave forces to wave surface by keeping the potential constant from mean water level to water surface"""
        return self.__seaSurfaceDefinition

    @seaSurfaceDefinition.setter
    def seaSurfaceDefinition(self, value: KinematicsInWaveZone):
        """Set seaSurfaceDefinition"""
        self.__seaSurfaceDefinition = value

    @property
    def riserPosition(self) -> RiserPosition:
        """Kinematics Position:
 - Wave induced velocities and accelerations calculated at static riser position, but the riser is kept fixed in static position for computation of surface penetrating element
 - Wave induced velocities and accelerations calculated at static riser position
 - Wave induced velocities and accelerations calculated at updated (dynamic) positions"""
        return self.__riserPosition

    @riserPosition.setter
    def riserPosition(self, value: RiserPosition):
        """Set riserPosition"""
        self.__riserPosition = value
