# This an autogenerated file
# 
# Generated with LocalElementAxis
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.localelementaxis import LocalElementAxisBlueprint
from typing import Dict
from sima.riflex.elementreference import ElementReference
from sima.sima.scriptablevalue import ScriptableValue
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from sima.riflex.arline import ARLine
    from sima.riflex.referenceframe import ReferenceFrame

class LocalElementAxis(ElementReference):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    line : ARLine
         Line
    segment : int
         Segment on given line(default 1)
    allSegments : bool
         All segments(default False)
    elementNumber : int
         Local element number on actual segment(default 1)
    allElements : bool
         All elements(default False)
    referenceFrame : ReferenceFrame
         Reference frame for local orientation. If no reference frame is given. Orientation is given in global frame of reference
    rnx : float
         Reference vector x component(default 0.0)
    rny : float
         Reference vector y component(default 0.0)
    rnz : float
         Reference vector z component(default 1.0)
    """

    def __init__(self , name="", description="", _id="", segment=1, allSegments=False, elementNumber=1, allElements=False, rnx=0.0, rny=0.0, rnz=1.0, **kwargs):
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self._id = _id
        self.scriptableValues = list()
        self.line = None
        self.segment = segment
        self.allSegments = allSegments
        self.elementNumber = elementNumber
        self.allElements = allElements
        self.referenceFrame = None
        self.rnx = rnx
        self.rny = rny
        self.rnz = rnz
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return LocalElementAxisBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def line(self) -> ARLine:
        """Line"""
        return self.__line

    @line.setter
    def line(self, value: ARLine):
        """Set line"""
        self.__line = value

    @property
    def segment(self) -> int:
        """Segment on given line"""
        return self.__segment

    @segment.setter
    def segment(self, value: int):
        """Set segment"""
        self.__segment = int(value)

    @property
    def allSegments(self) -> bool:
        """All segments"""
        return self.__allSegments

    @allSegments.setter
    def allSegments(self, value: bool):
        """Set allSegments"""
        self.__allSegments = bool(value)

    @property
    def elementNumber(self) -> int:
        """Local element number on actual segment"""
        return self.__elementNumber

    @elementNumber.setter
    def elementNumber(self, value: int):
        """Set elementNumber"""
        self.__elementNumber = int(value)

    @property
    def allElements(self) -> bool:
        """All elements"""
        return self.__allElements

    @allElements.setter
    def allElements(self, value: bool):
        """Set allElements"""
        self.__allElements = bool(value)

    @property
    def referenceFrame(self) -> ReferenceFrame:
        """Reference frame for local orientation. If no reference frame is given. Orientation is given in global frame of reference"""
        return self.__referenceFrame

    @referenceFrame.setter
    def referenceFrame(self, value: ReferenceFrame):
        """Set referenceFrame"""
        self.__referenceFrame = value

    @property
    def rnx(self) -> float:
        """Reference vector x component"""
        return self.__rnx

    @rnx.setter
    def rnx(self, value: float):
        """Set rnx"""
        self.__rnx = float(value)

    @property
    def rny(self) -> float:
        """Reference vector y component"""
        return self.__rny

    @rny.setter
    def rny(self, value: float):
        """Set rny"""
        self.__rny = float(value)

    @property
    def rnz(self) -> float:
        """Reference vector z component"""
        return self.__rnz

    @rnz.setter
    def rnz(self, value: float):
        """Set rnz"""
        self.__rnz = float(value)
