# This an autogenerated file
# 
# Generated with EigenvalueAnalysisParameters
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.eigenvalueanalysisparameters import EigenvalueAnalysisParametersBlueprint
from typing import Dict
from sima.riflex.eigenvaluestartvector import EigenvalueStartVector
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue

class EigenvalueAnalysisParameters(MOAO):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    numberOfEigenvalues : int
         Number of eigenvalues to be calculated(default 10)
    numberOfEigenvectors : int
         Number of eigenvectors to be calculated(default 10)
    maxRelativeError : float
         Maximum acceptable relative error in computed eigenvalues(default 0.0)
    limitValue : float
         Limit value for singularity test during factorization(default 0.0)
    orthogonalityLimit : float
         Orthogonality limit(default 0.0)
    startVector : EigenvalueStartVector
         Start vector code
    maxNumberOfIterations : int
         A positive number gives an iterative Gram-Schmidt procedure. A negative number gives a multi-pass Gram-Schmidt procedure.(default 5)
    frequencyControlParameter : int
         Parameter controlling frequency for solving small tridiagonal eigenvalue problem(default 0)
    shiftValue : float
         Shift value(default 0.0)
    numberOfLanczoSteps : int
         Number of Lanczos steps to be used, 0.0 result in an automatic computaion of suitable value(default 0)
    premultiplyStartVector : bool
         Whether the start vector should be premultiplied with H or not(default True)
    storeVisualisationResponses : bool
         Store eigenvalue visualization file(default True)
    visualisationScaling : float
         Scaling of eigenvectors in visual results(default 10.0)
    """

    def __init__(self , name="", description="", _id="", numberOfEigenvalues=10, numberOfEigenvectors=10, maxRelativeError=0.0, limitValue=0.0, orthogonalityLimit=0.0, startVector=EigenvalueStartVector.PSEUDORANDOM_STARTVECTOR, maxNumberOfIterations=5, frequencyControlParameter=0, shiftValue=0.0, numberOfLanczoSteps=0, premultiplyStartVector=True, storeVisualisationResponses=True, visualisationScaling=10.0, **kwargs):
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self._id = _id
        self.scriptableValues = list()
        self.numberOfEigenvalues = numberOfEigenvalues
        self.numberOfEigenvectors = numberOfEigenvectors
        self.maxRelativeError = maxRelativeError
        self.limitValue = limitValue
        self.orthogonalityLimit = orthogonalityLimit
        self.startVector = startVector
        self.maxNumberOfIterations = maxNumberOfIterations
        self.frequencyControlParameter = frequencyControlParameter
        self.shiftValue = shiftValue
        self.numberOfLanczoSteps = numberOfLanczoSteps
        self.premultiplyStartVector = premultiplyStartVector
        self.storeVisualisationResponses = storeVisualisationResponses
        self.visualisationScaling = visualisationScaling
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return EigenvalueAnalysisParametersBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def numberOfEigenvalues(self) -> int:
        """Number of eigenvalues to be calculated"""
        return self.__numberOfEigenvalues

    @numberOfEigenvalues.setter
    def numberOfEigenvalues(self, value: int):
        """Set numberOfEigenvalues"""
        self.__numberOfEigenvalues = int(value)

    @property
    def numberOfEigenvectors(self) -> int:
        """Number of eigenvectors to be calculated"""
        return self.__numberOfEigenvectors

    @numberOfEigenvectors.setter
    def numberOfEigenvectors(self, value: int):
        """Set numberOfEigenvectors"""
        self.__numberOfEigenvectors = int(value)

    @property
    def maxRelativeError(self) -> float:
        """Maximum acceptable relative error in computed eigenvalues"""
        return self.__maxRelativeError

    @maxRelativeError.setter
    def maxRelativeError(self, value: float):
        """Set maxRelativeError"""
        self.__maxRelativeError = float(value)

    @property
    def limitValue(self) -> float:
        """Limit value for singularity test during factorization"""
        return self.__limitValue

    @limitValue.setter
    def limitValue(self, value: float):
        """Set limitValue"""
        self.__limitValue = float(value)

    @property
    def orthogonalityLimit(self) -> float:
        """Orthogonality limit"""
        return self.__orthogonalityLimit

    @orthogonalityLimit.setter
    def orthogonalityLimit(self, value: float):
        """Set orthogonalityLimit"""
        self.__orthogonalityLimit = float(value)

    @property
    def startVector(self) -> EigenvalueStartVector:
        """Start vector code"""
        return self.__startVector

    @startVector.setter
    def startVector(self, value: EigenvalueStartVector):
        """Set startVector"""
        self.__startVector = value

    @property
    def maxNumberOfIterations(self) -> int:
        """A positive number gives an iterative Gram-Schmidt procedure. A negative number gives a multi-pass Gram-Schmidt procedure."""
        return self.__maxNumberOfIterations

    @maxNumberOfIterations.setter
    def maxNumberOfIterations(self, value: int):
        """Set maxNumberOfIterations"""
        self.__maxNumberOfIterations = int(value)

    @property
    def frequencyControlParameter(self) -> int:
        """Parameter controlling frequency for solving small tridiagonal eigenvalue problem"""
        return self.__frequencyControlParameter

    @frequencyControlParameter.setter
    def frequencyControlParameter(self, value: int):
        """Set frequencyControlParameter"""
        self.__frequencyControlParameter = int(value)

    @property
    def shiftValue(self) -> float:
        """Shift value"""
        return self.__shiftValue

    @shiftValue.setter
    def shiftValue(self, value: float):
        """Set shiftValue"""
        self.__shiftValue = float(value)

    @property
    def numberOfLanczoSteps(self) -> int:
        """Number of Lanczos steps to be used, 0.0 result in an automatic computaion of suitable value"""
        return self.__numberOfLanczoSteps

    @numberOfLanczoSteps.setter
    def numberOfLanczoSteps(self, value: int):
        """Set numberOfLanczoSteps"""
        self.__numberOfLanczoSteps = int(value)

    @property
    def premultiplyStartVector(self) -> bool:
        """Whether the start vector should be premultiplied with H or not"""
        return self.__premultiplyStartVector

    @premultiplyStartVector.setter
    def premultiplyStartVector(self, value: bool):
        """Set premultiplyStartVector"""
        self.__premultiplyStartVector = bool(value)

    @property
    def storeVisualisationResponses(self) -> bool:
        """Store eigenvalue visualization file"""
        return self.__storeVisualisationResponses

    @storeVisualisationResponses.setter
    def storeVisualisationResponses(self, value: bool):
        """Set storeVisualisationResponses"""
        self.__storeVisualisationResponses = bool(value)

    @property
    def visualisationScaling(self) -> float:
        """Scaling of eigenvectors in visual results"""
        return self.__visualisationScaling

    @visualisationScaling.setter
    def visualisationScaling(self, value: float):
        """Set visualisationScaling"""
        self.__visualisationScaling = float(value)
