# This an autogenerated file
# 
# Generated with SpectralPeakPeriodRelation
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.spectralpeakperiodrelation import SpectralPeakPeriodRelationBlueprint
from numpy import ndarray,asarray
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue

class SpectralPeakPeriodRelation(MOAO):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    hs : ndarray
    interval5 : ndarray
    mean : ndarray
    interval95 : ndarray
    """

    def __init__(self , name="", description="", _id="", **kwargs):
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self._id = _id
        self.scriptableValues = list()
        self.hs = ndarray(1)
        self.interval5 = ndarray(1)
        self.mean = ndarray(1)
        self.interval95 = ndarray(1)
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SpectralPeakPeriodRelationBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def hs(self) -> ndarray:
        """"""
        return self.__hs

    @hs.setter
    def hs(self, value: ndarray):
        """Set hs"""
        self.__hs = asarray(value)

    @property
    def interval5(self) -> ndarray:
        """"""
        return self.__interval5

    @interval5.setter
    def interval5(self, value: ndarray):
        """Set interval5"""
        self.__interval5 = asarray(value)

    @property
    def mean(self) -> ndarray:
        """"""
        return self.__mean

    @mean.setter
    def mean(self, value: ndarray):
        """Set mean"""
        self.__mean = asarray(value)

    @property
    def interval95(self) -> ndarray:
        """"""
        return self.__interval95

    @interval95.setter
    def interval95(self, value: ndarray):
        """Set interval95"""
        self.__interval95 = asarray(value)
