from .iam_pomes import (
    IamServer, logger_register,
    login_callback, token_exchange,
    user_login, user_logout, user_token
)
from .jusbr_pomes import (
    jusbr_setup, jusbr_get_token
)
from .keycloak_pomes import (
    keycloak_setup, keycloak_get_token
)
from .provider_pomes import (
    provider_register, provider_get_token
)
from .token_pomes import (
    token_validate
)

__all__ = [
    # iam_pomes
    "IamServer", "logger_register",
    "login_callback", "token_exchange",
    "user_login", "user_logout", "user_token",
    # jusbr_pomes
    "jusbr_setup", "jusbr_get_token",
    # keycloak_pomes
    "keycloak_setup", "keycloak_get_token",
    # provider_pomes
    "provider_register", "provider_get_token",
    # token_pomes
    "token_validate"
]

from importlib.metadata import version
__version__ = version("pypomes_iam")
__version_info__ = tuple(int(i) for i in __version__.split(".") if i.isdigit())
