import sys

from .data import REPLACEMENTS, COMBININGMARKS, SUBSUPERSCRIPTS


if __name__ == "__main__":
    outname = 'ts_src/data.ts'
    if len(sys.argv) == 2:
        outname = sys.argv[1]

    with open(outname, 'w', encoding='utf8') as f:
        f.write('// autogenerated with python -m unicodeit.export_data\n\n')

        f.write('export const replacements = [\n')
        for l, u in REPLACEMENTS:
            l = l.replace('\\', '\\\\')
            l = l.replace('\'', '\\\'')
            u = u.replace('\\', '\\\\')
            f.write(f'   [\'{l}\', \'{u}\'],\n')
        f.write('];\n\n')

        f.write('export const combiningmarks = [\n')
        for l, u in COMBININGMARKS:
            l = l.replace('\\', '\\\\')
            l = l.replace('\'', '\\\'')
            u = u.encode('ascii', 'backslashreplace').decode()
            f.write(f'   [\'{l}\', \'{u}\'],\n')
        f.write('];\n\n')

        f.write('export const subsuperscripts = [\n')
        for l, u in SUBSUPERSCRIPTS:
            f.write(f'   [\'{l}\', \'{u}\'],\n')
        f.write('];\n')
