from distutils.core import setup

# read the contents of your README file
from pathlib import Path
this_directory = Path(__file__).parent
long_description = (this_directory / "README.md").read_text()

setup(
    name='Slasher',         # How you named your package folder (MyLib)
    packages=['Slasher'],   # Chose the same as "name"
    version='0.0.1-alpha.1',      # Start with a small number and increase it with every change you make
    # Chose a license from here: https://help.github.com/articles/licensing-a-repository
    license='MIT',
    # Give a short description about your library
    description='A discord API Wrapper that focuses primarly on slash commands',
    long_description=long_description,
    long_description_content_type='text/markdown',
    author='Thomas',                   # Type in your name
    author_email='thomas@galehuset.org',      # Type in your E-Mail
    # Provide either the link to your github or to your website
    url='https://github.com/tagptroll1/Slasher',
    # I explain this later on
    download_url='https://github.com/tagptroll1/Slasher/archive/refs/tags/v0.0.1-alpha.1.tar.gz',
    keywords=['Discord', 'python', 'discord.py', 'slash', 'slash commands',
              'api', 'wrapper'],   # Keywords that define your package best
    install_requires=[],
    classifiers=[
        # Chose either "3 - Alpha", "4 - Beta" or "5 - Production/Stable" as the current state of your package
        'Development Status :: 3 - Alpha',
        # Define that your audience are developers
        'Intended Audience :: Developers',
        'Topic :: Software Development :: Build Tools',
        'License :: OSI Approved :: MIT License',   # Again, pick a license
        # Specify which pyhton versions that you want to support
        'Programming Language :: Python :: 3.9',
    ],
)
