"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductStackSynthesizer = void 0;
const cdk = require("aws-cdk-lib");
/**
 * Deployment environment for an AWS Service Catalog product stack.
 *
 * Interoperates with the StackSynthesizer of the parent stack.
 */
class ProductStackSynthesizer extends cdk.StackSynthesizer {
    bind(stack) {
        if (this.stack !== undefined) {
            throw new Error('A Stack Synthesizer can only be bound once, create a new instance to use with a different Stack');
        }
        this.stack = stack;
    }
    addFileAsset(_asset) {
        throw new Error('Service Catalog Product Stacks cannot use Assets');
    }
    addDockerImageAsset(_asset) {
        throw new Error('Service Catalog Product Stacks cannot use Assets');
    }
    synthesize(session) {
        if (!this.stack) {
            throw new Error('You must call bindStack() first');
        }
        // Synthesize the template, but don't emit as a cloud assembly artifact.
        // It will be registered as an S3 asset of its parent instead.
        this.synthesizeStackTemplate(this.stack, session);
    }
}
exports.ProductStackSynthesizer = ProductStackSynthesizer;
//# sourceMappingURL=data:application/json;base64,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