# oapi

`oapi` is a library and CLI for authoring python data models (for clients
*or* servers), and/or client libraries, for web APIs, based on an
OpenAPI specification (both OpenAPI/Swagger [version 2](https://bit.ly/36VneDU)
and [version 3](https://bit.ly/3OHGRQV) are supported).

`oapi`-generated packages/modules differ from those generated by other tools
(including but not limited to
[swagger-codegen](https://github.com/swagger-api/swagger-codegen)) in that
`oapi` generates a data model which enforces the schemas defined
in the OpenAPI specification. This means that request and response objects
cannot comprise data types which differ from those specified in the spec,
and objects cannot have properties which are not defined. If an API
will add properties to an object which are not explicitly defined
in the schema properties, that object should have an
["additionalProperties"](https://bit.ly/3LuUlxm) attribute, in which
case `oapi` will treat these objects as dictionaries/mappings. `oapi` also
fully supports polymorphism when a schema has an "anyOf", "allOf", or
"oneOf" attribute (although `oapi` does not *require* a
[discriminator](https://bit.ly/3vPvMEW) to be defined). This design decision
could prove to be an annoyance to lazy developers of client applications, since
inaccurate OpenAPI schemas are endemic to many organizations. The author
of this library, however, asserts that end-to-end data validation is
absolutely essential for applications which are part of a critical data
pipeline. The author of this library is also of the opinion that when
encountering inaccurate OpenAPI specifications, you should fix the spec, and
if you are not the owner of the spec (and can't convince the owner to fix it),
you should script your fix in order to apply that same fix to future versions
of the specification.

Notable features of an `oapi` generated client/model library include:

- `oapi` generated data models and clients are fully type-hinted (they
   will pass inspection by `mypy`).
- `oapi` generated data models and clients adhere to PEP-8 formatting
  standards, and will pass inspection by `flake8` (with the default options).
- `oapi` generated data models and clients include docstrings for all models,
  model properties, client methods, and client method parameters, inferred
  from "description" and "summary" attributes of elements within the
  specification.
- `oapi` generated clients will handle the most common server-to-server
  authentication methods out-of-box, including the OAuth2 authorization
  code flow (client_id/client_secret), API keys, bearer tokens, HTTP basic
  auth, and most cookie-based authentication patterns. Custom authentication 
  methods are also easily accomplished by specifying custom base classes
  and/or passing initialization decorators to the `oapi client` shell
  command or to the `oapi.client.create()` function.
- `oapi` generated clients and models are easily updated. For instance: `oapi`
  generated data model classes can be renamed using your favorite IDE's
  refactoring tools, and subsequent updates to that data model (such as
  to reflect minor-version updates to the spec which add endpoints, schemas,
  parameters, etc.) will retain your new class names, so long as the
  schema from which the class was generated remains in the same location
  within the spec. Class naming can also be customized by passing a custom
  hook to the *get_class_name_from_pointer* parameter for
  `oapi.model.Module` or `oapi.model.create`.

TODO: Finish README.md :-)
