# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['jml']

package_data = \
{'': ['*']}

entry_points = \
{'console_scripts': ['jml = jml.jml:main']}

setup_kwargs = {
    'name': 'jml',
    'version': '0.2.7',
    'description': 'Ein Tool um Projektversionen zu generieren',
    'long_description': '=======================\nJava Musterlösung (jml)\n=======================\n\nJava Musterlösung (kurz ``jml``) ist ein kleines Skript mit dem mehrere Projektversionen aus einer Musterlösung generiert werden können.\n\n``jml`` wurde ursprünglich für Java-Projekte entwickelt, kann aber durch diverse Optionen auch für andere Projekte genutzt werden.\n\nMotivation\n----------\n\nZur Differenzierung im Informatikunterricht erstelle ich gerne mehrere Projektversionen mit mehr oder weniger Hilfestellungen, um dem Leistungsstand der Schülerinnen und Schüler besser gerecht zu werden. Inklusive einer Musterlösung können so schnell drei bis vier Projektversionen entstehen, die parallel weiterentwickelt werden müssen.\n\nBefindet sich ein Fehler im Code, sollen die Aufgaben angepasst werden oder hat sich einfach ein Rechtschreibfehler in einen Kommentar eingeschlichen, müssen alle Projektversionen angepasst werden. Dabei habe ich schnell mal eine Version vergessen oder einen neuen Fehler eingebaut.\n\nVor einigen Jahren habe ich den Prozess mit ``jml`` vereinfacht. Das Skript generiert aus einer Basisversion, die mit Markierungen für Aufgaben und Lösungen versehen ist, die verschiedenen Projektversionen, die für den Unterricht nötig sind. Anpassungen sind nur noch im Basisprojekt notwendig.\n\nInstallation\n------------\n\nDie Installation wird wie gewohnt mit pypi durchgeführt:\n\n.. code-block:: console\n\n   $ pip3 install jml\n\nBei erfolgreicher Installation ist nun das ``jml`` Kommando verfügbar.\n\n.. code-block:: console\n\n   $ jml --version\n   jml, version 0.2.7\n\nManuelle Installation\n^^^^^^^^^^^^^^^^^^^^^\n\n``jml`` kann auch ohne ``pip`` einfach als Skriptdatei genutzt werden. Dazu die aktuelle Version der Datei `jml.py <https://github.com/jneug/jml/blob/main/src/jml/jml.py>`_ aus dem Repository kopieren und auf der Festplatte speichern. Das Skript kann dann mit Python 3 ausgeführt werden:\n\n.. code-block:: console\n\n   $ python3 jml.py --version\n   jml, version 0.2.7\n\n\nBenutzung\n---------\n\n``jml`` benötigt im einfachsten Fall den Pfad des Basisprojektes und den Pfad des Ausgabeordners:\n\n.. code-block:: console\n\n   $ jml pfad/zum/ProjektOrdner --out pfad/zum/ausgabeordner\n\nNach Ausführung befinden sich in ``pfad/zum/ausgabeordner`` die Musterlösung und die Projektversionen.\n\nDie Inhalte und Anzahl an Versionen werden durch die Inhalte der Dateien im Projektordner bestimmt.\n\nAngenommen in ``ProjektOrdner`` liegt eine Datei mit dem Namen ``Beispiel.java`` mit folgendem Inhalt:\n\n.. code-block:: java\n\n    class Example {\n        /*aufg*\n        // TODO: Erstelle eine Objektvariable "zahl" vom Typ int\n        *aufg*/\n        //ml*\n        private int zahl;\n        //*ml\n\n        public int add( int pAndereZahl ) {\n            /*aufg*\n            // TODO: Gib die Summe aus der Objektvariablen "zahl" und "pAndereZahl" zurück.\n            return 0;\n            *aufg*/\n            //ml*\n            return zahl + pAndereZahl;\n            //*ml\n        }\n    }\n\nDann erzeugt ``jml`` diese Ordnerstruktur in ``pfad/zum/ausgabeordner``::\n\n    pfad/zum/ausgabeordner/\n    ├── ProjektOrdner/\n    │   └── Beispiel.java\n    └── ProjektOrdner_ML/\n        └── Beispiel.java\n\nInhalt von ``ProjektOrdner_ML/Beispiel.java``:\n\n.. code-block:: java\n\n    class Example {\n        private int zahl;\n\n        public int add( int pAndereZahl ) {\n            return zahl + pAndereZahl;\n        }\n    }\n\nInhalt von ``ProjektOrdner/Beispiel.java``:\n\n.. code-block:: java\n\n    class Example {\n        // TODO: Erstelle eine Objektvariable "zahl" vom Typ int\n\n        public int add( int pAndereZahl ) {\n            // TODO: Gib die Summe aus der Objektvariablen "zahl" und "pAndereZahl" zurück.\n            return 0;\n        }\n    }\n\n\nMehrere Versionen\n^^^^^^^^^^^^^^^^^\n\nAls Standard wird wie oben nur die Projektversion ``0`` erstellt. ``jml`` kann aber auch mehrere Projekte erstellen, wenn die Aufgaben-Markierungen mit einer entsprechenden Nummer versehen werden.\n\nAngenommen die ``Beispiel.java`` von oben sieht so aus:\n\n.. code-block:: java\n\n    class Example {\n        /*aufg*\n        // TODO: Erstelle eine Objektvariable "zahl" vom Typ int\n        *aufg*/\n        //ml*\n        private int zahl;\n        //*ml\n\n        public int add( int pAndereZahl ) {\n            /*aufg*\n            // TODO: Gib die Summe aus der Objektvariablen "zahl" und "pSummand" zurück.\n            return 0;\n            *aufg*/\n            //ml*\n            return zahl + pAndereZahl;\n            //*ml\n        }\n\n        /*aufg* 2\n        public int sub( int pAndereZahl ) {\n            // TODO: Gib die Differenz aus der Objektvariablen "zahl" und "pSummand" zurück.\n            return 0;\n        }\n        *aufg*/\n\n    }\n\nDann wird werden statt der Version ``0`` die Projektversionen ``1`` und ``2`` erzeugt, da im zweiten Aufgaben-Marker eine konkrete Versionsnummer angegeben wurde::\n\n    pfad/zum/ausgabeordner/\n    ├── ProjektOrdner_1/\n    │   └── Beispiel.java\n    ├── ProjektOrdner_2/\n    │   └── Beispiel.java\n    └── ProjektOrdner_ML/\n        └── Beispiel.java\n\nEs ist auch möglich eine Markierung für mehrere Projektversionen zu nutzen:\n\n.. code-block:: java\n\n    /*aufg* >1\n    // Taucht nur in Projektversionen nach Version 1 auf.\n    *aufg*/\n\n    /*aufg* !=2\n    // Taucht in allen Projektversionen außer 2 auf.\n    *aufg*/\n\n    /*aufg* <= 2\n    // Taucht nur in Projektversionen 1 und 2 auf.\n    *aufg*/\n\n\nOptionen\n--------\n\nDie Funktion von ``jml`` ist durch eine Vielzahl von Optionen anpassbar. Die Optionen können als Kommandozeilen-Argumente übergeben, oder in Konfigurationsdateien gespeichert werden.\n\nEine Übersicht der verfügbaren Kommandozeilen-Argumente ist mit ``-h`` abrufbar\n\n.. code-block:: console\n\n   $ jml -h\n\nAlle Optionen (und noch eine Handvoll mehr) lassen sich auch in einer von mehreren Konfigurationsdateien festlegen. ``jml`` sucht dazu bei jedem Start nach ``.jml`` Dateien im Basisprojekt, im Wurzelverzeichnis (``--project-root``) und im Home-Ordner des angemeldeten Nutzers (``~/.jml``).\n\nDie Konfigurationen werden dann in umgekehrter Reihenfolge geladen, die Einstellungen im Basisprojekt haben also die höchste Priorität. Sie werden nur noch von Kommandozeilen-Argumente überschrieben.\n\nFür das Beispiel oben könnte der Aufbau so aussehen::\n\n    ~/\n    ├── .jml\n    ├── pfad/zur/gruppe/\n    │   ├── .jml\n    │   └── ProjektOrdner/\n    │       ├── .jml\n    │       └── Beispiel.java\n    └── pfad/zum/ausgabeordner\n\nInhalt von ``~/.jml``:\n\n.. code-block:: ini\n\n   [settings]\n   opening tag=/*<aufgabe>\n   closing tag=</aufgabe>*/\n   opening ml tag=//<loesung>\n   closing ml tag=//</loesung>\n\nInhalt von ``~/pfad/zur/gruppe/.jml``:\n\n.. code-block:: ini\n\n   [settings]\n   zip = yes\n   ml suffix = Loesung\n   name format = {project}-{version}\n   include = *.java,*.txt\n\nInhalt von ``~/pfad/zur/gruppe/ProjektOrdner/.jml``:\n\n.. code-block:: ini\n\n   [settings]\n   opening tag=/*aufgabe*\n   closing tag=*aufgabe*/\n   encoding = iso-8859-1\n   name = Maeusekampf\n\nDer Aufruf von ``jml`` sieht dann so aus:\n\n.. code-block:: console\n\n   $ jml --project-root "~/pfad/zur/gruppe" "~/pfad/zur/gruppe/ProjektOrdner"  --out "pfad/zum/ausgabeordner"\n\n``jml`` lädt nun zunächst ``~/.jml`` und setzt die Start- und Endmarkierungen auf eine XML-Variante.\n\nDanach wird ``~/pfad/zur/gruppe/.jml`` geladen, da dies per ``--project-root`` Argument als Gruppenverzeichnis gesetzt wurde. Für diese Projektgruppe werden ZIP-Dateien der Projektversionen erzeugt, außerdem wird das Suffix für die Musterlösung von ``ML`` auf ``Loesung`` geändert. Das Format der Projektnamen wird angepasst (``_`` durch ``-`` ersetzt) und es werden auch ``.txt`` Dateien nach den Aufgaben- und Lösungs-Markierungen durchsucht.\n\nAls drittes wird ``~/pfad/zur/gruppe/ProjektOrdner/.jml`` geladen. Hier werden speziell für dieses eine Projekt die Aufgaben-Marker erneut verändert und die Datei-Codierung auf ``iso-8859-1`` (statt ``utf-8``) festgelegt. Schließlich wird noch der Projektname auf ``Maeusekampf`` festgelgt, anstatt den Ordnernamen ``ProjektOrdner`` zu verwenden.\n\nDie Ausgabe sieht dann so aus (sofern die Aufgaben- und Lösungs-Markierungen in ``Beispiel.java`` angepasst wurden)::\n\n    ~/\n    ├── .jml\n    ├── pfad/zur/gruppe/\n    │   ├── .jml\n    │   └── ProjektOrdner/\n    │       ├── .jml\n    │       └── Beispiel.java\n    └── pfad/zum/ausgabeordner/\n        ├── Maeusekampf-Loesung/\n        │   └── Beispiel.java\n        ├── Maeusekampf-1/\n        │   └── Beispiel.java\n        ├── Maeusekampf-2/\n        │   └── Beispiel.java\n        ├── Maeusekampf-Loesung.zip\n        ├── Maeusekampf-1.zip\n        └── Maeusekampf-2.zip\n\nListe der Optionen\n^^^^^^^^^^^^^^^^^^\n\nDie Tabelle zeigt eine Übersicht aller Optionen, die in einer Konfigurationsdatei gesetzt werden können und der dazugehörigen Kommandozeilen-Argumente.\n\n+---------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| Optionsname in Konfigurationsdateien  | Kommandozeilen-Argument                                                                                                                                                 | Beschreibung                                                                                                                                                                                                                                                                                                                                                                                                                              |\n+=======================================+=========================================================================================================================================================================+===========================================================================================================================================================================================================================================================================================================================================================================================================================================+\n| output dir                            | -o / --out                                                                                                                                                              | Legt den Zielordner für die Ausgabe der Projektversionen fest. Beachte, dass der finale Ausgabeordner unterhalb von ``outdir`` abhängig von ``--project-root`` noch variieren kann.                                                                                                                                                                                                                                                       |\n+---------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| name                                  | -n / --name                                                                                                                                                             | Setzt den Namen der erstellten Projektversionen. Im Namensformat wird ``{project}`` durch den Namen ersetzt. Als Standard wird der Ordnername des Basisprojektes verwendet.                                                                                                                                                                                                                                                               |\n+---------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| name format                           | --name-format                                                                                                                                                           | Legt das Format fest, nach dem die Projektversionen benannt werden. Der Wert ist ein Python-Formatierungsstring und kann die Variablen ``{project}``  für den Namen, ``{version}`` für die Versionsnummer und ``{date}`` für das aktuelle Datum enthalten. Auf diese Weise können Projekte beispielsweise mit einer Jahreszahl versehen werden (``name format = {date:%Y}_{project}-v{version}``). Standard ist ``{project}_{version}``.  |\n+---------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| ml suffix                             | -mls / --ml-suffix                                                                                                                                                      | Setzt die Versionsnummer der Musterlösung. Standard ist ``ML``.                                                                                                                                                                                                                                                                                                                                                                           |\n+---------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| opening tag                           | -to / --tag-open                                                                                                                                                        | Setzt die Anfangsmarkierung für Aufgaben. Die Markierung sollte nach einem öffnenden Block-Kommentar stehen, damit die Aufgabenstellung in der Basisversion auskommentiert ist. Standard ist ``/*aufg*``.                                                                                                                                                                                                                                 |\n+---------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| closing tag                           | -tc / --tag-close                                                                                                                                                       | Setzt die Endmarkierung für Aufgaben. Die Markierung sollte vor einem schließenden Block-Kommentar stehen, damit die Aufgabenstellung in der Basisversion auskommentiert ist. Standard ist ``*aufg*/``.                                                                                                                                                                                                                                   |\n+---------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| opening ml tag                        | -mlo / --ml-open                                                                                                                                                        | Setzt die Anfangsmarkierung für Lösungen. Die Markierung sollte nach einem Zeilen-Kommentar stehen, damit die Musterlösung in der Basisversion lauffähig bleibt. Standard ist ``/ml*``.                                                                                                                                                                                                                                                   |\n+---------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| closing ml tag                        | -mlc / --ml-close                                                                                                                                                       | Setzt die Endmarkierung für Lösungen. Die Markierung sollte nach einem Zeilen-Kommentar stehen, damit die Musterlösung in der Basisversion lauffähig bleibt. Standard ist ``//*ml``.                                                                                                                                                                                                                                                      |\n+---------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| clear                                 | --no-clear                                                                                                                                                              | Verhindert, dass die Ordner der Projektversionen zuerst vollständig gelöscht werden. Vorhandene Dateien werden dann überschrieben, aber Dateien, die nicht im Basisprojekt sind (oder in den Excludes stehen) werden nicht berührt und verbleiben in den Projektversionen.                                                                                                                                                                |\n+---------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| project root                          | --project-root                                                                                                                                                          | Setzt das Wurzelverzeichnis, anhand dessen die Ordnerstruktur im Zielordner festgelegt wird. Das Verzeichnis sollte ein Elternverzeichnis des Basisprojektes sein. Im Wurzelverzeichnis wird außerdem nach einer ``.jml`` Datei gesucht, die vor der Konfigurationsdatei im Basisprojekt geladen wird.                                                                                                                                    |\n+---------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| include                               | -i / --include                                                                                                                                                          | Setzt die Liste der `Suchmuster für Dateien`_, in denen nach Aufgaben- und Lösungs-Markierungen gesucht werden soll. Standard ist ``*.java``.                                                                                                                                                                                                                                                                                             |\n+---------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| +include                              | ;                                                                                                                                                                       | Kann nur in Konfigurationsdateien auftauchen und ergänzt die Liste der Includes um weitere Suchmuster, anstatt sie zu ersetzen.                                                                                                                                                                                                                                                                                                           |\n+---------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| -include                              | ;                                                                                                                                                                       | Kann nur in Konfigurationsdateien auftauchen und entfernt Suchmuster aus der Liste der Includes.                                                                                                                                                                                                                                                                                                                                          |\n+---------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| exclude                               | -e / --exclude                                                                                                                                                          | Setzt die Liste der `Suchmuster für Dateien`_, die komplett ignoriert werden soll. Diese Dateien tauchen nicht in den Projektverisonen auf. Excludes haben Vorrang vor Includes. Standard ist ``*.class,*.ctxt,.DS_Store,Thumbs.db,.vscode,.eclipse,*.iml``.                                                                                                                                                                              |\n+---------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| +exclude                              | ;                                                                                                                                                                       | Kann nur in Konfigurationsdateien auftauchen und ergänzt die Liste der Excludes um weitere Suchmuster, anstatt sie zu ersetzen.                                                                                                                                                                                                                                                                                                           |\n+---------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| -exclude                              | ;                                                                                                                                                                       | Kann nur in Konfigurationsdateien auftauchen und entfernt Suchmuster aus der Liste der Excludes.                                                                                                                                                                                                                                                                                                                                          |\n+---------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| additional files                      | ;                                                                                                                                                                       | Eine Liste von Dateien, die zusätzlich in alle Projektversionen kopiert werden sollen. Die Dateien werden nicht nach Markierungen durchsucht und exakt kopiert.                                                                                                                                                                                                                                                                           |\n+---------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| -v / --versions                       | Liste von Versionsnummern von Projektversionen, die erstellt werden sollen. Bezieht sich nicht auf dei Musterlösung. Diese kann mit ``--delete-ml`` abgestellt werden.  |                                                                                                                                                                                                                                                                                                                                                                                                                                           |\n+---------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| encoding                              | --encoding                                                                                                                                                              | Zeichenkodierung der Dateien. Standard ist ``utf-8``.                                                                                                                                                                                                                                                                                                                                                                                     |\n+---------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| delete empty files                    | --delete-empty                                                                                                                                                          | Wenn gesetzt werden Dateien, die nach dem kompilieren keinen Inhalt mehr haben, nicht in die Projektversionen kopiert.                                                                                                                                                                                                                                                                                                                    |\n+---------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| create zip                            | -z / --zip                                                                                                                                                              | Erstellt zu jeder Projektversion zusätzlich eine ZIP-Datei mit demselben Namen.                                                                                                                                                                                                                                                                                                                                                           |\n+---------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| create zip only                       | ;                                                                                                                                                                       | Erstellt nur die ZIP-Dateien. Impliziert ``create zip = yes``.                                                                                                                                                                                                                                                                                                                                                                            |\n+---------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| creat zip dir                         | ;                                                                                                                                                                       | Ausgabeverzeichnis für die ZIP-Dateien, falls dieses von OUT abweicht. Standard ist dasselbe Verzeichnis wie für die Ausgabe der Projektversionen. (Also OUT bzw. ein Unterverzeichnis von OUT, wenn ein Wurzelverzeichnis angegeben wurde.)                                                                                                                                                                                              |\n+---------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| delete ml                             | --no-ml                                                                                                                                                                 | Löscht die Musterlösung nach Ablauf des Programms. Unabhängig von dieser Einstellung wird die Musterlösung immer als erstes erstellt, um in den Dateien nach Aufgaben-Markierungen zu suchen und so die zu erstellenden Projektversionen zu ermitteln. Diese Einstellung löscht den Ordner der Musterlösung aber danach wieder. Es wird dann auch keine ZIP-Datei mehr erstellt.                                                          |\n+---------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| --debug                               | Schaltet die Debug-Ausgaben ein.                                                                                                                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                           |\n+---------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n\n\n\n.. _Suchmuster für Dateien: https://docs.python.org/3/library/fnmatch.html\n\nBeispiele\n^^^^^^^^^\n\nDas folgende Beispiel kopiert die ``.class`` Dateien mit in die Projektversionen und ignoriert dafür einige der ``.java`` Quelltexte. Dies kann sinnvoll sein, wenn das Projekt einige vordefinierte Klassen enthält (zum Beispiel eine fertige GUI), die von den Schüler:innen aber nicht bearbeitet werden sollen.\n\n.. code-block:: text\n\n    ~/\n    ├── wurzel/verzeichnis/\n    │   ├── .jml\n    │   ├── files/\n    │   │   ├── .gitignore\n    │   │   └── package.bluej\n    │   └── ProjektOrdner/\n    │       └── .jml\n    └── ausgabe/ordner\n\nInhalt von ``~/wurzel/verzeichnis/.jml``:\n\n.. code-block:: ini\n\n    [settings]\n    output dir = ~/ausgabe/ordner\n    opening tag = /*<aufg>\n    closing tag = </aufg>*/\n    opening ml tag = //<ml>\n    closing ml tag = //</ml>\n    name format = {project}-v{version}\n    create zip only = yes\n    additional files = ~/wurzel/verzeichnis/files/.gitignore,\n        ~/wurzel/verzeichnis/files/package.bluej\n\nInhalt von ``~/wurzel/verzeichnis/ProjektOrdner.jml``:\n\n.. code-block:: ini\n\n    project root = ~/wurzel/verzeichnis\n    +exclude = MyMailGUI.java,MyMailSettingsGUI.java\n    -exclude = *.class\n\n\nMit diesen Einstellungen kann ``jml`` zum Beispiel mit auch für ein HTML-prjekt genutzt werden:\n\n.. code-block:: text\n\n    ~/\n    ├── wurzel/verzeichnis/\n    │   ├── files/\n    │   │   ├── .gitignore\n    │   │   └── package.bluej\n    │   └── ProjektOrdner/\n    │   │   ├── .jml\n    │       └── index.html\n    └── ausgabe/ordner\n\nInhalt von ``~/wurzel/verzeichnis/ProjektOrdner/.jml``:\n\n.. code-block:: ini\n\n    [settings]\n    opening tag = <!--aufg\n    closing tag = aufg-->\n    opening ml tag = <!--ml\n    closing ml tag = ml-->\n    include = *.html,*.htm\n',
    'author': 'J. Neugebauer',
    'author_email': 'ngb@helmholtz-bi.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'http://github.com/jneug/jml',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
