# Autonomy Toolkit

Autonomy Toolkit, dubbed `autonomy-toolkit`, is meant to be a simplified mechansim for quickly setting up and developing a ROS 2 based control stack. The `autonomy-toolkit` platform is under activate development by the [Simulation Based Engineering Laboratory](https://sbel.wisc.edu) at the [University of Wisconsin-Madison](https://wisc.edu). 

## Background

The `autonomy-toolkit` platform provides the following resources for expediting development of autonomous algorithms:
1. A development workflow for writing and testing ROS 2 code
2. A mechansim for easily generating custom container-based images (think Docker) for use with the ROS 2 stack
3. A wrapper for container compose mechanisms (i.e. Docker Compose, singularity-compose) to improve user experience

Furthermore, the [Autonomy Research Testbed](https://github.com/uwsbel/autonomy-research-testbed), which utilizes this toolbox, provides the following functionality:
1. A parts list and instructions on how to build the physical platform
2. A high-fidelity simulation environment built using [Chrono](https://projectchrono.org) to test autonomous algorithms

For more information about the design considerations and purpose for this project, see the [background](https://projects.sbel.org/autonomy-toolkit/background.html) section.

## Support

Contact the [Simulation Based Engineering Laboratory](mailto:negrut@wisc.edu) for any questions or concerns regarding the contents of this repository.

## See Also

Visit our website at [sbel.wisc.edu](https://sbel.wisc.edu)!

<br>

<div>
	<img src="https://github.com/uwsbel/autonomy-toolkit/blob/master/docs/_static/SBEL-dark.png?raw=true" alt="Simulation Based Engineering Lab Logo" class="readme-img" height="100px">  
	<img src="https://github.com/uwsbel/autonomy-toolkit/blob/master/docs/_static/UWCrest.png?raw=true" alt="University of Wisconsin - Madison Crest" class="readme-img" height="100px" align="right">
</div>
