import {
  JupyterFrontEnd,
  JupyterFrontEndPlugin
} from '@jupyterlab/application';

import { ISettingRegistry } from '@jupyterlab/settingregistry';

import { requestAPI } from './handler';

/**
 * Initialization data for the serialhub extension.
 */
const plugin: JupyterFrontEndPlugin<void> = {
  id: 'serialhub:plugin',
  autoStart: true,
  optional: [],
  activate: (app: JupyterFrontEnd, settingRegistry: ISettingRegistry | null) => {
    console.log('JupyterLab extension serialhub is activated!');

    if (settingRegistry) {
      settingRegistry
        .load(plugin.id)
        .then(settings => {
          console.log('serialhub settings loaded:', settings.composite);
        })
        .catch(reason => {
          console.error('Failed to load settings for serialhub.', reason);
        });
    }

    requestAPI<any>('get_example')
      .then(data => {
        console.log(data);
      })
      .catch(reason => {
        console.error(
          `The serialhub server extension appears to be missing.\n${reason}`
        );
      });
  }
};

export default plugin;

export * from './version';
export * from './widget';
export * from './webseriallink';
