from typing import Tuple, Set, Iterable, List


class FieldSolver:
    def __init__(self, object: Object, method: IntPtr): ...
    def BeginInvoke(self, context: GH_Context, x: float, y: float, callback: AsyncCallback, object: Object) -> IAsyncResult: ...
    def EndInvoke(self, result: IAsyncResult) -> float: ...
    def Invoke(self, context: GH_Context, x: float, y: float) -> float: ...


class GH_CellInfo:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, nX: int, nY: int): ...
    @overload
    def __init__(self, nX: int, nY: int, na: float, nb: float, nc: float, nd: float): ...
    def DetermineMask(self, threshold: float) -> None: ...
    def DetermineRealBox(self, accuracy: float) -> None: ...


class GH_Context:
    def __init__(self): ...
    @overload
    def AddParticle(self, particle_x: float, particle_y: float) -> None: ...
    @overload
    def AddParticle(self, particle_x: float, particle_y: float, particle_charge: float, particle_radius: float) -> None: ...
    @overload
    def AddParticle(self, particle_x: float, particle_y: float, particle_z: float, particle_charge: float, particle_radius: float) -> None: ...
    @overload
    def ClosestParticle(self, sample_x: float, sample_y: float) -> Tuple[int, float]: ...
    @overload
    def ClosestParticle(self, sample_x: float, sample_y: float, sample_z: float) -> Tuple[int, float]: ...
    @property
    def Accuracy(self) -> float: ...
    @property
    def Affinity(self) -> float: ...
    @property
    def ParticleCount(self) -> int: ...
    @property
    def SolverDelegate(self) -> FieldSolver: ...
    def InverseSquareSolver(context: GH_Context, x: float, y: float) -> float: ...
    def Particle(self, index: int) -> GH_Particle: ...
    def Potential(self, x: float, y: float) -> float: ...
    def RemoveParticle(self, index: int) -> None: ...
    @Accuracy.setter
    def Accuracy(self, value: float) -> None: ...
    @Affinity.setter
    def Affinity(self, value: float) -> None: ...
    @SolverDelegate.setter
    def SolverDelegate(self, value: FieldSolver) -> None: ...
    def SineFallOffSolver(context: GH_Context, x: float, y: float) -> float: ...
    @overload
    def SolveIsoSurfaces(self, threshold: float) -> List: ...
    @overload
    def SolveIsoSurfaces(self, threshold: float) -> Tuple[List, GH_2DSparseArray]: ...


class GH_Direction:
    invalid = 0
    left = 1
    right = 2
    down = 3
    up = 4


class GH_IsoSurface:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, initial_capacity: int): ...
    @property
    def IsClosed(self) -> bool: ...
    def Smooth(self) -> None: ...


class GH_Mask:
    _0000 = 0
    _0001 = 1
    _0010 = 2
    _0011 = 3
    _0100 = 4
    _0101 = 5
    _0110 = 6
    _0111 = 7
    _1000 = 8
    _1001 = 9
    _1010 = 10
    _1011 = 11
    _1100 = 12
    _1101 = 13
    _1110 = 14
    _1111 = 15


class GH_Particle:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, nx: float, ny: float, nz: float, nc: float, nr: float): ...


class GH_Vertex:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, pt: PointF): ...
    @overload
    def __init__(self, other: GH_Vertex): ...
    @overload
    def __init__(self, vx: float, vy: float): ...
    def Equals(self, obj: Object) -> bool: ...
    def GetHashCode(self) -> int: ...
    def op_Equality(A: GH_Vertex, B: GH_Vertex) -> bool: ...
    def op_Inequality(A: GH_Vertex, B: GH_Vertex) -> bool: ...
