#  This file is part of OctoBot (https://github.com/Drakkar-Software/OctoBot)
#  Copyright (c) 2022 Drakkar-Software, All rights reserved.
#
#  OctoBot is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either
#  version 3.0 of the License, or (at your option) any later version.
#
#  OctoBot is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with OctoBot. If not, see <https://www.gnu.org/licenses/>.

from octobot.producers import interface_producer
from octobot.producers import exchange_producer
from octobot.producers import evaluator_producer
from octobot.producers import service_feed_producer

from octobot.producers.interface_producer import (
    InterfaceProducer,
)
from octobot.producers.exchange_producer import (
    ExchangeProducer,
)
from octobot.producers.evaluator_producer import (
    EvaluatorProducer,
)
from octobot.producers.service_feed_producer import (
    ServiceFeedProducer,
)

__all__ = [
    "InterfaceProducer",
    "ExchangeProducer",
    "EvaluatorProducer",
    "ServiceFeedProducer",
]
