# rlbot-twitch-broker-client
Allows custom Rocket League bots to register themselves with a central broker.

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import rlbot_twitch_broker_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import rlbot_twitch_broker_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import rlbot_twitch_broker_client
from rlbot_twitch_broker_client.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = rlbot_twitch_broker_client.ChatApi(rlbot_twitch_broker_client.ApiClient(configuration))
username = 'username_example' # str | 
message = 'message_example' # str | 

try:
    api_response = api_instance.send_chat(username, message)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ChatApi->send_chat: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to */*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ChatApi* | [**send_chat**](docs/ChatApi.md#send_chat) | **POST** /chat | 
*RegisterApi* | [**register_action_server**](docs/RegisterApi.md#register_action_server) | **POST** /register/actionServer | 
*StaticApi* | [**static_filename_get**](docs/StaticApi.md#static_filename_get) | **GET** /static/{filename} | 

## Documentation For Models

 - [ActionServerRegistration](docs/ActionServerRegistration.md)
 - [ApiResponse](docs/ApiResponse.md)
 - [ChatLine](docs/ChatLine.md)

## Documentation For Authorization

 All endpoints do not require authorization.


## Author

rlbotofficial@gmail.com
