# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import *

from ....api import Request as APIRequest, Response as APIResponse, set_timeout, set_tenant_key, set_user_access_token, set_path_params, \
    set_query_params, set_response_stream, set_is_response_stream, FormData, FormDataFile
from ....config import Config
from ....consts import ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_APP
from .model import *


class Service(object):
    def __init__(self, conf):
        # type: (Config) -> None
        self.conf = conf
        self.texts = TextService(self)
        



class TextService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def translate(self, body, tenant_key=None, timeout=None):
        # type: (TextTranslateReqBody, str, int) -> TextTranslateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return TextTranslateReqCall(self, body, request_opts=request_opts)

    def detect(self, body, tenant_key=None, timeout=None):
        # type: (TextDetectReqBody, str, int) -> TextDetectReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return TextDetectReqCall(self, body, request_opts=request_opts)



class TextTranslateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (TextService, TextTranslateReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> APIResponse[Type[TextTranslateResult]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/translation/v1/text/translate', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                        self.body, output_class=TextTranslateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class TextDetectReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (TextService, TextDetectReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> APIResponse[Type[TextDetectResult]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/translation/v1/text/detect', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                        self.body, output_class=TextDetectResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp

