# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import Callable

from ....config import Config
from ....context import Context
from ....event.event import set_event_callback

from .model import *


class FileDeletedEventHandler(object):
    def __init__(self, callback):
        # type: (Callable[[Context, Config, FileDeletedEvent], Any]) -> None
        self.handler = callback

    def handle(self, ctx, conf, event):  # type: (Context, Config, FileDeletedEvent) -> Any
        return self.handler(ctx, conf, event)

    @staticmethod
    def set_callback(conf, callback):
        # type: (Config, Callable[[Context, Config, FileDeletedEvent], Any]) -> None
        handler = FileDeletedEventHandler(callback)
        set_event_callback(conf, "drive.file.deleted_v1",
                          handler.handle, clazz=FileDeletedEvent)


class FilePermissionMemberAddedEventHandler(object):
    def __init__(self, callback):
        # type: (Callable[[Context, Config, FilePermissionMemberAddedEvent], Any]) -> None
        self.handler = callback

    def handle(self, ctx, conf, event):  # type: (Context, Config, FilePermissionMemberAddedEvent) -> Any
        return self.handler(ctx, conf, event)

    @staticmethod
    def set_callback(conf, callback):
        # type: (Config, Callable[[Context, Config, FilePermissionMemberAddedEvent], Any]) -> None
        handler = FilePermissionMemberAddedEventHandler(callback)
        set_event_callback(conf, "drive.file.permission_member_added_v1",
                          handler.handle, clazz=FilePermissionMemberAddedEvent)


class FilePermissionMemberRemovedEventHandler(object):
    def __init__(self, callback):
        # type: (Callable[[Context, Config, FilePermissionMemberRemovedEvent], Any]) -> None
        self.handler = callback

    def handle(self, ctx, conf, event):  # type: (Context, Config, FilePermissionMemberRemovedEvent) -> Any
        return self.handler(ctx, conf, event)

    @staticmethod
    def set_callback(conf, callback):
        # type: (Config, Callable[[Context, Config, FilePermissionMemberRemovedEvent], Any]) -> None
        handler = FilePermissionMemberRemovedEventHandler(callback)
        set_event_callback(conf, "drive.file.permission_member_removed_v1",
                          handler.handle, clazz=FilePermissionMemberRemovedEvent)


class FileReadEventHandler(object):
    def __init__(self, callback):
        # type: (Callable[[Context, Config, FileReadEvent], Any]) -> None
        self.handler = callback

    def handle(self, ctx, conf, event):  # type: (Context, Config, FileReadEvent) -> Any
        return self.handler(ctx, conf, event)

    @staticmethod
    def set_callback(conf, callback):
        # type: (Config, Callable[[Context, Config, FileReadEvent], Any]) -> None
        handler = FileReadEventHandler(callback)
        set_event_callback(conf, "drive.file.read_v1",
                          handler.handle, clazz=FileReadEvent)


class FileTitleUpdatedEventHandler(object):
    def __init__(self, callback):
        # type: (Callable[[Context, Config, FileTitleUpdatedEvent], Any]) -> None
        self.handler = callback

    def handle(self, ctx, conf, event):  # type: (Context, Config, FileTitleUpdatedEvent) -> Any
        return self.handler(ctx, conf, event)

    @staticmethod
    def set_callback(conf, callback):
        # type: (Config, Callable[[Context, Config, FileTitleUpdatedEvent], Any]) -> None
        handler = FileTitleUpdatedEventHandler(callback)
        set_event_callback(conf, "drive.file.title_updated_v1",
                          handler.handle, clazz=FileTitleUpdatedEvent)


class FileTrashedEventHandler(object):
    def __init__(self, callback):
        # type: (Callable[[Context, Config, FileTrashedEvent], Any]) -> None
        self.handler = callback

    def handle(self, ctx, conf, event):  # type: (Context, Config, FileTrashedEvent) -> Any
        return self.handler(ctx, conf, event)

    @staticmethod
    def set_callback(conf, callback):
        # type: (Config, Callable[[Context, Config, FileTrashedEvent], Any]) -> None
        handler = FileTrashedEventHandler(callback)
        set_event_callback(conf, "drive.file.trashed_v1",
                          handler.handle, clazz=FileTrashedEvent)


class FileEditEventHandler(object):
    def __init__(self, callback):
        # type: (Callable[[Context, Config, FileEditEvent], Any]) -> None
        self.handler = callback

    def handle(self, ctx, conf, event):  # type: (Context, Config, FileEditEvent) -> Any
        return self.handler(ctx, conf, event)

    @staticmethod
    def set_callback(conf, callback):
        # type: (Config, Callable[[Context, Config, FileEditEvent], Any]) -> None
        handler = FileEditEventHandler(callback)
        set_event_callback(conf, "drive.file.edit_v1",
                          handler.handle, clazz=FileEditEvent)
