# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import *

from ....api import Request as APIRequest, Response as APIResponse, set_timeout, set_tenant_key, set_user_access_token, set_path_params, \
    set_query_params, set_response_stream, set_is_response_stream, FormData, FormDataFile
from ....config import Config
from ....consts import ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_APP
from .model import *


class Service(object):
    def __init__(self, conf):
        # type: (Config) -> None
        self.conf = conf
        self.admin_dept_stats = AdminDeptStatService(self)
        self.admin_user_stats = AdminUserStatService(self)
        



class AdminDeptStatService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def list(self, tenant_key=None, timeout=None):
        # type: (str, int) -> AdminDeptStatListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return AdminDeptStatListReqCall(self, request_opts=request_opts)


class AdminUserStatService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def list(self, tenant_key=None, timeout=None):
        # type: (str, int) -> AdminUserStatListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return AdminUserStatListReqCall(self, request_opts=request_opts)



class AdminDeptStatListReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (AdminDeptStatService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_department_id_type(self, department_id_type):
        # type: (str) -> AdminDeptStatListReqCall
        self.query_params['department_id_type'] = department_id_type
        return self

    def set_start_date(self, start_date):
        # type: (str) -> AdminDeptStatListReqCall
        self.query_params['start_date'] = start_date
        return self

    def set_end_date(self, end_date):
        # type: (str) -> AdminDeptStatListReqCall
        self.query_params['end_date'] = end_date
        return self

    def set_department_id(self, department_id):
        # type: (str) -> AdminDeptStatListReqCall
        self.query_params['department_id'] = department_id
        return self

    def set_contains_child_dept(self, contains_child_dept):
        # type: (bool) -> AdminDeptStatListReqCall
        self.query_params['contains_child_dept'] = contains_child_dept
        return self

    def set_page_size(self, page_size):
        # type: (int) -> AdminDeptStatListReqCall
        self.query_params['page_size'] = page_size
        return self

    def set_page_token(self, page_token):
        # type: (str) -> AdminDeptStatListReqCall
        self.query_params['page_token'] = page_token
        return self

    def do(self):
        # type: () -> APIResponse[Type[AdminDeptStatListResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/admin/v1/admin_dept_stats', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                        None, output_class=AdminDeptStatListResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class AdminUserStatListReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (AdminUserStatService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id_type(self, user_id_type):
        # type: (str) -> AdminUserStatListReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def set_department_id_type(self, department_id_type):
        # type: (str) -> AdminUserStatListReqCall
        self.query_params['department_id_type'] = department_id_type
        return self

    def set_start_date(self, start_date):
        # type: (str) -> AdminUserStatListReqCall
        self.query_params['start_date'] = start_date
        return self

    def set_end_date(self, end_date):
        # type: (str) -> AdminUserStatListReqCall
        self.query_params['end_date'] = end_date
        return self

    def set_department_id(self, department_id):
        # type: (str) -> AdminUserStatListReqCall
        self.query_params['department_id'] = department_id
        return self

    def set_user_id(self, user_id):
        # type: (str) -> AdminUserStatListReqCall
        self.query_params['user_id'] = user_id
        return self

    def set_page_size(self, page_size):
        # type: (int) -> AdminUserStatListReqCall
        self.query_params['page_size'] = page_size
        return self

    def set_page_token(self, page_token):
        # type: (str) -> AdminUserStatListReqCall
        self.query_params['page_token'] = page_token
        return self

    def do(self):
        # type: () -> APIResponse[Type[AdminUserStatListResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/admin/v1/admin_user_stats', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                        None, output_class=AdminUserStatListResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp

