# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import List, Dict, Any
from ....utils.dt import to_json_decorator
from ....event.model.event import *
import attr




@to_json_decorator
@attr.s
class Feature(object):
    card = attr.ib(type=int, default=None, metadata={'json': 'card'})
    face_uploaded = attr.ib(type=bool, default=None, metadata={'json': 'face_uploaded'})


@to_json_decorator
@attr.s
class User(object):
    feature = attr.ib(type=Feature, default=None, metadata={'json': 'feature'})
    user_id = attr.ib(type=str, default=None, metadata={'json': 'user_id'})


@to_json_decorator
@attr.s
class UserId(object):
    user_id = attr.ib(type=str, default=None, metadata={'json': 'user_id'})
    open_id = attr.ib(type=str, default=None, metadata={'json': 'open_id'})
    union_id = attr.ib(type=str, default=None, metadata={'json': 'union_id'})


@to_json_decorator
@attr.s
class Device(object):
    __int_to_string_fields__ = attr.ib(type=List[str], default=["device_id"])
    device_id = attr.ib(type=int, default=None, metadata={'json': 'device_id'})
    device_name = attr.ib(type=str, default=None, metadata={'json': 'device_name'})
    device_sn = attr.ib(type=str, default=None, metadata={'json': 'device_sn'})


@to_json_decorator
@attr.s
class AccessRecord(object):
    __int_to_string_fields__ = attr.ib(type=List[str], default=["access_record_id", "device_id", "access_time"])
    access_record_id = attr.ib(type=int, default=None, metadata={'json': 'access_record_id'})
    user_id = attr.ib(type=str, default=None, metadata={'json': 'user_id'})
    device_id = attr.ib(type=int, default=None, metadata={'json': 'device_id'})
    is_clock_in = attr.ib(type=bool, default=None, metadata={'json': 'is_clock_in'})
    access_time = attr.ib(type=int, default=None, metadata={'json': 'access_time'})
    access_type = attr.ib(type=str, default=None, metadata={'json': 'access_type'})
    access_data = attr.ib(type=str, default=None, metadata={'json': 'access_data'})
    is_door_open = attr.ib(type=bool, default=None, metadata={'json': 'is_door_open'})


@attr.s
class AccessRecordListResult(object):
    items = attr.ib(type=List[AccessRecord], default=None, metadata={'json': 'items'})
    page_token = attr.ib(type=str, default=None, metadata={'json': 'page_token'})
    has_more = attr.ib(type=bool, default=None, metadata={'json': 'has_more'})





@attr.s
class DeviceListResult(object):
    items = attr.ib(type=List[Device], default=None, metadata={'json': 'items'})





@attr.s
class UserGetResult(object):
    user = attr.ib(type=User, default=None, metadata={'json': 'user'})



@attr.s
class UserListResult(object):
    items = attr.ib(type=List[User], default=None, metadata={'json': 'items'})
    page_token = attr.ib(type=str, default=None, metadata={'json': 'page_token'})
    has_more = attr.ib(type=bool, default=None, metadata={'json': 'has_more'})






@attr.s
class AccessRecordCreatedEventData(object):
    access_record_id = attr.ib(type=str, default=None, metadata={'json': 'access_record_id'})
    user_id = attr.ib(type=UserId, default=None, metadata={'json': 'user_id'})
    device_id = attr.ib(type=str, default=None, metadata={'json': 'device_id'})
    is_clock_in = attr.ib(type=bool, default=None, metadata={'json': 'is_clock_in'})
    is_door_open = attr.ib(type=bool, default=None, metadata={'json': 'is_door_open'})
    access_time = attr.ib(type=str, default=None, metadata={'json': 'access_time'})


@attr.s
class AccessRecordCreatedEvent(BaseEventV2):
    event = attr.ib(type=AccessRecordCreatedEventData, default=None)



@attr.s
class UserUpdatedEventData(object):
    user_id = attr.ib(type=UserId, default=None, metadata={'json': 'user_id'})
    card = attr.ib(type=int, default=None, metadata={'json': 'card'})
    face_uploaded = attr.ib(type=bool, default=None, metadata={'json': 'face_uploaded'})


@attr.s
class UserUpdatedEvent(BaseEventV2):
    event = attr.ib(type=UserUpdatedEventData, default=None)
