/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object;

import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.HObject;

public abstract class Group
extends HObject {
    private List memberList;
    protected Group parent;
    protected int nMembersInFile;

    public Group(FileFormat fileFormat, String string, String string2, Group group) {
        this(fileFormat, string, string2, group, null);
    }

    public Group(FileFormat fileFormat, String string, String string2, Group group, long[] lArray) {
        super(fileFormat, string, string2, lArray);
        this.parent = group;
    }

    public void clear() {
        if (this.memberList != null) {
            ((Vector)this.memberList).setSize(0);
        }
    }

    public void addToMemberList(HObject hObject) {
        if (this.memberList == null) {
            int n = Math.min(this.getNumberOfMembersInFile(), this.getFileFormat().getMaxMembers());
            this.memberList = new Vector(n + 5);
        }
        if (hObject != null && !this.memberList.contains(hObject)) {
            this.memberList.add(hObject);
        }
    }

    public void removeFromMemberList(HObject hObject) {
        if (this.memberList != null) {
            this.memberList.remove(hObject);
        }
    }

    public List getMemberList() {
        FileFormat fileFormat = this.getFileFormat();
        String string = this.getPath();
        String string2 = this.getName();
        if (this.memberList == null && fileFormat != null) {
            int n = Math.min(this.getNumberOfMembersInFile(), this.getFileFormat().getMaxMembers());
            this.memberList = new Vector(n + 5);
            try {
                fileFormat.open();
            }
            catch (Exception exception) {
                // empty catch block
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)fileFormat.getRootNode();
            if (defaultMutableTreeNode == null) {
                return this.memberList;
            }
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
            Group group = null;
            Object object = null;
            while (enumeration.hasMoreElements()) {
                object = ((DefaultMutableTreeNode)enumeration.nextElement()).getUserObject();
                if (!(object instanceof Group) || (group = (Group)object).getPath() == null || (!this.isRoot() || !group.isRoot()) && (!string.equals(group.getPath()) || !group.getName().endsWith(string2))) continue;
                this.memberList = group.getMemberList();
                break;
            }
        }
        return this.memberList;
    }

    @Override
    public void setName(String string) throws Exception {
        super.setName(string);
        if (this.memberList != null) {
            int n = this.memberList.size();
            HObject hObject = null;
            for (int i = 0; i < n; ++i) {
                hObject = (HObject)this.memberList.get(i);
                hObject.setPath(this.getPath() + string + "/");
            }
        }
    }

    public final Group getParent() {
        return this.parent;
    }

    public final boolean isRoot() {
        return this.parent == null;
    }

    public int getNumberOfMembersInFile() {
        return this.nMembersInFile;
    }
}

