/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object;

import java.util.List;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.HObject;

public abstract class Datatype
extends HObject {
    public static final int NATIVE = -1;
    public static final int CLASS_NO_CLASS = -1;
    public static final int CLASS_INTEGER = 0;
    public static final int CLASS_FLOAT = 1;
    public static final int CLASS_CHAR = 2;
    public static final int CLASS_STRING = 3;
    public static final int CLASS_BITFIELD = 4;
    public static final int CLASS_OPAQUE = 5;
    public static final int CLASS_COMPOUND = 6;
    public static final int CLASS_REFERENCE = 7;
    public static final int CLASS_ENUM = 8;
    public static final int CLASS_VLEN = 9;
    public static final int CLASS_ARRAY = 10;
    public static final int ORDER_LE = 0;
    public static final int ORDER_BE = 1;
    public static final int ORDER_VAX = 2;
    public static final int ORDER_NONE = 3;
    public static final int SIGN_NONE = 0;
    public static final int SIGN_2 = 1;
    public static final int NSGN = 2;
    protected int datatypeClass;
    protected int datatypeSize;
    protected int datatypeOrder;
    protected int datatypeSign;
    protected String enumMembers;
    protected Datatype baseType;
    protected int[] dims;

    public Datatype(FileFormat fileFormat, String string, String string2) {
        this(fileFormat, string, string2, null);
    }

    public Datatype(FileFormat fileFormat, String string, String string2, long[] lArray) {
        super(fileFormat, string, string2, lArray);
    }

    public Datatype(int n, int n2, int n3, int n4) {
        this.datatypeClass = n;
        this.datatypeSize = n2;
        this.datatypeOrder = n3;
        this.datatypeSign = n4;
        this.enumMembers = null;
        this.baseType = null;
        this.dims = null;
    }

    public Datatype(int n) {
        this(-1, -1, -1, -1);
        this.fromNative(n);
    }

    public int getDatatypeClass() {
        return this.datatypeClass;
    }

    public int getDatatypeSize() {
        return this.datatypeSize;
    }

    public int getDatatypeOrder() {
        return this.datatypeOrder;
    }

    public int getDatatypeSign() {
        return this.datatypeSign;
    }

    public Datatype getBasetype() {
        return this.baseType;
    }

    public final void setEnumMembers(String string) {
        this.enumMembers = string;
    }

    public final String getEnumMembers() {
        return this.enumMembers;
    }

    public abstract int toNative();

    public abstract void fromNative(int var1);

    public String getDatatypeDescription() {
        String string = "Unknown";
        switch (this.datatypeClass) {
            case 0: {
                if (this.datatypeSign == 0) {
                    string = String.valueOf(this.datatypeSize * 8) + "-bit unsigned integer";
                    break;
                }
                string = String.valueOf(this.datatypeSize * 8) + "-bit integer";
                break;
            }
            case 1: {
                string = String.valueOf(this.datatypeSize * 8) + "-bit floating-point";
                break;
            }
            case 3: {
                string = "String";
                break;
            }
            case 7: {
                string = "Object reference";
                break;
            }
            case 4: {
                string = "Bitfield";
                break;
            }
            case 8: {
                string = "enum";
                break;
            }
            case 10: {
                string = "Array";
                break;
            }
            case 6: {
                string = "Compound ";
                break;
            }
            case 9: {
                string = "Variable-length";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    public abstract boolean isUnsigned();

    @Override
    public int open() {
        return -1;
    }

    @Override
    public abstract void close(int var1);

    @Override
    public List getMetadata() throws Exception {
        return null;
    }

    @Override
    public void writeMetadata(Object object) throws Exception {
    }

    @Override
    public void removeMetadata(Object object) throws Exception {
    }
}

