/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object;

import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;

public abstract class CompoundDS
extends Dataset {
    public static final String separator = "\u0095";
    protected int numberOfMembers = 0;
    protected String[] memberNames = null;
    protected int[] memberOrders;
    protected Object[] memberDims;
    protected Datatype[] memberTypes = null;
    protected boolean[] isMemberSelected = null;

    public CompoundDS(FileFormat fileFormat, String string, String string2) {
        this(fileFormat, string, string2, null);
    }

    public CompoundDS(FileFormat fileFormat, String string, String string2, long[] lArray) {
        super(fileFormat, string, string2, lArray);
    }

    public final int getMemberCount() {
        return this.numberOfMembers;
    }

    public final int getSelectedMemberCount() {
        int n = 0;
        if (this.isMemberSelected != null) {
            for (int i = 0; i < this.isMemberSelected.length; ++i) {
                if (!this.isMemberSelected[i]) continue;
                ++n;
            }
        }
        return n;
    }

    public final String[] getMemberNames() {
        return this.memberNames;
    }

    public final boolean isMemberSelected(int n) {
        if (this.isMemberSelected != null && this.isMemberSelected.length > n) {
            return this.isMemberSelected[n];
        }
        return false;
    }

    public final void selectMember(int n) {
        if (this.isMemberSelected != null && this.isMemberSelected.length > n) {
            this.isMemberSelected[n] = true;
        }
    }

    public final void setMemberSelection(boolean bl) {
        if (this.isMemberSelected == null) {
            return;
        }
        for (int i = 0; i < this.isMemberSelected.length; ++i) {
            this.isMemberSelected[i] = bl;
        }
    }

    public final int[] getMemberOrders() {
        return this.memberOrders;
    }

    public final int[] getSelectedMemberOrders() {
        if (this.isMemberSelected == null) {
            return this.memberOrders;
        }
        int n = 0;
        int[] nArray = new int[this.getSelectedMemberCount()];
        for (int i = 0; i < this.isMemberSelected.length; ++i) {
            if (!this.isMemberSelected[i]) continue;
            nArray[n++] = this.memberOrders[i];
        }
        return nArray;
    }

    public final int[] getMemeberDims(int n) {
        if (this.memberDims == null) {
            return null;
        }
        return (int[])this.memberDims[n];
    }

    public final Datatype[] getMemberTypes() {
        return this.memberTypes;
    }

    public final Datatype[] getSelectedMemberTypes() {
        if (this.isMemberSelected == null) {
            return this.memberTypes;
        }
        int n = 0;
        Datatype[] datatypeArray = new Datatype[this.getSelectedMemberCount()];
        for (int i = 0; i < this.isMemberSelected.length; ++i) {
            if (!this.isMemberSelected[i]) continue;
            datatypeArray[n++] = this.memberTypes[i];
        }
        return datatypeArray;
    }

    @Override
    public Dataset copy(Group group, String string, long[] lArray, Object object) throws Exception {
        throw new UnsupportedOperationException("Writing a subset of a compound dataset to a new dataset is not implemented.");
    }
}

