/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.hdf5lib;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.HDF5GroupInfo;
import ncsa.hdf.hdf5lib.HDFArray;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;

public class H5 {
    public static final String H5PATH_PROPERTY_KEY = "ncsa.hdf.hdf5lib.H5.hdf5lib";
    public static final String H5_LIBRARY_NAME_PROPERTY_KEY = "ncsa.hdf.hdf5lib.H5.loadLibraryName";
    private static Logger s_logger;
    private static String s_libraryName;

    public static synchronized native int J2C(int var0);

    public static synchronized native int H5error_off();

    public static synchronized native int H5open() throws HDF5LibraryException;

    public static synchronized native int H5close() throws HDF5LibraryException;

    private static synchronized native int H5dont_atexit() throws HDF5LibraryException;

    public static synchronized native int H5get_libversion(int[] var0) throws HDF5LibraryException;

    public static synchronized native int H5check_version(int var0, int var1, int var2);

    public static synchronized native int H5garbage_collect() throws HDF5LibraryException;

    public static synchronized native int H5Eclear() throws HDF5LibraryException;

    public static synchronized native int H5Acreate(int var0, String var1, int var2, int var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Aopen_name(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Aopen_idx(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Awrite(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Awrite(int n, int n2, Object object) throws HDF5Exception, NullPointerException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.byteify();
        int n3 = H5.H5Awrite(n, n2, byArray);
        byArray = null;
        hDFArray = null;
        return n3;
    }

    public static synchronized native int H5Acopy(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Aread(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Aread(int n, int n2, Object object) throws HDF5Exception, NullPointerException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.emptyBytes();
        int n3 = H5.H5Aread(n, n2, byArray);
        if (n3 >= 0) {
            object = hDFArray.arrayify(byArray);
        }
        return n3;
    }

    public static synchronized native int H5AreadVL(int var0, int var1, String[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Aget_space(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Aget_type(int var0) throws HDF5LibraryException;

    public static synchronized native long H5Aget_name(int var0, long var1, String[] var3) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Aget_num_attrs(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Adelete(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Aclose(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Dcreate(int var0, String var1, int var2, int var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dopen(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dchdir_ext(String var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dgetdir_ext(String[] var0, int var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dget_space(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Dget_type(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Dget_create_plist(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Dread(int var0, int var1, int var2, int var3, int var4, byte[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5DreadVL(int var0, int var1, int var2, int var3, int var4, Object[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dread(int n, int n2, int n3, int n4, int n5, Object object) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        int n6 = -1;
        boolean bl = false;
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            throw new HDF5JavaException("H5Dread: data is not an array");
        }
        String string = clazz.getName();
        bl = string.lastIndexOf(91) == string.indexOf(91);
        char c = string.charAt(string.lastIndexOf("[") + 1);
        if (bl && c == 'B') {
            n6 = H5.H5Dread(n, n2, n3, n4, n5, (byte[])object);
        } else if (bl && c == 'S') {
            n6 = H5.H5Dread_short(n, n2, n3, n4, n5, (short[])object);
        } else if (bl && c == 'I') {
            n6 = H5.H5Dread_int(n, n2, n3, n4, n5, (int[])object);
        } else if (bl && c == 'J') {
            n6 = H5.H5Dread_long(n, n2, n3, n4, n5, (long[])object);
        } else if (bl && c == 'F') {
            n6 = H5.H5Dread_float(n, n2, n3, n4, n5, (float[])object);
        } else if (bl && c == 'D') {
            n6 = H5.H5Dread_double(n, n2, n3, n4, n5, (double[])object);
        } else if (H5.H5Tequal(n2, HDF5Constants.H5T_STD_REF_DSETREG)) {
            n6 = H5.H5Dread_reg_ref(n, n2, n3, n4, n5, (String[])object);
        } else if (bl && clazz.getComponentType() == String.class) {
            n6 = H5.H5Tis_variable_str(n2) ? H5.H5DreadVL(n, n2, n3, n4, n5, (Object[])object) : H5.H5Dread_string(n, n2, n3, n4, n5, (String[])object);
        } else {
            HDFArray hDFArray = new HDFArray(object);
            byte[] byArray = hDFArray.emptyBytes();
            n6 = H5.H5Dread(n, n2, n3, n4, n5, byArray);
            if (n6 >= 0) {
                object = hDFArray.arrayify(byArray);
            }
            byArray = null;
            hDFArray = null;
        }
        return n6;
    }

    public static synchronized native int H5DwriteString(int var0, int var1, int var2, int var3, int var4, String[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dwrite(int var0, int var1, int var2, int var3, int var4, byte[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dwrite(int n, int n2, int n3, int n4, int n5, Object object) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        int n6 = -1;
        boolean bl = false;
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            throw new HDF5JavaException("H5Dread: data is not an array");
        }
        String string = clazz.getName();
        bl = string.lastIndexOf(91) == string.indexOf(91);
        char c = string.charAt(string.lastIndexOf("[") + 1);
        if (bl && c == 'B') {
            n6 = H5.H5Dwrite(n, n2, n3, n4, n5, (byte[])object);
        } else if (bl && c == 'S') {
            n6 = H5.H5Dwrite_short(n, n2, n3, n4, n5, (short[])object);
        } else if (bl && c == 'I') {
            n6 = H5.H5Dwrite_int(n, n2, n3, n4, n5, (int[])object);
        } else if (bl && c == 'J') {
            n6 = H5.H5Dwrite_long(n, n2, n3, n4, n5, (long[])object);
        } else if (bl && c == 'F') {
            n6 = H5.H5Dwrite_float(n, n2, n3, n4, n5, (float[])object);
        } else if (bl && c == 'D') {
            n6 = H5.H5Dwrite_double(n, n2, n3, n4, n5, (double[])object);
        } else if (H5.H5Tget_class(n2) == HDF5Constants.H5T_STRING && H5.H5Tis_variable_str(n2) && clazz.isArray() && clazz.getComponentType() == String.class && bl) {
            n6 = H5.H5DwriteString(n, n2, n3, n4, n5, (String[])object);
        } else {
            HDFArray hDFArray = new HDFArray(object);
            byte[] byArray = hDFArray.byteify();
            n6 = H5.H5Dwrite(n, n2, n3, n4, n5, byArray);
            byArray = null;
            hDFArray = null;
        }
        return n6;
    }

    public static synchronized native int H5Dextend(int var0, byte[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dextend(int n, long[] lArray) throws HDF5Exception, NullPointerException {
        int n2 = -1;
        HDFArray hDFArray = new HDFArray(lArray);
        byte[] byArray = hDFArray.byteify();
        n2 = H5.H5Dextend(n, byArray);
        byArray = null;
        hDFArray = null;
        return n2;
    }

    public static synchronized native int H5Dclose(int var0) throws HDF5LibraryException;

    public static synchronized native long H5Dget_storage_size(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Dcopy(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Dvlen_get_buf_size(int var0, int var1, int var2, int[] var3) throws HDF5LibraryException;

    public static synchronized native int H5Dvlen_reclaim(int var0, int var1, int var2, byte[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Fopen(String var0, int var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Fcreate(String var0, int var1, int var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Fflush(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native boolean H5Fis_hdf5(String var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Fget_create_plist(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Fget_access_plist(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Fclose(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Fmount(int var0, String var1, int var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Funmount(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Freopen(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Gcreate(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Gopen(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Gclose(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Glink(int var0, int var1, String var2, String var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Glink2(int var0, String var1, int var2, int var3, String var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Gunlink(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Gmove(int var0, String var1, String var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Gget_linkval(int var0, String var1, int var2, String[] var3) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Gset_comment(int var0, String var1, String var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Gget_comment(int var0, String var1, int var2, String[] var3) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Iget_type(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pcreate(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pclose(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pget_class(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pcopy(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pget_version(int var0, int[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_userblock(int var0, long var1) throws HDF5LibraryException;

    public static synchronized native int H5Pget_userblock(int var0, long[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_small_data_block_size(int var0, long var1) throws HDF5LibraryException;

    public static synchronized native int H5Pget_small_data_block_size(int var0, long[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_sizes(int var0, int var1, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_sizes(int var0, int[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_sym_k(int var0, int var1, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_sym_k(int var0, int[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_istore_k(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Pget_istore_k(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_layout(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Pget_layout(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_chunk(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized int H5Pset_chunk(int n, int n2, long[] lArray) throws HDF5Exception, NullPointerException, IllegalArgumentException {
        if (lArray == null) {
            return -1;
        }
        HDFArray hDFArray = new HDFArray(lArray);
        byte[] byArray = hDFArray.byteify();
        int n3 = H5.H5Pset_chunk(n, n2, byArray);
        byArray = null;
        hDFArray = null;
        return n3;
    }

    public static synchronized native int H5Pget_chunk(int var0, int var1, long[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_alignment(int var0, long var1, long var3) throws HDF5LibraryException;

    public static synchronized native int H5Pget_alignment(int var0, long[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_external(int var0, String var1, long var2, long var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_external_count(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pget_external(int var0, int var1, int var2, String[] var3, long[] var4) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_fill_value(int var0, int var1, byte[] var2) throws HDF5Exception;

    public static synchronized int H5Pset_fill_value(int n, int n2, Object object) throws HDF5Exception {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.byteify();
        int n3 = H5.H5Pset_fill_value(n, n2, byArray);
        byArray = null;
        hDFArray = null;
        return n3;
    }

    public static synchronized native int H5Pget_fill_value(int var0, int var1, byte[] var2) throws HDF5Exception;

    public static synchronized int H5Pget_fill_value(int n, int n2, Object object) throws HDF5Exception {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.emptyBytes();
        int n3 = H5.H5Pget_fill_value(n, n2, byArray);
        if (n3 >= 0) {
            object = hDFArray.arrayify(byArray);
        }
        return n3;
    }

    public static synchronized native int H5Pset_filter(int var0, int var1, int var2, int var3, int[] var4) throws HDF5LibraryException;

    public static synchronized native int H5Pget_nfilters(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pget_filter(int var0, int var1, int[] var2, int[] var3, int[] var4, int var5, String[] var6) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_cache(int var0, int var1, int var2, int var3, double var4) throws HDF5LibraryException;

    public static synchronized native int H5Pget_cache(int var0, int[] var1, int[] var2, int[] var3, double[] var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_buffer(int var0, int var1, byte[] var2, byte[] var3) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_buffer(int var0, byte[] var1, byte[] var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pset_preserve(int var0, boolean var1) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_preserve(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_deflate(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Pset_gc_references(int var0, boolean var1) throws HDF5LibraryException;

    public static synchronized native int H5Pget_gc_references(int var0, boolean[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Pget_gc_reference(int n, boolean[] blArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Pget_gc_references(n, blArray);
    }

    public static synchronized native int H5Pset_btree_ratios(int var0, double var1, double var3, double var5) throws HDF5LibraryException;

    public static synchronized native int H5Pget_btree_ratios(int var0, double[] var1, double[] var2, double[] var3) throws HDF5LibraryException, NullPointerException;

    private static synchronized native int H5Rcreate(byte[] var0, int var1, String var2, int var3, int var4) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized byte[] H5Rcreate(int n, String string, int n2, int n3) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        int n4 = 8;
        if (n2 == HDF5Constants.H5R_DATASET_REGION) {
            n4 = 12;
        }
        byte[] byArray = new byte[n4];
        H5.H5Rcreate(byArray, n, string, n2, n3);
        return byArray;
    }

    public static synchronized native int H5Rdereference(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Rget_region(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Rget_obj_type(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Screate(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Screate_simple(int var0, byte[] var1, byte[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Screate_simple(int n, long[] lArray, long[] lArray2) throws HDF5Exception, NullPointerException {
        if (lArray == null) {
            return -1;
        }
        HDFArray hDFArray = new HDFArray(lArray);
        byte[] byArray = hDFArray.byteify();
        byte[] byArray2 = null;
        HDFArray hDFArray2 = null;
        if (lArray2 != null) {
            hDFArray2 = new HDFArray(lArray2);
            byArray2 = hDFArray2.byteify();
        }
        int n2 = H5.H5Screate_simple(n, byArray, byArray2);
        byArray = null;
        byArray2 = null;
        hDFArray2 = null;
        hDFArray = null;
        return n2;
    }

    public static synchronized native int H5Scopy(int var0) throws HDF5LibraryException;

    private static synchronized native int H5Sselect_elements(int var0, int var1, int var2, byte[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Sselect_elements(int n, int n2, int n3, long[][] lArray) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        if (lArray == null) {
            return -1;
        }
        HDFArray hDFArray = new HDFArray(lArray);
        byte[] byArray = hDFArray.byteify();
        int n4 = H5.H5Sselect_elements(n, n2, n3, byArray);
        byArray = null;
        hDFArray = null;
        return n4;
    }

    public static synchronized native int H5Sselect_all(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Sselect_none(int var0) throws HDF5LibraryException;

    public static synchronized native boolean H5Sselect_valid(int var0) throws HDF5LibraryException;

    public static synchronized native long H5Sget_simple_extent_npoints(int var0) throws HDF5LibraryException;

    public static synchronized native long H5Sget_select_npoints(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Sget_simple_extent_ndims(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Sget_simple_extent_dims(int var0, long[] var1, long[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Sget_simple_extent_type(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Sset_extent_simple(int var0, int var1, byte[] var2, byte[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Sset_extent_simple(int n, int n2, long[] lArray, long[] lArray2) throws HDF5Exception, NullPointerException {
        if (lArray == null) {
            return -1;
        }
        HDFArray hDFArray = new HDFArray(lArray);
        byte[] byArray = hDFArray.byteify();
        byte[] byArray2 = null;
        HDFArray hDFArray2 = null;
        if (lArray2 != null) {
            hDFArray2 = new HDFArray(lArray2);
            byArray2 = hDFArray2.byteify();
        }
        int n3 = H5.H5Screate_simple(n2, byArray, byArray2);
        byArray = null;
        byArray2 = null;
        hDFArray2 = null;
        hDFArray = null;
        return n3;
    }

    public static synchronized native boolean H5Sis_simple(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Soffset_simple(int var0, byte[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Soffset_simple(int n, long[] lArray) throws HDF5Exception, NullPointerException {
        if (lArray == null) {
            return -1;
        }
        HDFArray hDFArray = new HDFArray(lArray);
        byte[] byArray = hDFArray.byteify();
        int n2 = H5.H5Soffset_simple(n, byArray);
        byArray = null;
        hDFArray = null;
        return n2;
    }

    public static synchronized native int H5Sextent_copy(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Sset_extent_none(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Sselect_hyperslab(int var0, int var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized int H5Sselect_hyperslab(int n, int n2, long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4) throws HDF5Exception, NullPointerException, IllegalArgumentException {
        Object object;
        Object object2;
        Object object3;
        byte[] byArray = null;
        if (lArray != null) {
            object3 = new HDFArray(lArray);
            byArray = ((HDFArray)object3).byteify();
            object3 = null;
        }
        object3 = null;
        if (lArray3 != null) {
            object2 = new HDFArray(lArray3);
            object3 = ((HDFArray)object2).byteify();
            object2 = null;
        }
        object2 = null;
        if (lArray2 != null) {
            object = new HDFArray(lArray2);
            object2 = ((HDFArray)object).byteify();
            object = null;
        }
        object = null;
        if (lArray4 != null) {
            HDFArray hDFArray = new HDFArray(lArray4);
            object = hDFArray.byteify();
            hDFArray = null;
        }
        int n3 = H5.H5Sselect_hyperslab(n, n2, byArray, (byte[])object2, (byte[])object3, (byte[])object);
        byArray = null;
        object2 = null;
        object3 = null;
        object = null;
        return n3;
    }

    public static synchronized native int H5Sclose(int var0) throws HDF5LibraryException;

    public static synchronized native long H5Sget_select_hyper_nblocks(int var0) throws HDF5LibraryException;

    public static synchronized native long H5Sget_select_elem_npoints(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Sget_select_hyper_blocklist(int var0, long var1, long var3, long[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Sget_select_elem_pointlist(int var0, long var1, long var3, long[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Sget_select_bounds(int var0, long[] var1, long[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Topen(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Tcommit(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Tcommitted(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tcreate(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tcopy(int var0) throws HDF5LibraryException;

    public static synchronized native boolean H5Tequal(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tlock(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tget_class(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tget_size(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_size(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tget_order(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_order(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tget_precision(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_precision(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tget_offset(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_offset(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tget_pad(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Tset_pad(int var0, int var1, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Tget_sign(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_sign(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tget_fields(int var0, int[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Tset_fields(int var0, int var1, int var2, int var3, int var4, int var5) throws HDF5LibraryException;

    public static synchronized native int H5Tget_ebias(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_ebias(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tget_norm(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_norm(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tget_inpad(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_inpad(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tget_cset(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_cset(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tget_strpad(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_strpad(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tget_nmembers(int var0) throws HDF5LibraryException;

    public static synchronized native String H5Tget_member_name(int var0, int var1);

    public static synchronized native int H5Tget_member_index(int var0, String var1);

    public static synchronized native int H5Tget_member_class(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tget_member_type(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native long H5Tget_member_offset(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tinsert(int var0, String var1, long var2, int var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Tpack(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tclose(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tenum_create(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tenum_insert(int var0, String var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Tenum_insert(int n, String string, int n2) throws HDF5LibraryException, NullPointerException {
        int[] nArray = new int[]{n2};
        return H5.H5Tenum_insert(n, string, nArray);
    }

    public static synchronized native int H5Tenum_nameof(int var0, int[] var1, String[] var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Tenum_valueof(int var0, String var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Tvlen_create(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_tag(int var0, String var1) throws HDF5LibraryException;

    public static synchronized native String H5Tget_tag(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tget_super(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tget_member_value(int var0, int var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Tarray_create(int var0, int var1, int[] var2, int[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Tget_array_ndims(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Tget_array_dims(int var0, int[] var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Gget_num_objs(int var0, long[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Gget_objname_by_idx(int var0, long var1, String[] var3, long var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Gget_objtype_by_idx(int var0, long var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Tget_native_type(int var0, int var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Gn_members(int n, String string) throws HDF5LibraryException, NullPointerException {
        int n2 = H5.H5Gopen(n, string);
        long[] lArray = new long[]{-1L};
        int n3 = H5.H5Gget_num_objs(n2, lArray);
        int n4 = new Long(lArray[0]).intValue();
        return n4;
    }

    public static synchronized int H5Gget_obj_info_idx(int n, String string, int n2, String[] stringArray, int[] nArray) throws HDF5LibraryException, NullPointerException {
        long l = 4096L;
        String[] stringArray2 = new String[]{new String("")};
        int n3 = H5.H5Gopen(n, string);
        long l2 = H5.H5Gget_objname_by_idx(n3, n2, stringArray2, l);
        int n4 = H5.H5Gget_objtype_by_idx(n3, n2);
        stringArray[0] = new String(stringArray2[0]);
        nArray[0] = n4;
        int n5 = new Long(l2).intValue();
        return n5;
    }

    public static synchronized int H5Gget_obj_info_all(int n, String string, String[] stringArray, int[] nArray) throws HDF5LibraryException, NullPointerException {
        if (stringArray == null) {
            throw new NullPointerException("H5Gget_obj_info_all(): name array is null");
        }
        if (nArray == null) {
            throw new NullPointerException("H5Gget_obj_info_all(): type array is null");
        }
        if (stringArray.length == 0) {
            throw new HDF5LibraryException("H5Gget_obj_info_all(): array size is zero");
        }
        if (stringArray.length != nArray.length) {
            throw new HDF5LibraryException("H5Gget_obj_info_all(): name and type array sizes are different");
        }
        return H5.H5Gget_obj_info_all(n, string, stringArray, nArray, stringArray.length);
    }

    public static synchronized native int H5Gget_obj_info_all(int var0, String var1, String[] var2, int[] var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Gget_objinfo(int var0, String var1, boolean var2, long[] var3, long[] var4, int[] var5, long[] var6) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized int H5Gget_objinfo(int n, String string, boolean bl, HDF5GroupInfo hDF5GroupInfo) throws HDF5LibraryException, NullPointerException {
        int n2 = -1;
        long[] lArray = new long[2];
        long[] lArray2 = new long[2];
        int[] nArray = new int[3];
        long[] lArray3 = new long[1];
        n2 = H5.H5Gget_objinfo(n, string, bl, lArray, lArray2, nArray, lArray3);
        if (n2 >= 0) {
            hDF5GroupInfo.setGroupInfo(lArray, lArray2, nArray[0], nArray[1], lArray3[0], nArray[2]);
        }
        return n2;
    }

    public static synchronized int H5Tget_native_type(int n) throws HDF5LibraryException, NullPointerException {
        return H5.H5Tget_native_type(n, HDF5Constants.H5T_DIR_ASCEND);
    }

    public static synchronized native int H5Pset_alloc_time(int var0, int var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_alloc_time(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fill_time(int var0, int var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_fill_time(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pfill_value_defined(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fletcher32(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_edc_check(int var0, int var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_edc_check(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_shuffle(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_szip(int var0, int var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dget_space_status(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Iget_name(int var0, String[] var1, long var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5set_free_list_limits(int var0, int var1, int var2, int var3, int var4, int var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Fget_obj_ids(int var0, int var1, int var2, int[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Fget_obj_count(int var0, int var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Tis_variable_str(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Zfilter_avail(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Zunregister(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pmodify_filter(int var0, int var1, int var2, long var3, int[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_filter_by_id(int var0, int var1, int[] var2, long[] var3, int[] var4, long var5, String[] var7) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Pall_filters_avail(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_hyper_vector_size(int var0, long var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_hyper_vector_size(int var0, long[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Tdetect_class(int var0, int var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dread_short(int var0, int var1, int var2, int var3, int var4, short[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dread_int(int var0, int var1, int var2, int var3, int var4, int[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dread_long(int var0, int var1, int var2, int var3, int var4, long[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dread_float(int var0, int var1, int var2, int var3, int var4, float[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dread_double(int var0, int var1, int var2, int var3, int var4, double[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dread_string(int var0, int var1, int var2, int var3, int var4, String[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dread_reg_ref(int var0, int var1, int var2, int var3, int var4, String[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dwrite_short(int var0, int var1, int var2, int var3, int var4, short[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dwrite_int(int var0, int var1, int var2, int var3, int var4, int[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dwrite_long(int var0, int var1, int var2, int var3, int var4, long[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dwrite_float(int var0, int var1, int var2, int var3, int var4, float[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dwrite_double(int var0, int var1, int var2, int var3, int var4, double[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fclose_degree(int var0, int var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_fclose_degree(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Iget_ref(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Iinc_ref(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Idec_ref(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fapl_family(int var0, long var1, int var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_fapl_family(int var0, long[] var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fapl_core(int var0, int var1, boolean var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_fapl_core(int var0, int[] var1, boolean[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_family_offset(int var0, long var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Pget_family_offset(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fapl_log(int var0, String var1, int var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native String H5Fget_name(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native long H5Fget_filesize(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Iget_file_id(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Premove_filter(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Zget_filter_info(int var0) throws HDF5LibraryException;

    public static synchronized native int H5INcreate(String var0, int var1, int var2, int var3, String var4, String var5, long var6);

    public static synchronized native int H5INquery(int var0, String[] var1, Object var2, Object var3, int var4);

    public static synchronized native int H5Pcreate_list(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset(int var0, String var1, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Pexist(int var0, String var1) throws HDF5LibraryException;

    public static synchronized native long H5Pget_size(int var0, String var1) throws HDF5LibraryException;

    public static synchronized native long H5Pget_nprops(int var0) throws HDF5LibraryException;

    public static synchronized native String H5Pget_class_name(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pget_class_parent(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pisa_class(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Pget(int var0, String var1) throws HDF5LibraryException;

    public static synchronized native int H5Pequal(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Pcopy_prop(int var0, int var1, String var2) throws HDF5LibraryException;

    public static synchronized native int H5Premove(int var0, String var1) throws HDF5LibraryException;

    public static synchronized native int H5Punregister(int var0, String var1) throws HDF5LibraryException;

    public static synchronized native int H5Pclose_class(int var0) throws HDF5LibraryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Comparable<File> comparable;
        Object object;
        boolean bl = false;
        s_logger = Logger.getLogger("ncsa.hdf.hdf5lib");
        s_logger.setLevel(Level.INFO);
        s_libraryName = System.getProperty(H5_LIBRARY_NAME_PROPERTY_KEY, null);
        String string = null;
        if (s_libraryName != null && s_libraryName.length() > 0) {
            try {
                string = System.mapLibraryName(s_libraryName);
                System.loadLibrary(s_libraryName);
                bl = true;
                s_logger.log(Level.INFO, "HDF5 library: " + s_libraryName + " resolved to: " + string + "; " + (bl ? "" : " NOT") + " successfully loaded from java.library.path");
            }
            catch (Throwable throwable) {
                try {
                    throwable.printStackTrace();
                    bl = false;
                    s_logger.log(Level.INFO, "HDF5 library: " + s_libraryName + " resolved to: " + string + "; " + (bl ? "" : " NOT") + " successfully loaded from java.library.path");
                }
                catch (Throwable throwable2) {
                    s_logger.log(Level.INFO, "HDF5 library: " + s_libraryName + " resolved to: " + string + "; " + (bl ? "" : " NOT") + " successfully loaded from java.library.path");
                    throw throwable2;
                }
            }
        }
        if (!bl && (object = System.getProperty(H5PATH_PROPERTY_KEY, null)) != null && ((String)object).length() > 0) {
            comparable = new File((String)object);
            if (((File)comparable).exists() && ((File)comparable).canRead() && ((File)comparable).isFile()) {
                try {
                    System.load((String)object);
                    bl = true;
                    s_logger.log(Level.INFO, "HDF5 library: " + (String)object + (bl ? "" : " NOT") + " successfully loaded.");
                }
                catch (Throwable throwable) {
                    try {
                        throwable.printStackTrace();
                        bl = false;
                        s_logger.log(Level.INFO, "HDF5 library: " + (String)object + (bl ? "" : " NOT") + " successfully loaded.");
                    }
                    catch (Throwable throwable3) {
                        s_logger.log(Level.INFO, "HDF5 library: " + (String)object + (bl ? "" : " NOT") + " successfully loaded.");
                        throw throwable3;
                    }
                }
            } else {
                bl = false;
                throw new UnsatisfiedLinkError("Invalid HDF5 library, " + (String)object);
            }
        }
        if (!bl) {
            try {
                s_libraryName = "jhdf5";
                string = System.mapLibraryName(s_libraryName);
                System.loadLibrary("jhdf5");
                bl = true;
                s_logger.log(Level.INFO, "HDF5 library: " + s_libraryName + " resolved to: " + string + "; " + (bl ? "" : " NOT") + " successfully loaded from java.library.path");
            }
            catch (Throwable throwable) {
                try {
                    throwable.printStackTrace();
                    bl = false;
                    s_logger.log(Level.INFO, "HDF5 library: " + s_libraryName + " resolved to: " + string + "; " + (bl ? "" : " NOT") + " successfully loaded from java.library.path");
                }
                catch (Throwable throwable4) {
                    s_logger.log(Level.INFO, "HDF5 library: " + s_libraryName + " resolved to: " + string + "; " + (bl ? "" : " NOT") + " successfully loaded from java.library.path");
                    throw throwable4;
                }
            }
        }
        try {
            H5.H5dont_atexit();
        }
        catch (HDF5LibraryException hDF5LibraryException) {
            System.exit(1);
        }
        H5.H5error_off();
        object = Integer.getInteger("ncsa.hdf.hdf5lib.H5.hdf5maj", null);
        comparable = Integer.getInteger("ncsa.hdf.hdf5lib.H5.hdf5min", null);
        Integer n = Integer.getInteger("ncsa.hdf.hdf5lib.H5.hdf5rel", null);
        if (object != null && comparable != null && n != null) {
            H5.H5check_version((Integer)object, (Integer)comparable, n);
        }
    }
}

