/*
 * Decompiled with CFR 0.152.
 */
package javasoft.util.logging.matlab;

import ch.javasoft.util.logging.Loggers;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javasoft.util.logging.matlab.LogConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogConfigurationReader {
    private final LogConfiguration logConfiguration;

    public LogConfigurationReader() throws IOException {
        this(new LogConfiguration());
    }

    public LogConfigurationReader(LogConfiguration logConfiguration) throws IOException {
        this.logConfiguration = logConfiguration;
        this.initializeLogManagerConfiguration();
    }

    private void initializeLogManagerConfiguration() throws SecurityException, IOException {
        LinkedHashMap<String, String> handlerMap = new LinkedHashMap<String, String>();
        Properties props = this.logConfiguration.toProperties();
        Iterator<Object> keyIt = props.keySet().iterator();
        while (keyIt.hasNext()) {
            Object value;
            String pname;
            Object key = keyIt.next();
            String string = pname = key == null ? "" : key.toString();
            if (!pname.equals("handlers") && !pname.endsWith(".handlers") || (value = props.get(pname)) == null) continue;
            handlerMap.put(pname, value.toString());
            keyIt.remove();
        }
        Loggers.initLogManagerConfiguration(props);
        for (Map.Entry handlerConfig : handlerMap.entrySet()) {
            Logger logger;
            String[] handlers = ((String)handlerConfig.getValue()).split("[\\s,;:]+");
            if (((String)handlerConfig.getKey()).equals("handlers")) {
                logger = Loggers.getRootLogger();
            } else {
                String key = (String)handlerConfig.getKey();
                logger = Logger.getLogger(key.substring(0, key.length() - ".handlers".length()));
            }
            Loggers.removeAllHandlers(logger, false);
            String[] stringArray = handlers;
            int n = handlers.length;
            int n2 = 0;
            while (n2 < n) {
                String handler = stringArray[n2];
                try {
                    Handler lh = this.instantiate(Handler.class, handler);
                    this.initHandlerFormatter(logger, lh);
                    this.initFilters(logger, lh);
                    logger.addHandler(lh);
                }
                catch (Exception ex) {
                    System.err.println("ERROR: could not install log handler, e=" + ex);
                    ex.printStackTrace();
                }
                ++n2;
            }
        }
    }

    private String getInheritedLoggerProperty(Logger logger, String suffix) {
        String propName = logger.getName() == null ? suffix : String.valueOf(logger.getName()) + (logger.getName().length() > 0 ? "." : "") + suffix;
        String value = this.logConfiguration.getProperty(propName);
        if (value == null && logger.getParent() != null) {
            return this.getInheritedLoggerProperty(logger.getParent(), suffix);
        }
        return value;
    }

    private void initHandlerFormatter(Logger logger, Handler handler) {
        String hformatter = this.logConfiguration.getProperty(String.valueOf(handler.getClass().getName()) + ".formatter");
        if (hformatter != null) {
            Formatter formatter = this.instantiate(Formatter.class, hformatter);
            handler.setFormatter(formatter);
        }
    }

    private void initFilters(Logger logger, Handler handler) {
        String hfilter;
        String lfilter = this.getInheritedLoggerProperty(logger, "filter");
        if (lfilter != null) {
            Filter filter = this.instantiate(Filter.class, lfilter);
            logger.setFilter(filter);
        }
        if ((hfilter = this.logConfiguration.getProperty(String.valueOf(handler.getClass().getName()) + ".filter")) != null) {
            Filter filter = this.instantiate(Filter.class, hfilter);
            handler.setFilter(filter);
        }
    }

    private <T> T instantiate(Class<T> clazz, String className) {
        try {
            Class<?> cls = this.getClass().getClassLoader().loadClass(className);
            if (clazz.isAssignableFrom(cls)) {
                return (T)cls.newInstance();
            }
            throw new ClassCastException(String.valueOf(cls.getName()) + " not subclass of " + clazz.getName());
        }
        catch (ClassCastException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException("cannot instantiate " + clazz.getName() + ", e=" + ex, ex);
        }
    }
}

