/*
 * Decompiled with CFR 0.152.
 */
package javasoft.util.logging.matlab;

import ch.javasoft.util.logging.Loggers;
import ch.javasoft.util.logging.SystemProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class LogConfiguration {
    private final Properties properties;

    public LogConfiguration() throws IOException {
        this(LogConfiguration.getConfigProperties());
    }

    public LogConfiguration(Properties properties) {
        this.properties = properties;
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public void setProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public InputStream toInputStream() throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        this.properties.store(buf, "logging config from " + this.getClass().getName());
        return new ByteArrayInputStream(buf.toByteArray());
    }

    public Properties toProperties() throws IOException {
        return this.properties;
    }

    public static String getConfigResourceName() {
        String file = SystemProperties.LogManagerPropertiesFile.getSystemProperty();
        if (file == null) {
            return Loggers.getDefaultConfigurationName();
        }
        return file;
    }

    private static Properties getConfigProperties() throws IOException {
        InputStream in = LogConfiguration.getConfigInputStream();
        Properties props = new Properties();
        props.load(in);
        return props;
    }

    private static InputStream getConfigInputStream() throws IOException {
        InputStream in = Loggers.class.getResourceAsStream(LogConfiguration.getConfigResourceName());
        if (in == null) {
            throw new FileNotFoundException(LogConfiguration.getConfigResourceName());
        }
        return in;
    }
}

