/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.xml.config;

import ch.javasoft.xml.config.XmlConfig;
import ch.javasoft.xml.config.XmlConfigException;
import ch.javasoft.xml.config.XmlNode;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtil {
    public static Element getChildElementByAttributeValue(Element element, XmlNode child, XmlNode attribute, String attributeValue, boolean throwExceptionIfNull) throws XmlConfigException {
        Element res = null;
        Iterator it = element.elementIterator(child.getXmlName());
        while (it.hasNext()) {
            Element el = (Element)it.next();
            String attValue = el.attributeValue(attribute.getXmlName());
            if (!attributeValue.equals(attValue)) continue;
            if (res == null) {
                res = el;
                continue;
            }
            throw new XmlConfigException("multiple matches for " + child.getXmlName() + " children with attribute " + attribute.getXmlName() + "='" + attributeValue + "'", element);
        }
        if (res == null && throwExceptionIfNull) {
            throw new XmlConfigException("missing " + child.getXmlName() + " child with attribute " + attribute.getXmlName() + "='" + attributeValue + "'", element);
        }
        return res;
    }

    public static Iterator<Element> getChildElements(Element element, XmlNode childType) throws XmlConfigException {
        return element.elementIterator(childType.getXmlName());
    }

    public static Element getRequiredSingleChildElement(Element element, XmlNode child) throws XmlConfigException {
        Element result = XmlUtil.getOptionalSingleChildElement(element, child);
        if (result == null) {
            throw new XmlConfigException("missing " + child.getXmlName() + " child element", element);
        }
        return result;
    }

    public static Element getOptionalSingleChildElement(Element element, XmlNode child) throws XmlConfigException {
        List list = element.elements(child.getXmlName());
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new XmlConfigException("expected single " + child.getXmlName() + " child, but found " + list.size(), element);
        }
        return (Element)list.get(0);
    }

    public static String getRequiredAttributeValue(Element element, XmlNode attribute) throws XmlConfigException {
        Attribute att = element.attribute(attribute.getXmlName());
        if (att == null) {
            throw new XmlConfigException("missing " + attribute.getXmlName() + " attribute for " + element.getName() + " element", element);
        }
        return att.getValue();
    }

    public static String getOptionalAttributeValue(Element element, XmlNode attribute, String defaultValue) throws XmlConfigException {
        Attribute att = element.attribute(attribute.getXmlName());
        if (att == null) {
            return defaultValue;
        }
        return att.getValue();
    }

    public static void checkExpectedElementName(Element element, XmlNode expected) throws XmlConfigException {
        if (!XmlUtil.isExpectedElementName(element, expected)) {
            throw new XmlConfigException(String.valueOf(expected.getXmlName()) + " element expected, but " + element.getName() + " found", element);
        }
    }

    public static boolean isExpectedElementName(Element element, XmlNode expected) {
        return expected.getXmlName().equals(element.getName());
    }

    public static void checkExpectedAttributeValue(Element element, XmlNode attribute, String expectedValue) throws XmlConfigException {
        String value = element.attributeValue(attribute.getXmlName());
        if (!expectedValue.equals(value)) {
            throw new XmlConfigException("expected value '" + expectedValue + "' for attribute '" + attribute.getXmlName() + "', but found '" + value + "'", element);
        }
    }

    public static String getNodePath(Node node, boolean recurseParents) {
        if (node instanceof Element) {
            return XmlUtil.getElementPath((Element)node, recurseParents);
        }
        StringBuilder sb = new StringBuilder(node.getName());
        if (recurseParents && node.getParent() != null) {
            sb.insert(0, node instanceof Attribute ? (char)'@' : '/');
            sb.insert(0, XmlUtil.getElementPath(node.getParent(), recurseParents));
        }
        return sb.toString();
    }

    public static String getElementPath(Element elem, boolean recurseParents) {
        StringBuilder sb = new StringBuilder(elem.getName());
        String name = elem.attributeValue(XmlConfig.XmlAttribute.name.getXmlName());
        if (name != null) {
            sb.append("[" + name + "]");
        }
        if (recurseParents && !elem.isRootElement() && elem.getParent() != null) {
            sb.insert(0, '/');
            sb.insert(0, XmlUtil.getElementPath(elem.getParent(), recurseParents));
        }
        return sb.toString();
    }

    private XmlUtil() {
    }
}

