/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.numeric;

import ch.javasoft.math.BigFraction;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class BigIntegerUtil {
    public static BigInteger gcd(BigInteger ... values) {
        if (values.length == 0) {
            return BigInteger.ONE;
        }
        int allSgn = values[0].signum();
        BigInteger gcd = values[0];
        int i = 1;
        while (i < values.length) {
            if (allSgn != values[i].signum()) {
                allSgn = 1;
            }
            if (gcd.signum() == 0 || gcd.equals(BigInteger.ONE)) break;
            if (values[i].signum() != 0) {
                gcd = gcd.gcd(values[i]);
            }
            ++i;
        }
        if (allSgn == 0) {
            return BigInteger.ZERO;
        }
        if (allSgn < 0) {
            return gcd.negate();
        }
        return gcd;
    }

    public static BigInteger lcm(BigInteger ... values) {
        if (values.length == 0) {
            return BigInteger.ONE;
        }
        BigInteger lcm = values[0];
        int i = 1;
        while (i < values.length) {
            if (values[i].signum() != 0) {
                BigInteger gcd = lcm.gcd(values[i]);
                if (gcd.equals(BigInteger.ONE)) {
                    lcm = lcm.multiply(values[i]);
                } else if (!values[i].equals(gcd)) {
                    lcm = lcm.multiply(values[i].divide(gcd));
                }
            }
            ++i;
        }
        return lcm;
    }

    public static BigInteger valueOf(Number number) {
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        if (number instanceof Integer || number instanceof Long || number instanceof Short || number instanceof Byte || number instanceof AtomicInteger || number instanceof AtomicLong) {
            return BigInteger.valueOf(number.longValue());
        }
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).toBigInteger();
        }
        if (number instanceof BigFraction) {
            return ((BigFraction)number).toBigInteger();
        }
        return new BigInteger(number.toString());
    }

    private BigIntegerUtil() {
    }
}

