/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.map;

import ch.javasoft.util.ints.AbstractIntIterator;
import ch.javasoft.util.ints.DefaultIntList;
import ch.javasoft.util.ints.IntCollection;
import ch.javasoft.util.ints.IntCollections;
import ch.javasoft.util.ints.IntHashMap;
import ch.javasoft.util.ints.IntIterable;
import ch.javasoft.util.ints.IntIterator;
import ch.javasoft.util.ints.IntList;
import ch.javasoft.util.ints.IntMap;
import ch.javasoft.util.ints.IntSet;
import ch.javasoft.util.map.AbstractMutableMultiValueMap;
import ch.javasoft.util.map.IntIntMultiValueMap;
import ch.javasoft.util.map.MultiValueMap;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIntIntMultiValueMap
extends AbstractMutableMultiValueMap<Integer, Integer>
implements IntIntMultiValueMap,
Cloneable,
Serializable {
    private static final long serialVersionUID = -93905570980186647L;
    private final IntMap<IntCollection> map;

    public DefaultIntIntMultiValueMap() {
        this.map = this.createMap();
    }

    public DefaultIntIntMultiValueMap(MultiValueMap<? extends Integer, ? extends Integer> copy) {
        this.map = this.createMap();
        for (Integer n : copy.keySet()) {
            IntCollection coll = this.createCollection(n);
            coll.addAll(copy.get(n));
            this.map.put(n, coll);
        }
    }

    public DefaultIntIntMultiValueMap(DefaultIntIntMultiValueMap copy) {
        this.map = this.createMap();
        IntIterator keyIt = this.keySet().iterator();
        while (keyIt.hasNext()) {
            int key = keyIt.nextInt();
            IntCollection coll = this.createCollection(key);
            coll.addAll(copy.get(key));
            this.map.put(key, coll);
        }
    }

    public DefaultIntIntMultiValueMap(IntMap<IntCollection> collectionMap) {
        this.map = collectionMap;
    }

    public static DefaultIntIntMultiValueMap createFromSingleValueMap(Map<? extends Integer, ? extends Integer> singleMap) {
        DefaultIntIntMultiValueMap map = new DefaultIntIntMultiValueMap();
        for (Integer n : singleMap.keySet()) {
            map.add(n, singleMap.get(n));
        }
        return map;
    }

    public static DefaultIntIntMultiValueMap createFromCollectionMap(Map<? extends Integer, ? extends Collection<? extends Integer>> collectionMap) {
        DefaultIntIntMultiValueMap map = new DefaultIntIntMultiValueMap();
        map.addAllNested(collectionMap);
        return map;
    }

    @Override
    public boolean add(Integer key, Integer value) {
        return this.add((int)key, (int)value);
    }

    @Override
    public boolean add(int key, int value) {
        IntCollection coll = this.getOrCreateCollection(key);
        return coll.addInt(value);
    }

    @Override
    public boolean addAll(int key, IntCollection values) {
        if (values.isEmpty()) {
            return false;
        }
        IntCollection coll = this.getOrCreateCollection(key);
        return coll.addAll(values);
    }

    @Override
    public boolean addAll(Integer key, Collection<? extends Integer> values) {
        if (values.isEmpty()) {
            return false;
        }
        IntCollection coll = this.getOrCreateCollection(key);
        return coll.addAll(values);
    }

    @Override
    public boolean addAll(int key, int ... values) {
        boolean any = false;
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            any |= this.add(key, value);
            ++n2;
        }
        return any;
    }

    @Override
    public boolean addAll(IntMap<? extends Integer> map) {
        boolean any = false;
        IntIterator keyIt = map.keySet().iterator();
        while (keyIt.hasNext()) {
            int key = keyIt.nextInt();
            any |= this.add(key, (int)map.get(key));
        }
        return any;
    }

    @Override
    public boolean addAll(IntIntMultiValueMap mapping) {
        boolean any = false;
        IntIterator keyIt = mapping.keySet().iterator();
        while (keyIt.hasNext()) {
            int key = keyIt.nextInt();
            any |= this.addAll(key, mapping.get(key));
        }
        return any;
    }

    @Override
    public boolean addAllNested(IntMap<? extends IntCollection> map) {
        boolean any = false;
        IntIterator keyIt = map.keySet().iterator();
        while (keyIt.hasNext()) {
            int key = keyIt.nextInt();
            any |= this.addAll(key, map.get(key));
        }
        return any;
    }

    public IntCollection get(Object key) {
        IntCollection coll = (IntCollection)this.map.get(key);
        if (coll == null) {
            return IntCollections.EMPTY_LIST;
        }
        return IntCollections.unmodifiableCollection(coll);
    }

    @Override
    public IntCollection get(int key) {
        IntCollection coll = this.map.get(key);
        if (coll == null) {
            return IntCollections.EMPTY_LIST;
        }
        return IntCollections.unmodifiableCollection(coll);
    }

    @Override
    public Integer getFirst(Object key) {
        IntCollection coll = (IntCollection)this.map.get(key);
        return coll == null ? null : (Integer)coll.iterator().next();
    }

    @Override
    public int getFirst(int key) {
        IntCollection coll = this.map.get(key);
        if (coll == null) {
            throw new NoSuchElementException();
        }
        return coll instanceof IntList ? ((IntList)coll).getInt(0) : coll.iterator().nextInt();
    }

    @Override
    public int count(Object key) {
        IntCollection coll = (IntCollection)this.map.get(key);
        return coll == null ? 0 : coll.size();
    }

    @Override
    public int count(int key) {
        IntCollection coll = this.map.get(key);
        return coll == null ? 0 : coll.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean contains(int key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean contains(Object key, Integer value) {
        IntCollection coll = (IntCollection)this.map.get(key);
        return coll == null ? false : coll.contains(value);
    }

    @Override
    public boolean contains(int key, int value) {
        IntCollection coll = this.map.get(key);
        return coll == null ? false : coll.containsInt(value);
    }

    @Override
    public boolean remove(Object key) {
        return this.map.remove(key) != null;
    }

    @Override
    public boolean remove(int key) {
        return this.map.remove(key) != null;
    }

    @Override
    public boolean remove(Object key, Integer value) {
        IntCollection coll = (IntCollection)this.map.get(key);
        if (coll == null) {
            return false;
        }
        if (coll.remove(value)) {
            if (coll.isEmpty()) {
                this.map.remove(key);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(int key, int value) {
        IntCollection coll = this.map.get(key);
        if (coll == null) {
            return false;
        }
        if (coll.removeInt(value)) {
            if (coll.isEmpty()) {
                this.map.remove(key);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean clear() {
        if (!this.map.isEmpty()) {
            this.map.clear();
            return true;
        }
        return false;
    }

    @Override
    public IntSet keySet() {
        return this.map.keySet();
    }

    @Override
    public IntIterable values() {
        return new IntIterable(){

            public IntIterator iterator() {
                return new AbstractIntIterator(){
                    private final Iterator<? extends IntIterable> mItIt;
                    private IntIterator mIt;
                    {
                        this.mItIt = DefaultIntIntMultiValueMap.this.map.values().iterator();
                        this.mIt = this.nextIterator();
                    }

                    private IntIterator nextIterator() {
                        IntIterable itbl;
                        IntIterable intIterable = itbl = this.mItIt.hasNext() ? this.mItIt.next() : null;
                        if (itbl != null) {
                            IntIterator it = itbl.iterator();
                            return it.hasNext() ? it : this.nextIterator();
                        }
                        return null;
                    }

                    public boolean hasNext() {
                        if (this.mIt == null) {
                            return false;
                        }
                        if (this.mIt.hasNext()) {
                            return true;
                        }
                        this.mIt = this.nextIterator();
                        return this.hasNext();
                    }

                    public int nextInt() {
                        if (this.hasNext()) {
                            return this.mIt.nextInt();
                        }
                        throw new NoSuchElementException();
                    }

                    public void remove() {
                        if (this.mIt == null) {
                            throw new NoSuchElementException();
                        }
                        this.mIt.remove();
                    }
                };
            }
        };
    }

    @Override
    public IntMap<? extends IntCollection> asCollectionMap() {
        IntHashMap<DefaultIntList> map = new IntHashMap<DefaultIntList>();
        IntIterator keyIt = this.keySet().iterator();
        while (keyIt.hasNext()) {
            int key = keyIt.nextInt();
            map.put(key, new DefaultIntList(this.get(key)));
        }
        return map;
    }

    @Override
    public IntMap<Integer> asSingleValueMap() {
        IntHashMap<Integer> map = new IntHashMap<Integer>();
        IntIterator keyIt = this.keySet().iterator();
        while (keyIt.hasNext()) {
            int key = keyIt.nextInt();
            map.put(key, (Integer)this.get(key).iterator().next());
        }
        return map;
    }

    @Override
    public IntIntMultiValueMap invert() {
        DefaultIntIntMultiValueMap inv = new DefaultIntIntMultiValueMap();
        IntIterator keyIt = this.keySet().iterator();
        while (keyIt.hasNext()) {
            int key = keyIt.nextInt();
            IntIterator valIt = this.get(key).iterator();
            while (valIt.hasNext()) {
                int val = valIt.nextInt();
                inv.add(val, key);
            }
        }
        return inv;
    }

    public DefaultIntIntMultiValueMap clone() {
        try {
            Method meth = this.map.getClass().getMethod("clone", new Class[0]);
            IntMap clonedMap = (IntMap)meth.invoke(this.map, new Object[0]);
            return new DefaultIntIntMultiValueMap(clonedMap);
        }
        catch (Exception e) {
            return new DefaultIntIntMultiValueMap(this);
        }
    }

    protected IntCollection getOrCreateCollection(int key) {
        IntCollection coll = this.map.get(key);
        if (coll == null) {
            coll = this.createCollection(key);
            this.map.put(key, coll);
        }
        return coll;
    }

    protected IntCollection createCollection(int key) {
        return new DefaultIntList(1);
    }

    protected IntMap<IntCollection> createMap() {
        return new IntHashMap<IntCollection>();
    }
}

