/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.longs;

import ch.javasoft.util.longs.AbstractLongCollection;
import ch.javasoft.util.longs.LongCollection;
import ch.javasoft.util.longs.LongIterator;
import ch.javasoft.util.longs.LongList;
import ch.javasoft.util.longs.LongListIterator;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLongList
extends AbstractLongCollection
implements LongList,
Cloneable {
    public AbstractLongList() {
    }

    public AbstractLongList(long[] values) {
        super(values);
    }

    public AbstractLongList(LongCollection set) {
        super(set);
    }

    @Override
    public boolean addLong(long value) {
        return this.addLong(this.size(), value);
    }

    @Override
    public void add(int index, Long element) {
        this.addLong(index, element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Long> c) {
        boolean any = true;
        for (Long l : c) {
            any |= this.addLong(index, l);
        }
        return any;
    }

    @Override
    public Long get(int index) {
        return this.getLong(index);
    }

    @Override
    public int indexOfLong(long value) {
        int i = 0;
        while (i < this.size()) {
            if (value == this.getLong(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int indexOf(Object o) {
        if (o instanceof Long || o instanceof Integer || o instanceof Short || o instanceof Byte) {
            return this.indexOfLong(((Number)o).longValue());
        }
        return -1;
    }

    @Override
    public int lastIndexOfLong(long value) {
        int i = this.size() - 1;
        while (i >= 0) {
            if (value == this.getLong(i)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o instanceof Long || o instanceof Integer || o instanceof Short || o instanceof Byte) {
            return this.lastIndexOfLong(((Number)o).intValue());
        }
        return -1;
    }

    @Override
    public boolean containsLong(long value) {
        return this.indexOfLong(value) != -1;
    }

    @Override
    public Long remove(int index) {
        return this.removeLongAt(index);
    }

    @Override
    public boolean removeLong(long value) {
        int index = this.indexOfLong(value);
        if (index != -1) {
            this.removeLongAt(index);
            return true;
        }
        return false;
    }

    @Override
    public LongListIterator listIterator() {
        return this.listIterator(0, this.size());
    }

    @Override
    public LongListIterator listIterator(int index) {
        return this.listIterator(index, this.size());
    }

    @Override
    public LongIterator iterator() {
        return this.listIterator();
    }

    @Override
    public Long set(int index, Long element) {
        return this.setLong(index, element);
    }
}

