/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.intcoll;

import ch.javasoft.util.intcoll.IntCollection;
import ch.javasoft.util.intcoll.IntIterator;
import ch.javasoft.util.intcoll.IntMap;
import ch.javasoft.util.intcoll.IntSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntHashMap<V>
implements IntMap<V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 4287157952098979438L;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final int MAXIMUM_CAPACITY = 0x40000000;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private transient IntEntry[] table;
    private transient int size;
    private int threshold;
    private final float loadFactor;
    private volatile transient int modCount;
    protected transient IntEntrySet entrySet = null;
    protected volatile transient IntSet keySet;
    protected volatile transient Collection<V> values;

    public IntHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        int capacity = 1;
        while (capacity < initialCapacity) {
            capacity <<= 1;
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new IntEntry[capacity];
        this.init();
    }

    public IntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new IntEntry[16];
        this.init();
    }

    public IntHashMap(Map<? extends Integer, ? extends V> m) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 16), 0.75f);
        super.putAllForCreate(m);
    }

    private void init() {
    }

    protected int indexFor(int key, int length) {
        key += ~(key << 9);
        key ^= key >>> 14;
        key += key << 4;
        key ^= key >>> 10;
        return key & length - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V get(Object key) {
        if (!(key instanceof Integer)) {
            return null;
        }
        return this.get((Integer)key);
    }

    @Override
    public V get(int key) {
        int i = this.indexFor(key, this.table.length);
        IntEntry e = this.table[i];
        while (e != null) {
            if (e.key == key) {
                return (V)e.value;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(int key) {
        int i = this.indexFor(key, this.table.length);
        IntEntry e = this.table[i];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof Integer)) {
            return false;
        }
        return this.containsKey((Integer)key);
    }

    protected IntEntry<V> getEntry(int key) {
        int i = this.indexFor(key, this.table.length);
        IntEntry e = this.table[i];
        while (e != null && e.key != key) {
            e = e.next;
        }
        return e;
    }

    @Override
    public V put(Integer key, V value) {
        if (key == null) {
            throw new NullPointerException("null key not allowed");
        }
        return this.put((int)key, value);
    }

    @Override
    public V put(int key, V value) {
        int i = this.indexFor(key, this.table.length);
        IntEntry e = this.table[i];
        while (e != null) {
            if (e.key == key) {
                Object oldValue = e.value;
                e.value = value;
                e.recordAccess(this);
                return (V)oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(key, value, i);
        return null;
    }

    private void putForCreate(int key, V value) {
        int i = this.indexFor(key, this.table.length);
        IntEntry e = this.table[i];
        while (e != null) {
            if (e.key == key) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        this.createEntry(key, value, i);
    }

    private void putAllForCreate(Map<? extends Integer, ? extends V> m) {
        if (m instanceof IntMap) {
            IntMap<V> im = IntHashMap.castToIntMap(m);
            for (IntMap.IntEntry<V> e : im.intEntrySet()) {
                this.putForCreate(e.getIntKey(), e.getValue());
            }
        } else {
            for (Map.Entry<Integer, V> e : m.entrySet()) {
                this.putForCreate(e.getKey(), e.getValue());
            }
        }
    }

    private static <VV> IntMap<VV> castToIntMap(Map<? extends Integer, VV> map) {
        return (IntMap)map;
    }

    protected void resize(int newCapacity) {
        IntEntry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        IntEntry[] newTable = new IntEntry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    private void transfer(IntEntry[] newTable) {
        IntEntry[] src = this.table;
        int newCapacity = newTable.length;
        int j = 0;
        while (j < src.length) {
            IntEntry e = src[j];
            if (e != null) {
                IntEntry next;
                src[j] = null;
                do {
                    next = e.next;
                    int i = this.indexFor(e.key, newCapacity);
                    e.next = newTable[i];
                    newTable[i] = e;
                } while ((e = next) != null);
            }
            ++j;
        }
    }

    @Override
    public void putAll(IntMap<? extends V> map) {
        this.putAll((Map<? extends Integer, ? extends V>)map);
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends V> m) {
        int numKeysToBeAdded = m.size();
        if (numKeysToBeAdded == 0) {
            return;
        }
        if (numKeysToBeAdded > this.threshold) {
            int targetCapacity = (int)((float)numKeysToBeAdded / this.loadFactor + 1.0f);
            if (targetCapacity > 0x40000000) {
                targetCapacity = 0x40000000;
            }
            int newCapacity = this.table.length;
            while (newCapacity < targetCapacity) {
                newCapacity <<= 1;
            }
            if (newCapacity > this.table.length) {
                this.resize(newCapacity);
            }
        }
        if (m instanceof IntMap) {
            IntMap<V> im = IntHashMap.castToIntMap(m);
            for (IntMap.IntEntry<V> e : im.intEntrySet()) {
                this.put(e.getIntKey(), (V)e.getValue());
            }
        } else {
            for (Map.Entry<Integer, V> e : m.entrySet()) {
                this.put((int)e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public V remove(int key) {
        IntEntry<V> e = this.removeEntryForKey(key);
        return e == null ? null : (V)e.value;
    }

    @Override
    public V remove(Object key) {
        if (!(key instanceof Integer)) {
            return null;
        }
        return this.remove((Integer)key);
    }

    protected IntEntry<V> removeEntryForKey(int key) {
        IntEntry prev;
        int i = this.indexFor(key, this.table.length);
        IntEntry e = prev = this.table[i];
        while (e != null) {
            IntEntry next = e.next;
            if (e.key == key) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    protected IntEntry<V> removeMapping(Object o) {
        IntEntry prev;
        if (!(o instanceof IntMap.IntEntry)) {
            return null;
        }
        IntMap.IntEntry entry = (IntMap.IntEntry)o;
        int k = entry.getIntKey();
        int i = this.indexFor(k, this.table.length);
        IntEntry e = prev = this.table[i];
        while (e != null) {
            IntEntry next = e.next;
            if (e.key == k) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    @Override
    public void clear() {
        ++this.modCount;
        IntEntry[] tab = this.table;
        int i = 0;
        while (i < tab.length) {
            tab[i] = null;
            ++i;
        }
        this.size = 0;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return this.containsNullValue();
        }
        IntEntry[] tab = this.table;
        int i = 0;
        while (i < tab.length) {
            IntEntry e = tab[i];
            while (e != null) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.next;
            }
            ++i;
        }
        return false;
    }

    private boolean containsNullValue() {
        IntEntry[] tab = this.table;
        int i = 0;
        while (i < tab.length) {
            IntEntry e = tab[i];
            while (e != null) {
                if (e.value == null) {
                    return true;
                }
                e = e.next;
            }
            ++i;
        }
        return false;
    }

    public IntHashMap<V> clone() {
        IntHashMap result = null;
        try {
            result = (IntHashMap)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
        result.keySet = null;
        result.values = null;
        result.table = new IntEntry[this.table.length];
        result.entrySet = null;
        result.modCount = 0;
        result.size = 0;
        result.init();
        result.putAllForCreate(this);
        return result;
    }

    private void addEntry(int key, V value, int bucketIndex) {
        IntEntry e = this.table[bucketIndex];
        this.table[bucketIndex] = new IntEntry<V>(key, value, e);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    private void createEntry(int key, V value, int bucketIndex) {
        IntEntry e = this.table[bucketIndex];
        this.table[bucketIndex] = new IntEntry<V>(key, value, e);
        ++this.size;
    }

    protected IntIterator newKeyIterator() {
        return new KeyIterator();
    }

    protected Iterator<V> newValueIterator() {
        return new ValueIterator();
    }

    protected Iterator<IntMap.IntEntry<V>> newIntEntryIterator() {
        return new IntEntryIterator();
    }

    protected Iterator<Map.Entry<Integer, V>> newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    public IntSet keySet() {
        IntSet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<Integer, V>> entrySet() {
        return this.internalIntEntrySet().toMapEntrySet();
    }

    @Override
    public Set<IntMap.IntEntry<V>> intEntrySet() {
        return this.internalIntEntrySet();
    }

    private IntEntrySet internalIntEntrySet() {
        IntEntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new IntEntrySet());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntMap)) {
            return false;
        }
        IntMap t = (IntMap)o;
        if (t.size() != this.size()) {
            return false;
        }
        for (IntMap.IntEntry<V> e : this.intEntrySet()) {
            int key = e.getIntKey();
            Object value = e.getValue();
            if (!(value == null ? t.get(key) != null || !t.containsKey(key) : !value.equals(t.get(key)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = 0;
        Iterator<IntMap.IntEntry<V>> i = this.intEntrySet().iterator();
        while (i.hasNext()) {
            h += i.next().hashCode();
        }
        return h;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        Iterator<IntMap.IntEntry<V>> i = this.intEntrySet().iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            IntMap.IntEntry<V> e = i.next();
            int key = e.getIntKey();
            Object value = e.getValue();
            buf.append(key);
            buf.append("=");
            if (value == this) {
                buf.append("(this Map)");
            } else {
                buf.append(value);
            }
            hasNext = i.hasNext();
            if (!hasNext) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.size);
        for (IntMap.IntEntry<V> e : this.intEntrySet()) {
            s.writeInt(e.getIntKey());
            s.writeObject(e.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.table = new IntEntry[numBuckets];
        this.init();
        int size = s.readInt();
        int i = 0;
        while (i < size) {
            int key = s.readInt();
            Object value = s.readObject();
            this.putForCreate(key, value);
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends HashIterator<Map.Entry<Integer, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<Integer, V> next() {
            return this.nextEntry();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class HashIterator<E>
    implements Iterator<E> {
        IntEntry<V> next;
        int expectedModCount;
        int index;
        IntEntry<V> current;

        HashIterator() {
            this.expectedModCount = IntHashMap.this.modCount;
            IntEntry[] t = IntHashMap.this.table;
            int i = t.length;
            IntEntry n = null;
            if (IntHashMap.this.size != 0) {
                while (i > 0 && (n = t[--i]) == null) {
                }
            }
            this.next = n;
            this.index = i;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        IntEntry<V> nextEntry() {
            if (IntHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            IntEntry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            IntEntry n = e.next;
            IntEntry[] t = IntHashMap.this.table;
            int i = this.index;
            while (n == null && i > 0) {
                n = t[--i];
            }
            this.index = i;
            this.next = n;
            this.current = e;
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (IntHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            int k = this.current.key;
            this.current = null;
            IntHashMap.this.removeEntryForKey(k);
            this.expectedModCount = IntHashMap.this.modCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntEntry<VV>
    implements IntMap.IntEntry<VV> {
        protected final int key;
        protected VV value;
        protected IntEntry<VV> next;

        protected IntEntry(int k, VV v, IntEntry<VV> n) {
            this.value = v;
            this.next = n;
            this.key = k;
        }

        @Override
        public Integer getKey() {
            return this.key;
        }

        @Override
        public int getIntKey() {
            return this.key;
        }

        @Override
        public VV getValue() {
            return this.value;
        }

        @Override
        public VV setValue(VV newValue) {
            VV oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object eKey = e.getKey();
            Object eVal = e.getValue();
            if (eKey instanceof Integer && ((Integer)eKey).intValue() == this.getIntKey()) {
                return eVal == null ? this.getValue() == null : eVal.equals(this.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.key ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return String.valueOf(this.getIntKey()) + "=" + this.getValue();
        }

        protected void recordAccess(IntHashMap<VV> m) {
        }

        protected void recordRemoval(IntHashMap<VV> m) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IntEntryIterator
    extends HashIterator<IntMap.IntEntry<V>> {
        private IntEntryIterator() {
        }

        @Override
        public IntMap.IntEntry<V> next() {
            return this.nextEntry();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IntEntrySet
    extends AbstractSet<IntMap.IntEntry<V>> {
        private transient AbstractSet<Map.Entry<Integer, V>> mapEntrySet;

        private IntEntrySet() {
        }

        @Override
        public Iterator<IntMap.IntEntry<V>> iterator() {
            return IntHashMap.this.newIntEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof IntMap.IntEntry)) {
                return false;
            }
            IntMap.IntEntry e = (IntMap.IntEntry)o;
            IntEntry candidate = IntHashMap.this.getEntry(e.getIntKey());
            return candidate != null && ((Object)candidate).equals(e);
        }

        @Override
        public boolean remove(Object o) {
            return IntHashMap.this.removeMapping(o) != null;
        }

        @Override
        public int size() {
            return IntHashMap.this.size;
        }

        @Override
        public void clear() {
            IntHashMap.this.clear();
        }

        public Set<Map.Entry<Integer, V>> toMapEntrySet() {
            if (this.mapEntrySet == null) {
                this.mapEntrySet = new AbstractSet<Map.Entry<Integer, V>>(){

                    @Override
                    public Iterator<Map.Entry<Integer, V>> iterator() {
                        return IntHashMap.this.newEntryIterator();
                    }

                    @Override
                    public boolean contains(Object o) {
                        return IntEntrySet.this.contains(o);
                    }

                    @Override
                    public boolean remove(Object o) {
                        return IntEntrySet.this.remove(o);
                    }

                    @Override
                    public int size() {
                        return IntEntrySet.this.size();
                    }

                    @Override
                    public void clear() {
                        IntEntrySet.this.clear();
                    }
                };
            }
            return this.mapEntrySet;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    extends HashIterator<Integer>
    implements IntIterator {
        private KeyIterator() {
        }

        @Override
        public Integer next() {
            return this.nextEntry().key;
        }

        @Override
        public int nextInt() {
            return this.nextEntry().key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends AbstractSet<Integer>
    implements IntSet {
        private KeySet() {
        }

        public IntIterator iterator() {
            return this.intIterator();
        }

        @Override
        public int size() {
            return IntHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return IntHashMap.this.containsKey(o);
        }

        @Override
        public boolean containsInt(int value) {
            return IntHashMap.this.containsKey(value);
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Integer) {
                return this.removeInt((Integer)o);
            }
            return false;
        }

        @Override
        public boolean removeInt(int value) {
            return IntHashMap.this.removeEntryForKey(value) != null;
        }

        @Override
        public void clear() {
            IntHashMap.this.clear();
        }

        @Override
        public IntIterator intIterator() {
            return IntHashMap.this.newKeyIterator();
        }

        public BitSet toBitSet() {
            BitSet result = new BitSet();
            IntIterator it = this.intIterator();
            while (it.hasNext()) {
                result.set(it.nextInt());
            }
            return result;
        }

        @Override
        public int[] toIntArray() {
            return this.toIntArray(new int[IntHashMap.this.size]);
        }

        @Override
        public int[] toIntArray(int[] arr) {
            if (arr.length < IntHashMap.this.size) {
                arr = new int[IntHashMap.this.size];
            }
            IntIterator it = this.intIterator();
            int index = 0;
            while (it.hasNext()) {
                arr[index++] = it.nextInt();
            }
            return arr;
        }

        @Override
        public boolean addInt(int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(IntCollection coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int ... values) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return IntHashMap.this.newValueIterator();
        }

        @Override
        public int size() {
            return IntHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return IntHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            IntHashMap.this.clear();
        }
    }
}

