/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.intcoll;

import ch.javasoft.util.intcoll.IntCollection;
import ch.javasoft.util.intcoll.IntIntMap;
import ch.javasoft.util.intcoll.IntIterator;
import ch.javasoft.util.intcoll.IntMap;
import ch.javasoft.util.intcoll.IntSet;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIntIntMap
extends AbstractMap<Integer, Integer>
implements IntIntMap {
    @Override
    public Integer get(Object key) {
        if (key instanceof Integer) {
            try {
                return this.getInt((Integer)key);
            }
            catch (NoSuchElementException ex) {
                return null;
            }
        }
        return null;
    }

    @Override
    public Integer get(int key) {
        try {
            return this.getInt(key);
        }
        catch (NoSuchElementException ex) {
            return null;
        }
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Integer) {
            return this.containsKey((Integer)key);
        }
        return false;
    }

    @Override
    public boolean containsKey(int key) {
        try {
            this.getInt(key);
            return true;
        }
        catch (NoSuchElementException ex) {
            return false;
        }
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Integer) {
            return this.containsValue((Integer)value);
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<Map.Entry<Integer, Integer>> entrySet() {
        return new AbstractSet<Map.Entry<Integer, Integer>>(){
            private final Set<IntIntMap.IntIntEntry> set;
            {
                this.set = AbstractIntIntMap.this.intIntEntrySet();
            }

            @Override
            public Iterator<Map.Entry<Integer, Integer>> iterator() {
                return new Iterator<Map.Entry<Integer, Integer>>(){
                    private final Iterator<IntIntMap.IntIntEntry> iterator;
                    {
                        this.iterator = set.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public IntIntMap.IntIntEntry next() {
                        return this.iterator.next();
                    }

                    @Override
                    public void remove() {
                        this.iterator.remove();
                    }
                };
            }

            @Override
            public boolean contains(Object o) {
                return this.set.contains(o);
            }

            @Override
            public int size() {
                return this.set.size();
            }

            @Override
            public boolean isEmpty() {
                return this.set.isEmpty();
            }
        };
    }

    @Override
    public Set<IntMap.IntEntry<Integer>> intEntrySet() {
        return new AbstractSet<IntMap.IntEntry<Integer>>(){
            private final Set<IntIntMap.IntIntEntry> set;
            {
                this.set = AbstractIntIntMap.this.intIntEntrySet();
            }

            @Override
            public Iterator<IntMap.IntEntry<Integer>> iterator() {
                return new Iterator<IntMap.IntEntry<Integer>>(){
                    private final Iterator<IntIntMap.IntIntEntry> iterator;
                    {
                        this.iterator = set.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public IntIntMap.IntIntEntry next() {
                        return this.iterator.next();
                    }

                    @Override
                    public void remove() {
                        this.iterator.remove();
                    }
                };
            }

            @Override
            public boolean contains(Object o) {
                return this.set.contains(o);
            }

            @Override
            public int size() {
                return this.set.size();
            }

            @Override
            public boolean isEmpty() {
                return this.set.isEmpty();
            }
        };
    }

    @Override
    public Integer put(int key, Integer value) {
        return ((AbstractMap)this).put(key, value.intValue());
    }

    @Override
    public Integer put(Integer key, Integer value) {
        return ((AbstractMap)this).put(key.intValue(), value.intValue());
    }

    @Override
    public void putAll(IntIntMap map) {
        IntIterator keyIt = map.keySet().intIterator();
        while (keyIt.hasNext()) {
            int key = keyIt.nextInt();
            ((AbstractMap)this).put(key, map.getInt(key));
        }
    }

    @Override
    public void putAll(IntMap<? extends Integer> map) {
        if (map instanceof IntIntMap) {
            this.putAll((IntIntMap)map);
            return;
        }
        IntIterator keyIt = map.keySet().intIterator();
        while (keyIt.hasNext()) {
            int key = keyIt.nextInt();
            ((AbstractMap)this).put(key, map.get(key).intValue());
        }
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Integer> map) {
        if (map instanceof IntIntMap) {
            this.putAll((IntIntMap)map);
        } else if (map instanceof IntMap) {
            this.putAll((IntMap)map);
        } else {
            super.putAll(map);
        }
    }

    @Override
    public Integer remove(Object key) {
        if (key instanceof Integer) {
            return (Integer)this.remove((Integer)key);
        }
        return null;
    }

    @Override
    public abstract IntCollection values();

    @Override
    public abstract IntSet keySet();

    public static class ImmutableIntIntEntry
    implements IntIntMap.IntIntEntry {
        private final int key;
        private final int value;

        public ImmutableIntIntEntry(int key, int value) {
            this.key = key;
            this.value = value;
        }

        public Integer getKey() {
            return this.key;
        }

        public int getIntKey() {
            return this.key;
        }

        public Integer getValue() {
            return this.value;
        }

        public int getIntValue() {
            return this.value;
        }

        public Integer setValue(Integer newValue) {
            throw new UnsupportedOperationException("immutable entry");
        }

        public int setValue(int newValue) {
            throw new UnsupportedOperationException("immutable entry");
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object eKey = e.getKey();
            Object eVal = e.getValue();
            if (eKey instanceof Integer && eVal instanceof Integer) {
                return ((Integer)eKey).intValue() == this.getIntKey() && ((Integer)eVal).intValue() == this.getIntValue();
            }
            return false;
        }

        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return String.valueOf(this.getIntKey()) + "=" + this.getValue();
        }
    }

    public static class SimpleIntIntEntry
    implements IntIntMap.IntIntEntry {
        private final int key;
        private int value;

        public SimpleIntIntEntry(int key, int value) {
            this.key = key;
            this.value = value;
        }

        public Integer getKey() {
            return this.key;
        }

        public int getIntKey() {
            return this.key;
        }

        public Integer getValue() {
            return this.value;
        }

        public int getIntValue() {
            return this.value;
        }

        public Integer setValue(Integer newValue) {
            return this.setValue((int)newValue);
        }

        public int setValue(int newValue) {
            int old = this.value;
            this.value = newValue;
            return old;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object eKey = e.getKey();
            Object eVal = e.getValue();
            if (eKey instanceof Integer && eVal instanceof Integer) {
                return ((Integer)eKey).intValue() == this.getIntKey() && ((Integer)eVal).intValue() == this.getIntValue();
            }
            return false;
        }

        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return String.valueOf(this.getIntKey()) + "=" + this.getValue();
        }
    }
}

