/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.intcoll;

import ch.javasoft.util.intcoll.IntCollection;
import ch.javasoft.util.intcoll.IntIterator;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIntCollection
implements IntCollection {
    protected transient int mod;

    public AbstractIntCollection() {
    }

    public AbstractIntCollection(IntCollection set) {
        this.addAll(set);
    }

    public AbstractIntCollection(int[] values) {
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int val = nArray[n2];
            this.addInt(values[val]);
            ++n2;
        }
    }

    @Override
    public abstract int size();

    @Override
    public abstract void clear();

    @Override
    public abstract boolean addInt(int var1);

    @Override
    public abstract boolean removeInt(int var1);

    @Override
    public abstract IntIterator intIterator();

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsInt(int value) {
        IntIterator it = this.intIterator();
        while (it.hasNext()) {
            if (value != it.nextInt()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Integer) {
            return this.containsInt((Integer)o);
        }
        return false;
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.intIterator();
    }

    public Integer[] toArray() {
        return this.toArrayInternal(new Integer[this.size()], false);
    }

    @Override
    public <T> T[] toArray(T[] arr) {
        return this.toArrayInternal(arr, true);
    }

    protected <T> T[] toArrayInternal(T[] arr, boolean checkSize) {
        int size;
        if (checkSize && arr.length < (size = this.size())) {
            arr = (Object[])Array.newInstance(arr.getClass().getComponentType(), size);
        }
        int index = 0;
        IntIterator it = this.intIterator();
        while (it.hasNext()) {
            arr[index++] = it.nextInt();
        }
        return arr;
    }

    @Override
    public boolean add(Integer o) {
        return this.addInt(o);
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Integer) {
            return this.removeInt((Integer)o);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> c) {
        if (c instanceof IntCollection) {
            return this.addAll((IntCollection)c);
        }
        boolean all = true;
        for (Integer n : c) {
            all &= this.add(n);
        }
        return all;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean any = false;
        Iterator<Integer> it = this.iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            any |= true;
        }
        return any;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean all = true;
        for (Object obj : c) {
            all &= this.remove(obj);
        }
        return all;
    }

    @Override
    public boolean addAll(IntCollection coll) {
        boolean all = true;
        IntIterator it = coll.intIterator();
        while (it.hasNext()) {
            all &= this.addInt(it.nextInt());
        }
        return all;
    }

    @Override
    public boolean addAll(int ... values) {
        if (values.length == 0) {
            return false;
        }
        int i = 0;
        while (i < values.length) {
            this.addInt(values[i]);
            ++i;
        }
        ++this.mod;
        return true;
    }

    @Override
    public int[] toIntArray() {
        return this.toIntArrayInternal(new int[this.size()], false);
    }

    @Override
    public int[] toIntArray(int[] arr) {
        return this.toIntArrayInternal(arr, true);
    }

    protected int[] toIntArrayInternal(int[] arr, boolean checkSize) {
        int size;
        if (checkSize && arr.length < (size = this.size())) {
            arr = new int[size];
        }
        int index = 0;
        IntIterator it = this.intIterator();
        while (it.hasNext()) {
            arr[index++] = it.nextInt();
        }
        return arr;
    }

    public int firstInt() {
        return this.intIterator().nextInt();
    }

    public Integer first() {
        return this.firstInt();
    }

    public int lastInt() {
        IntIterator it = this.intIterator();
        if (!it.hasNext()) {
            throw new NoSuchElementException();
        }
        int val = it.nextInt();
        while (it.hasNext()) {
            val = it.nextInt();
        }
        return val;
    }

    public Integer last() {
        return this.lastInt();
    }

    public AbstractIntCollection clone() {
        AbstractIntCollection clone;
        try {
            clone = (AbstractIntCollection)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
        clone.mod = 0;
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Collection) {
            Collection col = (Collection)obj;
            if (this.size() != col.size()) {
                return false;
            }
            IntIterator thisIt = this.intIterator();
            Iterator otherIt = col.iterator();
            while (thisIt.hasNext()) {
                int val = thisIt.nextInt();
                if (otherIt instanceof IntIterator) {
                    if (val == ((IntIterator)otherIt).nextInt()) continue;
                    return false;
                }
                Object oval = otherIt.next();
                if (oval == null) {
                    return false;
                }
                if (!(oval instanceof Integer)) {
                    return false;
                }
                if ((Integer)oval == val) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        IntIterator it = this.intIterator();
        while (it.hasNext()) {
            hash ^= it.nextInt();
        }
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        IntIterator it = this.intIterator();
        while (it.hasNext()) {
            sb.append(sb.length() > 0 ? ", " : "[");
            sb.append(it.nextInt());
        }
        return sb.append("]").toString();
    }
}

