/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Arrays {
    public static Object[] EMPTY_OBJECT = new Object[0];
    public static long[] EMPTY_LONG = new long[0];
    public static int[] EMPTY_INT = new int[0];
    public static double[] EMPTY_DOUBLE = new double[0];
    public static float[] EMPTY_FLOAT = new float[0];

    public static <T> Set<T> asSet(T ... a) {
        if (a == null || a.length == 0) {
            return new LinkedHashSet(0);
        }
        return new LinkedHashSet<T>(java.util.Arrays.asList(a));
    }

    public static void swap(Object[] arr, int indexA, int indexB) {
        Object tmp = arr[indexA];
        arr[indexA] = arr[indexB];
        arr[indexB] = tmp;
    }

    public static void swap(long[] arr, int indexA, int indexB) {
        long tmp = arr[indexA];
        arr[indexA] = arr[indexB];
        arr[indexB] = tmp;
    }

    public static void swap(int[] arr, int indexA, int indexB) {
        int tmp = arr[indexA];
        arr[indexA] = arr[indexB];
        arr[indexB] = tmp;
    }

    public static void swap(short[] arr, int indexA, int indexB) {
        short tmp = arr[indexA];
        arr[indexA] = arr[indexB];
        arr[indexB] = tmp;
    }

    public static void swap(byte[] arr, int indexA, int indexB) {
        byte tmp = arr[indexA];
        arr[indexA] = arr[indexB];
        arr[indexB] = tmp;
    }

    public static void swap(char[] arr, int indexA, int indexB) {
        char tmp = arr[indexA];
        arr[indexA] = arr[indexB];
        arr[indexB] = tmp;
    }

    public static void swap(boolean[] arr, int indexA, int indexB) {
        boolean tmp = arr[indexA];
        arr[indexA] = arr[indexB];
        arr[indexB] = tmp;
    }

    public static void swap(double[] arr, int indexA, int indexB) {
        double tmp = arr[indexA];
        arr[indexA] = arr[indexB];
        arr[indexB] = tmp;
    }

    public static void swap(float[] arr, int indexA, int indexB) {
        float tmp = arr[indexA];
        arr[indexA] = arr[indexB];
        arr[indexB] = tmp;
    }

    public static void swapRow(Object[][] arr, int rowA, int rowB) {
        Object[] tmp = arr[rowA];
        arr[rowA] = arr[rowB];
        arr[rowB] = tmp;
    }

    public static void swapRow(long[][] arr, int rowA, int rowB) {
        long[] tmp = arr[rowA];
        arr[rowA] = arr[rowB];
        arr[rowB] = tmp;
    }

    public static void swapRow(int[][] arr, int rowA, int rowB) {
        int[] tmp = arr[rowA];
        arr[rowA] = arr[rowB];
        arr[rowB] = tmp;
    }

    public static void swapRow(short[][] arr, int rowA, int rowB) {
        short[] tmp = arr[rowA];
        arr[rowA] = arr[rowB];
        arr[rowB] = tmp;
    }

    public static void swapRow(byte[][] arr, int rowA, int rowB) {
        byte[] tmp = arr[rowA];
        arr[rowA] = arr[rowB];
        arr[rowB] = tmp;
    }

    public static void swapRow(char[][] arr, int rowA, int rowB) {
        char[] tmp = arr[rowA];
        arr[rowA] = arr[rowB];
        arr[rowB] = tmp;
    }

    public static void swapRow(boolean[][] arr, int rowA, int rowB) {
        boolean[] tmp = arr[rowA];
        arr[rowA] = arr[rowB];
        arr[rowB] = tmp;
    }

    public static void swapRow(double[][] arr, int rowA, int rowB) {
        double[] tmp = arr[rowA];
        arr[rowA] = arr[rowB];
        arr[rowB] = tmp;
    }

    public static void swapRow(float[][] arr, int rowA, int rowB) {
        float[] tmp = arr[rowA];
        arr[rowA] = arr[rowB];
        arr[rowB] = tmp;
    }

    public static void swapCol(Object[][] arr, int colA, int colB) {
        int row = 0;
        while (row < arr.length) {
            Object tmp = arr[row][colA];
            arr[row][colA] = arr[row][colB];
            arr[row][colB] = tmp;
            ++row;
        }
    }

    public static void swapCol(long[][] arr, int colA, int colB) {
        int row = 0;
        while (row < arr.length) {
            long tmp = arr[row][colA];
            arr[row][colA] = arr[row][colB];
            arr[row][colB] = tmp;
            ++row;
        }
    }

    public static void swapCol(int[][] arr, int colA, int colB) {
        int row = 0;
        while (row < arr.length) {
            int tmp = arr[row][colA];
            arr[row][colA] = arr[row][colB];
            arr[row][colB] = tmp;
            ++row;
        }
    }

    public static void swapCol(short[][] arr, int colA, int colB) {
        int row = 0;
        while (row < arr.length) {
            short tmp = arr[row][colA];
            arr[row][colA] = arr[row][colB];
            arr[row][colB] = tmp;
            ++row;
        }
    }

    public static void swapCol(byte[][] arr, int colA, int colB) {
        int row = 0;
        while (row < arr.length) {
            byte tmp = arr[row][colA];
            arr[row][colA] = arr[row][colB];
            arr[row][colB] = tmp;
            ++row;
        }
    }

    public static void swapCol(char[][] arr, int colA, int colB) {
        int row = 0;
        while (row < arr.length) {
            char tmp = arr[row][colA];
            arr[row][colA] = arr[row][colB];
            arr[row][colB] = tmp;
            ++row;
        }
    }

    public static void swapCol(boolean[][] arr, int colA, int colB) {
        int row = 0;
        while (row < arr.length) {
            boolean tmp = arr[row][colA];
            arr[row][colA] = arr[row][colB];
            arr[row][colB] = tmp;
            ++row;
        }
    }

    public static void swapCol(double[][] arr, int colA, int colB) {
        int row = 0;
        while (row < arr.length) {
            double tmp = arr[row][colA];
            arr[row][colA] = arr[row][colB];
            arr[row][colB] = tmp;
            ++row;
        }
    }

    public static void swapCol(float[][] arr, int colA, int colB) {
        int row = 0;
        while (row < arr.length) {
            float tmp = arr[row][colA];
            arr[row][colA] = arr[row][colB];
            arr[row][colB] = tmp;
            ++row;
        }
    }

    public static void rotate(long[] arr, int k) {
        int n = arr.length;
        if (n <= 1) {
            return;
        }
        if ((k < 0 || k >= n) && (k %= n) < 0) {
            k += n;
        }
        if (k == 0) {
            return;
        }
        int v = 0;
        int c = 0;
        while (c < n) {
            int t = v;
            int tp = v + k;
            long tmp = arr[v];
            ++c;
            while (tp != v) {
                arr[t] = arr[tp];
                t = tp;
                if ((tp += k) >= n) {
                    tp -= n;
                }
                ++c;
            }
            arr[t] = tmp;
            ++v;
        }
    }

    public static void rotate(long[] arr, int k, int from, int to) {
        int n = to - from;
        if (n <= 1) {
            return;
        }
        if ((k < 0 || k >= n) && (k %= n) < 0) {
            k += n;
        }
        if (k == 0) {
            return;
        }
        int v = from;
        int c = from;
        while (c < to) {
            int t = v;
            int tp = v + k;
            long tmp = arr[v];
            ++c;
            while (tp != v) {
                arr[t] = arr[tp];
                t = tp;
                if ((tp += k) >= to) {
                    tp -= n;
                }
                ++c;
            }
            arr[t] = tmp;
            ++v;
        }
    }

    public static <T> T[] newArray(T[] template, int length) {
        return Arrays.newArray(template.getClass().getComponentType(), length);
    }

    public static <T> T[] newArray(Class<T> clazz, int length) {
        return (Object[])Array.newInstance(clazz, length);
    }

    public static <T> Class<T>[] newClassArray(Class<T> clazz, int length) {
        return new Class[length];
    }

    public static <T> Class<? extends T>[] newSubclassArray(Class<T> clazz, int length) {
        return new Class[length];
    }

    public static <T> T[] merge(T[] arr, T ... others) {
        T[] res = Arrays.newArray(arr, arr.length + others.length);
        System.arraycopy(arr, 0, res, 0, arr.length);
        System.arraycopy(others, 0, res, arr.length, others.length);
        return res;
    }

    public static long[] merge(long[] arr, long ... others) {
        long[] res = new long[arr.length + others.length];
        System.arraycopy(arr, 0, res, 0, arr.length);
        System.arraycopy(others, 0, res, arr.length, others.length);
        return res;
    }

    public static int[] merge(int[] arr, int ... others) {
        int[] res = new int[arr.length + others.length];
        System.arraycopy(arr, 0, res, 0, arr.length);
        System.arraycopy(others, 0, res, arr.length, others.length);
        return res;
    }

    public static short[] merge(short[] arr, short ... others) {
        short[] res = new short[arr.length + others.length];
        System.arraycopy(arr, 0, res, 0, arr.length);
        System.arraycopy(others, 0, res, arr.length, others.length);
        return res;
    }

    public static byte[] merge(byte[] arr, byte ... others) {
        byte[] res = new byte[arr.length + others.length];
        System.arraycopy(arr, 0, res, 0, arr.length);
        System.arraycopy(others, 0, res, arr.length, others.length);
        return res;
    }

    public static char[] merge(char[] arr, char ... others) {
        char[] res = new char[arr.length + others.length];
        System.arraycopy(arr, 0, res, 0, arr.length);
        System.arraycopy(others, 0, res, arr.length, others.length);
        return res;
    }

    public static boolean[] merge(boolean[] arr, boolean ... others) {
        boolean[] res = new boolean[arr.length + others.length];
        System.arraycopy(arr, 0, res, 0, arr.length);
        System.arraycopy(others, 0, res, arr.length, others.length);
        return res;
    }

    public static double[] merge(double[] arr, double ... others) {
        double[] res = new double[arr.length + others.length];
        System.arraycopy(arr, 0, res, 0, arr.length);
        System.arraycopy(others, 0, res, arr.length, others.length);
        return res;
    }

    public static float[] merge(float[] arr, float ... others) {
        float[] res = new float[arr.length + others.length];
        System.arraycopy(arr, 0, res, 0, arr.length);
        System.arraycopy(others, 0, res, arr.length, others.length);
        return res;
    }

    public static void printArray(int[] arr) {
        Arrays.printArray(System.out, arr);
    }

    public static void printArray(double[] arr) {
        Arrays.printArray(System.out, arr);
    }

    public static void printArray(PrintStream out, int[] arr) {
        out.print('[');
        int i = 0;
        while (i < arr.length) {
            if (i > 0) {
                out.print(", ");
            }
            out.print(arr[i]);
            ++i;
        }
        out.println(']');
    }

    public static void printArray(PrintStream out, double[] arr) {
        out.print('[');
        int i = 0;
        while (i < arr.length) {
            if (i > 0) {
                out.print(", ");
            }
            out.print(arr[i]);
            ++i;
        }
        out.println(']');
    }

    public static void printArray(int[][] arr) {
        Arrays.printArray(System.out, arr);
    }

    public static void printArray(double[][] arr) {
        Arrays.printArray(System.out, arr);
    }

    public static void printArray(PrintStream out, int[][] arr) {
        int rows = arr.length;
        int cols = 0;
        int i = 0;
        while (i < arr.length) {
            if (cols == 0) {
                cols = arr[i].length;
            } else if (cols != arr[i].length) {
                cols = -1;
            }
            ++i;
        }
        out.println(String.valueOf(rows) + "x" + (cols < 0 ? "?" : String.valueOf(cols)) + "{");
        i = 0;
        while (i < arr.length) {
            out.print('\t');
            Arrays.printArray(out, arr[i]);
            ++i;
        }
        out.println("}");
    }

    public static void printArray(PrintStream out, double[][] arr) {
        int rows = arr.length;
        int cols = 0;
        int i = 0;
        while (i < arr.length) {
            if (cols == 0) {
                cols = arr[i].length;
            } else if (cols != arr[i].length) {
                cols = -1;
            }
            ++i;
        }
        out.println(String.valueOf(rows) + "x" + (cols < 0 ? "?" : String.valueOf(cols)) + "{");
        i = 0;
        while (i < arr.length) {
            out.print('\t');
            Arrays.printArray(out, arr[i]);
            ++i;
        }
        out.println("}");
    }

    public static <T> T[] copyOfRange(T[] original, int from, int to) {
        return Arrays.copyOfRange(original, from, to, original.getClass());
    }

    public static <T, U> T[] copyOfRange(U[] original, int from, int to, Class<? extends T[]> newType) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(String.valueOf(from) + " > " + to);
        }
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static double[] copyOfRange(double[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(String.valueOf(from) + " > " + to);
        }
        double[] copy = new double[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static long[] copyOfRange(long[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(String.valueOf(from) + " > " + to);
        }
        long[] copy = new long[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static int[] copyOfRange(int[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(String.valueOf(from) + " > " + to);
        }
        int[] copy = new int[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static byte[] copyOfRange(byte[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(String.valueOf(from) + " > " + to);
        }
        byte[] copy = new byte[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        return Arrays.copyOf(original, newLength, original.getClass());
    }

    public static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static byte[] copyOf(byte[] original, int newLength) {
        byte[] copy = new byte[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static int[] copyOf(int[] original, int newLength) {
        int[] copy = new int[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static double[] copyOf(double[] original, int newLength) {
        double[] copy = new double[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static int binarySearch(byte[] a, byte key) {
        return Arrays.binarySearch0(a, 0, a.length, key);
    }

    public static int binarySearch(byte[] a, int fromIndex, int toIndex, byte key) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        return Arrays.binarySearch0(a, fromIndex, toIndex, key);
    }

    private static int binarySearch0(byte[] a, int fromIndex, int toIndex, byte key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            byte midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(int[] a, int fromIndex, int toIndex, int key) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        return Arrays.binarySearch0(a, fromIndex, toIndex, key);
    }

    static void rangeCheck(int arrayLen, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > arrayLen) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    private static int binarySearch0(int[] a, int fromIndex, int toIndex, int key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(long[] a, int fromIndex, int toIndex, long key) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        return Arrays.binarySearch0(a, fromIndex, toIndex, key);
    }

    private static int binarySearch0(long[] a, int fromIndex, int toIndex, long key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(double[] a, int fromIndex, int toIndex, double key) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        return Arrays.binarySearch0(a, fromIndex, toIndex, key);
    }

    private static int binarySearch0(double[] a, int fromIndex, int toIndex, double key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int cmp;
            int mid = low + high >>> 1;
            double midVal = a[mid];
            if (midVal < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            } else {
                long keyBits;
                long midBits = Double.doubleToLongBits(midVal);
                int n = midBits == (keyBits = Double.doubleToLongBits(key)) ? 0 : (cmp = midBits < keyBits ? -1 : 1);
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private Arrays() {
    }
}

