/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.ops.matrix;

import ch.javasoft.math.BigFraction;
import ch.javasoft.math.NumberOperations;
import ch.javasoft.math.ops.IntegerOperations;
import ch.javasoft.smx.iface.ReadableBigIntegerRationalMatrix;
import ch.javasoft.smx.iface.ReadableIntMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.iface.ReadableVector;
import ch.javasoft.smx.iface.WritableMatrix;
import ch.javasoft.smx.iface.WritableVector;
import ch.javasoft.smx.impl.DefaultIntMatrix;
import ch.javasoft.smx.ops.Add;
import ch.javasoft.smx.ops.ExtendedMatrixOperations;
import ch.javasoft.smx.ops.Gauss;
import ch.javasoft.smx.ops.MatrixOperations;
import ch.javasoft.smx.ops.Mul;
import ch.javasoft.smx.ops.Neg;
import ch.javasoft.smx.ops.ScalarOps;
import ch.javasoft.smx.ops.Sub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntMatrixOperations
implements MatrixOperations<Integer>,
ExtendedMatrixOperations<Integer, BigFraction> {
    private static IntMatrixOperations sInstance;

    public static IntMatrixOperations instance() {
        if (sInstance == null) {
            sInstance = new IntMatrixOperations();
        }
        return sInstance;
    }

    public ReadableMatrix<Integer> createReadableMatrix(Integer[][] values, boolean rowsInFirstDim) {
        return new DefaultIntMatrix(values, rowsInFirstDim);
    }

    @Override
    public ReadableMatrix<Integer> createReadableMatrix(int rows, int cols) {
        return new DefaultIntMatrix(rows, cols);
    }

    public WritableMatrix<Integer> createWritableMatrix(Integer[][] values, boolean rowsInFirstDim) {
        return new DefaultIntMatrix(values, rowsInFirstDim);
    }

    @Override
    public WritableMatrix<Integer> createWritableMatrix(int rows, int cols) {
        return new DefaultIntMatrix(rows, cols);
    }

    public ReadableVector<Integer> createReadableVector(Integer[] values, boolean columnVector) {
        throw new RuntimeException("not implemented");
    }

    public WritableVector<Integer> createWritableVector(Integer[] values, boolean columnVector) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public ReadableVector<Integer> createReadableVector(int size, boolean columnVector) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public WritableVector<Integer> createWritableVector(int size, boolean columnVector) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public NumberOperations<Integer> getNumberOperations() {
        return IntegerOperations.instance();
    }

    @Override
    public ReadableMatrix<Integer> add(ReadableMatrix<Integer> mxA, Integer value) {
        if (mxA instanceof ReadableIntMatrix) {
            return ScalarOps.add((ReadableIntMatrix)mxA, value);
        }
        return ScalarOps.addGeneric(mxA, value);
    }

    @Override
    public ReadableMatrix<Integer> add(ReadableMatrix<Integer> mxA, ReadableMatrix<Integer> mxB) {
        if (mxA instanceof ReadableIntMatrix && mxB instanceof ReadableIntMatrix) {
            return Add.add((ReadableIntMatrix)mxA, (ReadableIntMatrix)mxB);
        }
        return Add.addGeneric(mxA, mxB);
    }

    @Override
    public ReadableMatrix<Integer> multiply(ReadableMatrix<Integer> mxA, Integer value) {
        if (mxA instanceof ReadableIntMatrix) {
            return ScalarOps.scale((ReadableIntMatrix)mxA, value);
        }
        return ScalarOps.scaleGeneric(mxA, value);
    }

    @Override
    public ReadableMatrix<Integer> multiply(ReadableMatrix<Integer> mxA, ReadableMatrix<Integer> mxB) {
        if (mxA instanceof ReadableIntMatrix && mxB instanceof ReadableIntMatrix) {
            return Mul.multiply((ReadableIntMatrix)mxA, (ReadableIntMatrix)mxB);
        }
        return Mul.multiplyGeneric(mxA, mxB);
    }

    @Override
    public ReadableMatrix<Integer> negate(ReadableMatrix<Integer> matrix) {
        if (matrix instanceof ReadableIntMatrix) {
            return Neg.negate((ReadableIntMatrix)matrix);
        }
        return Neg.negateGeneric(matrix);
    }

    @Override
    public ReadableMatrix<Integer> subtract(ReadableMatrix<Integer> mxA, Integer value) {
        return this.add(mxA, -value.intValue());
    }

    @Override
    public ReadableMatrix<Integer> subtract(ReadableMatrix<Integer> mxA, ReadableMatrix<Integer> mxB) {
        if (mxA instanceof ReadableIntMatrix && mxB instanceof ReadableIntMatrix) {
            return Sub.subtract((ReadableIntMatrix)mxA, (ReadableIntMatrix)mxB);
        }
        return Sub.subtractGeneric(mxA, mxB);
    }

    @Override
    public ReadableMatrix<Integer> transpose(ReadableMatrix<Integer> matrix) {
        return matrix.transpose();
    }

    @Override
    public int rank(ReadableMatrix<Integer> mx) {
        if (mx instanceof ReadableBigIntegerRationalMatrix) {
            return Gauss.getRationalInstance().rank((ReadableBigIntegerRationalMatrix)mx);
        }
        throw new RuntimeException("unsupported matrix type: " + mx.getClass().getName());
    }

    @Override
    public int nullity(ReadableMatrix<Integer> mx) {
        if (mx instanceof ReadableBigIntegerRationalMatrix) {
            return Gauss.getRationalInstance().nullity((ReadableBigIntegerRationalMatrix)mx);
        }
        throw new RuntimeException("unsupported matrix type: " + mx.getClass().getName());
    }

    @Override
    public ReadableMatrix<BigFraction> invert(ReadableMatrix<Integer> mx) {
        if (mx instanceof ReadableBigIntegerRationalMatrix) {
            return Gauss.getRationalInstance().invert((ReadableBigIntegerRationalMatrix)mx);
        }
        throw new RuntimeException("unsupported matrix type: " + mx.getClass().getName());
    }

    @Override
    public ReadableMatrix<BigFraction> nullspace(ReadableMatrix<Integer> mx) {
        if (mx instanceof ReadableBigIntegerRationalMatrix) {
            return Gauss.getRationalInstance().nullspace((ReadableBigIntegerRationalMatrix)mx);
        }
        throw new RuntimeException("unsupported matrix type: " + mx.getClass().getName());
    }
}

