/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.ops.matrix;

import ch.javasoft.math.BigFraction;
import ch.javasoft.math.NumberOperations;
import ch.javasoft.math.ops.BigFractionOperations;
import ch.javasoft.smx.iface.ReadableBigIntegerRationalMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.iface.ReadableVector;
import ch.javasoft.smx.iface.WritableMatrix;
import ch.javasoft.smx.iface.WritableVector;
import ch.javasoft.smx.impl.DefaultBigIntegerRationalMatrix;
import ch.javasoft.smx.impl.DefaultBigIntegerVector;
import ch.javasoft.smx.ops.Add;
import ch.javasoft.smx.ops.ExtendedMatrixOperations;
import ch.javasoft.smx.ops.Gauss;
import ch.javasoft.smx.ops.MatrixOperations;
import ch.javasoft.smx.ops.Mul;
import ch.javasoft.smx.ops.Neg;
import ch.javasoft.smx.ops.ScalarOps;
import ch.javasoft.smx.ops.Sub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigIntegerRationalMatrixOperations
implements MatrixOperations<BigFraction>,
ExtendedMatrixOperations<BigFraction, BigFraction> {
    private static BigIntegerRationalMatrixOperations sInstance;

    public static BigIntegerRationalMatrixOperations instance() {
        if (sInstance == null) {
            sInstance = new BigIntegerRationalMatrixOperations();
        }
        return sInstance;
    }

    public ReadableMatrix<BigFraction> createReadableMatrix(BigFraction[][] values, boolean rowsInFirstDim) {
        return new DefaultBigIntegerRationalMatrix(values, rowsInFirstDim);
    }

    @Override
    public ReadableMatrix<BigFraction> createReadableMatrix(int rows, int cols) {
        return new DefaultBigIntegerRationalMatrix(rows, cols);
    }

    public WritableMatrix<BigFraction> createWritableMatrix(BigFraction[][] values, boolean rowsInFirstDim) {
        return new DefaultBigIntegerRationalMatrix(values, rowsInFirstDim);
    }

    @Override
    public WritableMatrix<BigFraction> createWritableMatrix(int rows, int cols) {
        return new DefaultBigIntegerRationalMatrix(rows, cols);
    }

    public ReadableVector<BigFraction> createReadableVector(BigFraction[] values, boolean columnVector) {
        return new DefaultBigIntegerVector(values, columnVector);
    }

    public WritableVector<BigFraction> createWritableVector(BigFraction[] values, boolean columnVector) {
        return new DefaultBigIntegerVector(values, columnVector);
    }

    @Override
    public ReadableVector<BigFraction> createReadableVector(int size, boolean columnVector) {
        return new DefaultBigIntegerVector(size, columnVector);
    }

    @Override
    public WritableVector<BigFraction> createWritableVector(int size, boolean columnVector) {
        return new DefaultBigIntegerVector(size, columnVector);
    }

    @Override
    public NumberOperations<BigFraction> getNumberOperations() {
        return BigFractionOperations.instance();
    }

    @Override
    public ReadableMatrix<BigFraction> add(ReadableMatrix<BigFraction> mxA, BigFraction value) {
        return ScalarOps.addGeneric(mxA, value);
    }

    @Override
    public ReadableMatrix<BigFraction> add(ReadableMatrix<BigFraction> mxA, ReadableMatrix<BigFraction> mxB) {
        return Add.addGeneric(mxA, mxB);
    }

    @Override
    public ReadableMatrix<BigFraction> multiply(ReadableMatrix<BigFraction> mxA, BigFraction value) {
        return ScalarOps.scaleGeneric(mxA, value);
    }

    @Override
    public ReadableMatrix<BigFraction> multiply(ReadableMatrix<BigFraction> mxA, ReadableMatrix<BigFraction> mxB) {
        return Mul.multiplyGeneric(mxA, mxB);
    }

    @Override
    public ReadableMatrix<BigFraction> negate(ReadableMatrix<BigFraction> matrix) {
        return Neg.negateGeneric(matrix);
    }

    @Override
    public ReadableMatrix<BigFraction> subtract(ReadableMatrix<BigFraction> mxA, BigFraction value) {
        return ScalarOps.subtractGeneric(mxA, value);
    }

    @Override
    public ReadableMatrix<BigFraction> subtract(ReadableMatrix<BigFraction> mxA, ReadableMatrix<BigFraction> mxB) {
        return Sub.subtractGeneric(mxA, mxB);
    }

    @Override
    public ReadableMatrix<BigFraction> transpose(ReadableMatrix<BigFraction> matrix) {
        return matrix.transpose();
    }

    @Override
    public int rank(ReadableMatrix<BigFraction> mx) {
        if (mx instanceof ReadableBigIntegerRationalMatrix) {
            return Gauss.getRationalInstance().rank((ReadableBigIntegerRationalMatrix)mx);
        }
        throw new RuntimeException("unsupported matrix type: " + mx.getClass().getName());
    }

    @Override
    public int nullity(ReadableMatrix<BigFraction> mx) {
        if (mx instanceof ReadableBigIntegerRationalMatrix) {
            return Gauss.getRationalInstance().nullity((ReadableBigIntegerRationalMatrix)mx);
        }
        throw new RuntimeException("unsupported matrix type: " + mx.getClass().getName());
    }

    @Override
    public ReadableMatrix<BigFraction> invert(ReadableMatrix<BigFraction> mx) {
        if (mx instanceof ReadableBigIntegerRationalMatrix) {
            return Gauss.getRationalInstance().invert((ReadableBigIntegerRationalMatrix)mx);
        }
        throw new RuntimeException("unsupported matrix type: " + mx.getClass().getName());
    }

    @Override
    public ReadableMatrix<BigFraction> nullspace(ReadableMatrix<BigFraction> mx) {
        if (mx instanceof ReadableBigIntegerRationalMatrix) {
            return Gauss.getRationalInstance().nullspace((ReadableBigIntegerRationalMatrix)mx);
        }
        throw new RuntimeException("unsupported matrix type: " + mx.getClass().getName());
    }
}

