/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.ops.jlapack;

import ch.javasoft.smx.iface.DoubleMatrix;
import ch.javasoft.smx.iface.ReadableDoubleMatrix;
import ch.javasoft.smx.ops.ext.ExternalOpsImpl;
import ch.javasoft.util.numeric.Zero;
import org.netlib.lapack.DGESDD;
import org.netlib.util.intW;

public class JLapackImpl
extends ExternalOpsImpl {
    private final Zero mZero;
    private static final double[][] EMPTY_DBL_MATRIX = new double[1][1];

    public JLapackImpl() {
        this(new Zero());
    }

    public JLapackImpl(Zero zero) {
        this.mZero = zero;
    }

    public DoubleMatrix invert(ReadableDoubleMatrix src) {
        throw new RuntimeException("not implemented");
    }

    public int nullity(ReadableDoubleMatrix src) {
        throw new RuntimeException("not implemented");
    }

    public DoubleMatrix nullspace(ReadableDoubleMatrix src) {
        throw new RuntimeException("not implemented");
    }

    public int rank(double[][] matrix) {
        double[] svals = JLapackImpl.singularValues(matrix);
        return this.rank(svals);
    }

    public int rank(ReadableDoubleMatrix src) {
        return this.rank(src.getDoubleRows());
    }

    private static double[] singularValues(double[][] mx) {
        int M = mx.length;
        int N = M == 0 ? 0 : mx[0].length;
        double[] svals = new double[Math.min(M, N)];
        int lwork = 3 * Math.min(M, N) * Math.min(M, N) + Math.max(Math.max(M, N), 4 * Math.min(M, N) * Math.min(M, N) + 4 * Math.min(M, N));
        double[] work = new double[lwork];
        int[] iwork = new int[8 * Math.min(M, N)];
        intW info = new intW(0);
        DGESDD.DGESDD((String)"N", (int)M, (int)N, (double[][])mx, (double[])svals, (double[][])EMPTY_DBL_MATRIX, (double[][])EMPTY_DBL_MATRIX, (double[])work, (int)lwork, (int[])iwork, (intW)info);
        if (info.val == 0) {
            return svals;
        }
        throw new RuntimeException("lapack dgesdd failed with info code " + info.val);
    }

    private int rank(double[] sing) {
        int rank = sing.length;
        int ii = 0;
        while (ii < sing.length) {
            if (sing[ii] <= this.mZero.mZeroPos) {
                rank = ii;
                break;
            }
            ++ii;
        }
        return rank;
    }
}

