/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.ops;

import ch.javasoft.smx.exception.SingularMatrixException;
import ch.javasoft.smx.iface.DoubleMatrix;
import ch.javasoft.smx.iface.IntRationalMatrix;
import ch.javasoft.smx.iface.ReadableDoubleMatrix;
import ch.javasoft.smx.iface.ReadableIntRationalMatrix;
import ch.javasoft.smx.iface.WritableDoubleMatrix;
import ch.javasoft.smx.iface.WritableIntRationalMatrix;
import ch.javasoft.smx.impl.DefaultDoubleMatrix;
import ch.javasoft.smx.impl.DefaultIntRationalMatrix;
import ch.javasoft.smx.util.DimensionCheck;

public class Invert {
    public static IntRationalMatrix invert(ReadableIntRationalMatrix src) {
        DimensionCheck.checkSqareDimensions(src);
        int len = src.getRowCount();
        DefaultIntRationalMatrix dst = new DefaultIntRationalMatrix(len, len);
        int ii = 0;
        while (ii < len) {
            dst.setValueAt(ii, ii, 1);
            ++ii;
        }
        Invert.invertInternal(src.toIntRationalMatrix(true), dst);
        return dst;
    }

    public static void invert(ReadableIntRationalMatrix src, WritableIntRationalMatrix dst) {
        DimensionCheck.checkSqareDimensions(src);
        DimensionCheck.checkEqualDimensions(src, dst);
        if (src == dst) {
            src = (ReadableIntRationalMatrix)src.clone();
        }
        int len = src.getRowCount();
        int row = 0;
        while (row < len) {
            int col = 0;
            while (col < len) {
                dst.setValueAt(row, col, row == col ? 1 : 0);
                ++col;
            }
            ++row;
        }
        Invert.invertInternal(src.toIntRationalMatrix(true), dst);
    }

    private static void invertInternal(IntRationalMatrix src, WritableIntRationalMatrix dst) {
        DimensionCheck.checkSqareDimensions(src);
        DimensionCheck.checkEqualDimensions(src, dst);
        int len = src.getRowCount();
        int[] rowMapping = new int[len];
        int ii = 0;
        while (ii < len) {
            rowMapping[ii] = ii;
            ++ii;
        }
        int col = 0;
        while (col < len) {
            int rowPivot = col;
            int pivotDividend = src.getIntNumeratorAt(rowPivot, col);
            if (pivotDividend == 0) {
                boolean found = false;
                int row = rowPivot + 1;
                while (row < len && !found) {
                    pivotDividend = src.getIntNumeratorAt(row, col);
                    if (pivotDividend != 0) {
                        src.swapRows(rowPivot, row);
                        dst.swapRows(rowPivot, row);
                        int tmp = rowMapping[rowPivot];
                        rowMapping[rowPivot] = rowMapping[row];
                        rowMapping[row] = tmp;
                        found = true;
                    }
                    ++row;
                }
                if (!found) {
                    throw new SingularMatrixException("pivot is 0, supposing matrix has not full range", rowMapping[rowPivot]);
                }
            }
            int pivotDivisor = src.getIntDenominatorAt(rowPivot, col);
            src.multiplyRow(rowPivot, pivotDivisor, pivotDividend);
            dst.multiplyRow(rowPivot, pivotDivisor, pivotDividend);
            int row = 0;
            while (row < len) {
                int colPivotDividend;
                if (row != col && (colPivotDividend = src.getIntNumeratorAt(row, col)) != 0) {
                    int colPivotDivisor = src.getIntDenominatorAt(row, col);
                    src.addRowToOtherRow(rowPivot, -1, 1, row, colPivotDivisor, colPivotDividend);
                    dst.addRowToOtherRow(rowPivot, -1, 1, row, colPivotDivisor, colPivotDividend);
                }
                ++row;
            }
            ++col;
        }
        int row = 0;
        while (row < len) {
            int pivotDivisor;
            int pivotDividend = src.getIntNumeratorAt(row, row);
            if (pivotDividend != (pivotDivisor = src.getIntDenominatorAt(row, row))) {
                dst.multiplyRow(row, pivotDivisor, pivotDividend);
            }
            ++row;
        }
    }

    public static DoubleMatrix invert(ReadableDoubleMatrix src, double tolerance) {
        DimensionCheck.checkSqareDimensions(src);
        int len = src.getRowCount();
        DefaultDoubleMatrix dst = new DefaultDoubleMatrix(len, len);
        int ii = 0;
        while (ii < len) {
            dst.setValueAt(ii, ii, 1);
            ++ii;
        }
        Invert.invertInternal(src.toDoubleMatrix(true), dst, tolerance);
        return dst;
    }

    public static void invert(ReadableDoubleMatrix src, WritableDoubleMatrix dst, double tolerance) {
        DimensionCheck.checkSqareDimensions(src);
        DimensionCheck.checkEqualDimensions(src, dst);
        if (src == dst) {
            src = (ReadableDoubleMatrix)src.clone();
        }
        int len = src.getRowCount();
        int row = 0;
        while (row < len) {
            int col = 0;
            while (col < len) {
                dst.setValueAt(row, col, row == col ? 1 : 0);
                ++col;
            }
            ++row;
        }
        Invert.invertInternal(src.toDoubleMatrix(true), dst, tolerance);
    }

    private static void invertInternal(DoubleMatrix src, WritableDoubleMatrix dst, double tolerance) {
        tolerance = Math.abs(tolerance);
        double negTolerance = -tolerance;
        DimensionCheck.checkSqareDimensions(src);
        DimensionCheck.checkEqualDimensions(src, dst);
        int len = src.getRowCount();
        int[] rowMapping = new int[len];
        int ii = 0;
        while (ii < len) {
            rowMapping[ii] = ii;
            ++ii;
        }
        int col = 0;
        while (col < len) {
            int rowPivot = col;
            double pivotValue = src.getDoubleValueAt(rowPivot, col);
            if (pivotValue == 0.0 || pivotValue < tolerance && pivotValue > negTolerance) {
                if (pivotValue != 0.0) {
                    src.setValueAt(rowPivot, col, 0.0);
                    pivotValue = 0.0;
                }
                boolean found = false;
                int row = rowPivot + 1;
                while (row < len && !found) {
                    pivotValue = src.getDoubleValueAt(row, col);
                    if (pivotValue != 0.0 && pivotValue < tolerance && pivotValue > negTolerance) {
                        pivotValue = 0.0;
                        src.setValueAt(row, col, 0.0);
                    }
                    if (pivotValue != 0.0) {
                        src.swapRows(rowPivot, row);
                        dst.swapRows(rowPivot, row);
                        int tmp = rowMapping[rowPivot];
                        rowMapping[rowPivot] = rowMapping[row];
                        rowMapping[row] = tmp;
                        found = true;
                    }
                    ++row;
                }
                if (!found) {
                    throw new SingularMatrixException("pivot is 0, supposing matrix has not full range", rowMapping[rowPivot]);
                }
            }
            double pivotMultiplier = -1.0 / pivotValue;
            int row = 0;
            while (row < len) {
                if (row != col) {
                    double colPivotValue = src.getDoubleValueAt(row, col);
                    if (colPivotValue != 0.0 && colPivotValue < tolerance && colPivotValue > negTolerance) {
                        colPivotValue = 0.0;
                        src.setValueAt(row, col, 0.0);
                    }
                    if (colPivotValue != 0.0) {
                        double colPivotMultiplier = 1.0 / colPivotValue;
                        src.addRowToOtherRow(rowPivot, pivotMultiplier, row, colPivotMultiplier);
                        dst.addRowToOtherRow(rowPivot, pivotMultiplier, row, colPivotMultiplier);
                    }
                }
                ++row;
            }
            ++col;
        }
        int row = 0;
        while (row < len) {
            double pivotValue = src.getDoubleValueAt(row, row);
            if (pivotValue != 1.0) {
                dst.multiplyRow(row, 1.0 / pivotValue);
            }
            ++row;
        }
    }

    private Invert() {
    }
}

