/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.ops;

import ch.javasoft.math.BigFraction;
import ch.javasoft.smx.exception.SingularMatrixException;
import ch.javasoft.smx.iface.BigIntegerRationalMatrix;
import ch.javasoft.smx.iface.DoubleMatrix;
import ch.javasoft.smx.iface.ReadableBigIntegerRationalMatrix;
import ch.javasoft.smx.iface.ReadableDoubleMatrix;
import ch.javasoft.smx.impl.DefaultBigIntegerRationalMatrix;
import ch.javasoft.smx.impl.DefaultDoubleMatrix;
import ch.javasoft.smx.ops.GaussPivoting;
import ch.javasoft.util.Arrays;
import ch.javasoft.util.IntArray;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gauss {
    public final double mTolerance;
    private static Gauss statInstDbl;
    private static Gauss statInstRat;

    public int rank(ReadableDoubleMatrix mx) {
        return this.rowEchelon(mx.toDoubleMatrix(true), false, null, null);
    }

    public int rank(ReadableBigIntegerRationalMatrix mx) {
        return this.rowEchelon(mx.toBigIntegerRationalMatrix(true), false, null, null);
    }

    public int nullity(ReadableDoubleMatrix mx) {
        return mx.getColumnCount() - this.rank(mx);
    }

    public int nullity(ReadableBigIntegerRationalMatrix mx) {
        return mx.getColumnCount() - this.rank(mx);
    }

    public DoubleMatrix invert(ReadableDoubleMatrix mx) {
        if (mx.getRowCount() != mx.getColumnCount()) {
            throw new IllegalArgumentException("not a square matrix: " + mx.getRowCount() + "x" + mx.getColumnCount());
        }
        return this.invertMaximalSubmatrix(mx, null, null, true);
    }

    public DoubleMatrix invertMaximalSubmatrix(ReadableDoubleMatrix mx, int[][] ptrRowmap, int[][] ptrColmap) {
        return this.invertMaximalSubmatrix(mx, ptrRowmap, ptrColmap, false);
    }

    private DoubleMatrix invertMaximalSubmatrix(ReadableDoubleMatrix mx, int[][] ptrRowmap, int[][] ptrColmap, boolean square) {
        int rows = mx.getRowCount();
        int cols = mx.getColumnCount();
        DefaultDoubleMatrix rref = new DefaultDoubleMatrix(rows, rows + cols);
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                rref.setValueAt(row, col, mx.getDoubleValueAt(row, col));
                ++col;
            }
            rref.setValueAt(row, cols + row, 1);
            ++row;
        }
        int[] rowmap = Gauss.createIdentityMap(rows);
        int[] colmap = Gauss.createIdentityMap(cols);
        int rank = this.rowEchelon(rref, true, rowmap, colmap);
        if (square && rank < Math.min(rows, cols)) {
            throw new SingularMatrixException("singular matrix, rank < size: " + rank + " < " + rows, rowmap[rank]);
        }
        DefaultDoubleMatrix inv = new DefaultDoubleMatrix(rank, rank);
        int row2 = 0;
        while (row2 < rank) {
            int dstRow = square ? colmap[row2] : row2;
            int col = 0;
            while (col < rank) {
                int dstCol = square ? rowmap[col] : col;
                inv.setValueAt(dstRow, dstCol, rref.getDoubleValueAt(row2, cols + rowmap[col]));
                ++col;
            }
            ++row2;
        }
        if (ptrRowmap != null) {
            ptrRowmap[0] = Arrays.copyOfRange(rowmap, 0, rank);
        }
        if (ptrColmap != null) {
            ptrColmap[0] = Arrays.copyOfRange(colmap, 0, rank);
        }
        return inv;
    }

    public BigIntegerRationalMatrix invert(ReadableBigIntegerRationalMatrix mx) {
        if (mx.getRowCount() != mx.getColumnCount()) {
            throw new IllegalArgumentException("not a square matrix: " + mx.getRowCount() + "x" + mx.getColumnCount());
        }
        return this.invertMaximalSubmatrix(mx, null, null, true);
    }

    public BigIntegerRationalMatrix invertMaximalSubmatrix(ReadableBigIntegerRationalMatrix mx, int[][] ptrRowmap, int[][] ptrColmap) {
        return this.invertMaximalSubmatrix(mx, ptrRowmap, ptrColmap, false);
    }

    private BigIntegerRationalMatrix invertMaximalSubmatrix(ReadableBigIntegerRationalMatrix mx, int[][] ptrRowmap, int[][] ptrColmap, boolean square) {
        int rows = mx.getRowCount();
        int cols = mx.getColumnCount();
        DefaultBigIntegerRationalMatrix rref = new DefaultBigIntegerRationalMatrix(rows, rows + cols);
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                rref.setValueAt(row, col, mx.getBigIntegerNumeratorAt(row, col), mx.getBigIntegerDenominatorAt(row, col));
                ++col;
            }
            rref.setValueAt(row, cols + row, 1);
            ++row;
        }
        int[] rowmap = Gauss.createIdentityMap(rows);
        int[] colmap = Gauss.createIdentityMap(cols);
        int rank = this.rowEchelon(rref, true, rowmap, colmap);
        if (square && rank < Math.min(rows, cols)) {
            throw new SingularMatrixException("singular matrix, rank < size: " + rank + " < " + rows, rowmap[rank]);
        }
        DefaultBigIntegerRationalMatrix inv = new DefaultBigIntegerRationalMatrix(rank, rank);
        int row2 = 0;
        while (row2 < rank) {
            int dstRow = square ? colmap[row2] : row2;
            int col = 0;
            while (col < rank) {
                int dstCol = square ? rowmap[col] : col;
                inv.setValueAt(dstRow, dstCol, rref.getBigIntegerNumeratorAt(row2, cols + rowmap[col]), rref.getBigIntegerDenominatorAt(row2, cols + rowmap[col]));
                ++col;
            }
            ++row2;
        }
        if (ptrRowmap != null) {
            ptrRowmap[0] = Arrays.copyOfRange(rowmap, 0, rank);
        }
        if (ptrColmap != null) {
            ptrColmap[0] = Arrays.copyOfRange(colmap, 0, rank);
        }
        inv.reduce();
        return inv;
    }

    public DoubleMatrix nullspace(ReadableDoubleMatrix mx) {
        int cols = mx.getColumnCount();
        int[] colmap = Gauss.createIdentityMap(cols);
        DoubleMatrix rref = mx.toDoubleMatrix(true);
        int rank = this.rowEchelon(rref, true, null, colmap);
        int ndim = cols - rank;
        DefaultDoubleMatrix ker = new DefaultDoubleMatrix(cols, ndim);
        int row = 0;
        while (row < rank) {
            int col = 0;
            while (col < ndim) {
                ker.setValueAt(colmap[row], col, -rref.getDoubleValueAt(row, col + rank));
                ++col;
            }
            ++row;
        }
        row = 0;
        while (row < ndim) {
            ker.setValueAt(colmap[row + rank], row, 1.0);
            ++row;
        }
        return ker;
    }

    public BigIntegerRationalMatrix nullspace(ReadableBigIntegerRationalMatrix mx) {
        int cols = mx.getColumnCount();
        int[] colmap = Gauss.createIdentityMap(cols);
        BigIntegerRationalMatrix rref = mx.toBigIntegerRationalMatrix(true);
        int rank = this.rowEchelon(rref, true, null, colmap);
        int ndim = cols - rank;
        DefaultBigIntegerRationalMatrix ker = new DefaultBigIntegerRationalMatrix(cols, ndim);
        int row = 0;
        while (row < rank) {
            int col = 0;
            while (col < ndim) {
                BigInteger num = rref.getBigIntegerNumeratorAt(row, col + rank);
                BigInteger den = rref.getBigIntegerDenominatorAt(row, col + rank);
                ker.setValueAt(colmap[row], col, num.negate(), den);
                ++col;
            }
            ++row;
        }
        row = 0;
        while (row < ndim) {
            ker.setValueAt(colmap[row + rank], row, BigFraction.ONE);
            ++row;
        }
        return ker;
    }

    public int rowEchelon(DoubleMatrix mx) {
        return this.rowEchelon(mx, false, null, null);
    }

    public int reducedRowEchelon(DoubleMatrix mx) {
        return this.rowEchelon(mx, true, null, null);
    }

    public int rowEchelon(DoubleMatrix mx, boolean reduced, int[] rowmap, int[] colmap) {
        int col;
        int rows = mx.getRowCount();
        int cols = mx.getColumnCount();
        int prows = rowmap == null ? rows : Math.min(rows, rowmap.length);
        int pcols = colmap == null ? cols : Math.min(cols, colmap.length);
        int pivs = Math.min(prows, pcols);
        int prow = -1;
        int pcol = -1;
        double pval = -1.7976931348623157E308;
        int row = 0;
        while (row < prows) {
            col = 0;
            while (col < pcols) {
                double val = Math.abs(mx.getDoubleValueAt(row, col));
                if (val > pval) {
                    pval = val;
                    prow = row;
                    pcol = col;
                }
                ++col;
            }
            ++row;
        }
        int pivot = 0;
        while (pivot < pivs) {
            double sub;
            double val;
            int col2;
            double rpiv;
            if (pval <= this.mTolerance) {
                return pivot;
            }
            if (prow != pivot) {
                mx.swapRows(prow, pivot);
                if (rowmap != null) {
                    IntArray.swap(rowmap, prow, pivot);
                }
            }
            if (pcol != pivot) {
                mx.swapColumns(pcol, pivot);
                if (colmap != null) {
                    IntArray.swap(colmap, pcol, pivot);
                }
            }
            pval = mx.getDoubleValueAt(pivot, pivot);
            col = pivot + 1;
            while (col < cols) {
                mx.multiply(pivot, col, 1.0 / pval);
                ++col;
            }
            mx.setValueAt(pivot, pivot, 1.0);
            pval = -1.7976931348623157E308;
            int row2 = pivot + 1;
            while (row2 < rows) {
                rpiv = mx.getDoubleValueAt(row2, pivot);
                mx.setValueAt(row2, pivot, 0.0);
                col2 = pivot + 1;
                while (col2 < cols) {
                    val = mx.getDoubleValueAt(row2, col2);
                    sub = mx.getDoubleValueAt(pivot, col2);
                    mx.setValueAt(row2, col2, val -= sub * rpiv);
                    if (row2 < prows && col2 < pcols) {
                        if (val < 0.0) {
                            val = -val;
                        }
                        if (val > pval) {
                            pval = val;
                            prow = row2;
                            pcol = col2;
                        }
                    }
                    ++col2;
                }
                ++row2;
            }
            if (reduced) {
                row2 = 0;
                while (row2 < pivot) {
                    rpiv = mx.getDoubleValueAt(row2, pivot);
                    mx.setValueAt(row2, pivot, 0.0);
                    col2 = pivot + 1;
                    while (col2 < cols) {
                        val = mx.getDoubleValueAt(row2, col2);
                        sub = mx.getDoubleValueAt(pivot, col2);
                        mx.setValueAt(row2, col2, val - sub * rpiv);
                        ++col2;
                    }
                    ++row2;
                }
            }
            ++pivot;
        }
        return pivs;
    }

    public int rowEchelon(BigIntegerRationalMatrix mx, boolean reduced, int[] rowmap, int[] colmap) {
        BigFraction zero = this.mTolerance == 0.0 ? null : BigFraction.valueOfAdjusted(this.mTolerance);
        int rows = mx.getRowCount();
        int cols = mx.getColumnCount();
        int prows = rowmap == null ? rows : Math.min(rows, rowmap.length);
        int pcols = colmap == null ? cols : Math.min(cols, colmap.length);
        int pivs = Math.min(prows, pcols);
        IntArray prowNonZeroIndices = new IntArray(cols);
        int pivot = 0;
        while (pivot < pivs) {
            BigFraction sub;
            BigFraction val;
            int col;
            int i;
            BigFraction rpiv;
            int pcol;
            int col2;
            GaussPivoting.BiLenProductL pivoting = new GaussPivoting.BiLenProductL(pivot);
            int row = pivot;
            while (row < prows) {
                int rowResult = pivoting.checkCandidateRow(mx, pivot, row);
                boolean cont = true;
                col2 = pivot;
                while (col2 < pcols && cont) {
                    if (!this.isZero(mx, row, col2, zero)) {
                        cont = pivoting.checkCandidateCol(mx, pivot, row, col2, rowResult);
                    }
                    ++col2;
                }
                ++row;
            }
            int prow = pivoting.getPivotRow();
            if (this.isZero(mx, prow, pcol = pivoting.getPivotCol(), zero)) {
                return pivot;
            }
            if (prow != pivot) {
                mx.swapRows(prow, pivot);
                if (rowmap != null) {
                    IntArray.swap(rowmap, prow, pivot);
                }
            }
            if (pcol != pivot) {
                mx.swapColumns(pcol, pivot);
                if (colmap != null) {
                    IntArray.swap(colmap, pcol, pivot);
                }
            }
            prowNonZeroIndices.clear();
            BigFraction pval = mx.getBigFractionValueAt(pivot, pivot);
            if (!pval.isOne()) {
                col2 = pivot + 1;
                while (col2 < cols) {
                    mx.multiply(pivot, col2, pval.getDenominator(), pval.getNumerator());
                    if (this.isZero(mx, pivot, col2, zero)) {
                        mx.setValueAt(pivot, col2, BigFraction.ZERO);
                    } else {
                        mx.reduceValueAt(pivot, col2);
                        prowNonZeroIndices.add(col2);
                    }
                    ++col2;
                }
            } else {
                col2 = pivot + 1;
                while (col2 < cols) {
                    if (!this.isZero(mx, pivot, col2, zero)) {
                        prowNonZeroIndices.add(col2);
                    }
                    ++col2;
                }
            }
            mx.setValueAt(pivot, pivot, BigFraction.ONE);
            int row2 = pivot + 1;
            while (row2 < rows) {
                rpiv = mx.getBigFractionValueAt(row2, pivot);
                mx.setValueAt(row2, pivot, BigFraction.ZERO);
                if (rpiv.isNonZero()) {
                    i = 0;
                    while (i < prowNonZeroIndices.length()) {
                        col = prowNonZeroIndices.get(i);
                        val = mx.getBigFractionValueAt(row2, col);
                        sub = mx.getBigFractionValueAt(pivot, col);
                        val = val.subtract(sub.multiply(rpiv));
                        mx.setValueAt(row2, col, val);
                        if (this.isZero(mx, row2, col, zero)) {
                            mx.setValueAt(row2, col, BigFraction.ZERO);
                        } else {
                            mx.reduceValueAt(row2, col);
                        }
                        ++i;
                    }
                }
                ++row2;
            }
            if (reduced) {
                row2 = 0;
                while (row2 < pivot) {
                    rpiv = mx.getBigFractionValueAt(row2, pivot);
                    mx.setValueAt(row2, pivot, BigFraction.ZERO);
                    if (rpiv.isNonZero()) {
                        i = 0;
                        while (i < prowNonZeroIndices.length()) {
                            col = prowNonZeroIndices.get(i);
                            val = mx.getBigFractionValueAt(row2, col);
                            sub = mx.getBigFractionValueAt(pivot, col);
                            val = val.subtract(sub.multiply(rpiv));
                            mx.setValueAt(row2, col, val);
                            if (this.isZero(mx, row2, col, zero)) {
                                mx.setValueAt(row2, col, BigFraction.ZERO);
                            } else {
                                mx.reduceValueAt(row2, col);
                            }
                            ++i;
                        }
                    }
                    ++row2;
                }
            }
            ++pivot;
        }
        return pivs;
    }

    private boolean isZero(BigIntegerRationalMatrix mx, int row, int col, BigFraction zero) {
        return mx.getSignumAt(row, col) == 0 || zero != null && mx.getBigFractionValueAt(row, col).abs().compareTo(zero) < 0;
    }

    private static int[] createIdentityMap(int size) {
        int[] map = new int[size];
        int i = 0;
        while (i < map.length) {
            map[i] = i;
            ++i;
        }
        return map;
    }

    public Gauss(double tolerance) {
        this.mTolerance = Math.abs(tolerance);
    }

    public static Gauss getDoubleInstance() {
        if (statInstDbl == null) {
            statInstDbl = new Gauss(1.0E-10);
        }
        return statInstDbl;
    }

    public static Gauss getRationalInstance() {
        if (statInstRat == null) {
            statInstRat = new Gauss(0.0);
        }
        return statInstRat;
    }

    public static Gauss getDefaultInstance(Class<? extends Number> numberClass) {
        if (BigFraction.class.isAssignableFrom(numberClass) || BigInteger.class.isAssignableFrom(numberClass) || Long.class.isAssignableFrom(numberClass) || Integer.class.isAssignableFrom(numberClass)) {
            return Gauss.getRationalInstance();
        }
        if (Double.class.isAssignableFrom(numberClass) || Float.class.isAssignableFrom(numberClass)) {
            return Gauss.getDoubleInstance();
        }
        throw new IllegalArgumentException("unsupported number type: " + numberClass.getName());
    }
}

