/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.ops;

import ch.javasoft.math.NumberOperations;
import ch.javasoft.smx.iface.DoubleMatrix;
import ch.javasoft.smx.iface.IntMatrix;
import ch.javasoft.smx.iface.IntRationalMatrix;
import ch.javasoft.smx.iface.LongMatrix;
import ch.javasoft.smx.iface.ReadableDoubleMatrix;
import ch.javasoft.smx.iface.ReadableIntMatrix;
import ch.javasoft.smx.iface.ReadableIntRationalMatrix;
import ch.javasoft.smx.iface.ReadableLongMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.iface.WritableDoubleMatrix;
import ch.javasoft.smx.iface.WritableIntMatrix;
import ch.javasoft.smx.iface.WritableIntRationalMatrix;
import ch.javasoft.smx.iface.WritableLongMatrix;
import ch.javasoft.smx.iface.WritableMatrix;
import ch.javasoft.smx.impl.DefaultDoubleMatrix;
import ch.javasoft.smx.impl.DefaultIntMatrix;
import ch.javasoft.smx.impl.DefaultIntRationalMatrix;
import ch.javasoft.smx.impl.DefaultLongMatrix;
import ch.javasoft.smx.util.DimensionCheck;
import ch.javasoft.smx.util.SmxIntegerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Add {
    public static DoubleMatrix add(ReadableDoubleMatrix srcA, ReadableDoubleMatrix srcB) {
        DefaultDoubleMatrix dst = new DefaultDoubleMatrix(srcA.getRowCount(), srcA.getColumnCount());
        Add.add(srcA, srcB, dst);
        return dst;
    }

    public static void add(ReadableDoubleMatrix srcA, ReadableDoubleMatrix srcB, WritableDoubleMatrix dst) {
        DimensionCheck.checkEqualDimensions(srcA, srcB);
        DimensionCheck.checkEqualDimensions(srcB, dst);
        int rows = srcA.getRowCount();
        int cols = srcA.getColumnCount();
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                double sum = srcA.getDoubleValueAt(row, col) + srcB.getDoubleValueAt(row, col);
                dst.setValueAt(row, col, sum);
                ++col;
            }
            ++row;
        }
    }

    public static IntMatrix add(ReadableIntMatrix srcA, ReadableIntMatrix srcB) {
        DefaultIntMatrix dst = new DefaultIntMatrix(srcA.getRowCount(), srcA.getColumnCount());
        Add.add(srcA, srcB, dst);
        return dst;
    }

    public static void add(ReadableIntMatrix srcA, ReadableIntMatrix srcB, WritableIntMatrix dst) {
        DimensionCheck.checkEqualDimensions(srcA, srcB);
        DimensionCheck.checkEqualDimensions(srcB, dst);
        int rows = srcA.getRowCount();
        int cols = srcA.getColumnCount();
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                long sum = srcA.getIntValueAt(row, col) + srcB.getIntValueAt(row, col);
                dst.setValueAt(row, col, SmxIntegerUtil.checkIntegerRange(sum));
                ++col;
            }
            ++row;
        }
    }

    public static LongMatrix add(ReadableLongMatrix srcA, ReadableLongMatrix srcB) {
        DefaultLongMatrix dst = new DefaultLongMatrix(srcA.getRowCount(), srcA.getColumnCount());
        Add.add(srcA, srcB, dst);
        return dst;
    }

    public static void add(ReadableLongMatrix srcA, ReadableLongMatrix srcB, WritableLongMatrix dst) {
        DimensionCheck.checkEqualDimensions(srcA, srcB);
        DimensionCheck.checkEqualDimensions(srcB, dst);
        int rows = srcA.getRowCount();
        int cols = srcA.getColumnCount();
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                long sum = srcA.getLongValueAt(row, col) + srcB.getLongValueAt(row, col);
                dst.setValueAt(row, col, sum);
                ++col;
            }
            ++row;
        }
    }

    public static IntRationalMatrix add(ReadableIntRationalMatrix srcA, ReadableIntRationalMatrix srcB) {
        DefaultIntRationalMatrix dst = new DefaultIntRationalMatrix(srcA.getRowCount(), srcA.getColumnCount());
        Add.add(srcA, srcB, dst);
        return dst;
    }

    public static void add(ReadableIntRationalMatrix srcA, ReadableIntRationalMatrix srcB, WritableIntRationalMatrix dst) {
        DimensionCheck.checkEqualDimensions(srcA, srcB);
        DimensionCheck.checkEqualDimensions(srcB, dst);
        int rows = srcA.getRowCount();
        int cols = srcA.getColumnCount();
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                SmxIntegerUtil.add(srcA.getIntNumeratorAt(row, col), srcA.getIntDenominatorAt(row, col), srcB.getIntNumeratorAt(row, col), srcB.getIntDenominatorAt(row, col), dst, row, col);
                ++col;
            }
            ++row;
        }
    }

    public static <N extends Number> ReadableMatrix<N> addGeneric(ReadableMatrix<N> srcA, ReadableMatrix<N> srcB) {
        DimensionCheck.checkEqualDimensions(srcA, srcB);
        NumberOperations nops = srcA.getNumberOperations();
        int rows = srcA.getRowCount();
        int cols = srcA.getColumnCount();
        WritableMatrix res = srcA.newInstance(rows, cols);
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                Object sum = nops.add(srcA.getNumberValueAt(row, col), srcB.getNumberValueAt(row, col));
                res.setValueAt(row, col, nops.reduce(sum));
                ++col;
            }
            ++row;
        }
        return res.toReadableMatrix(false);
    }

    private Add() {
    }
}

