/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.impl;

import ch.javasoft.math.BigFraction;
import ch.javasoft.math.ops.LongOperations;
import ch.javasoft.smx.iface.BigIntegerMatrix;
import ch.javasoft.smx.iface.BigIntegerRationalMatrix;
import ch.javasoft.smx.iface.DoubleMatrix;
import ch.javasoft.smx.iface.LongMatrix;
import ch.javasoft.smx.iface.LongRationalMatrix;
import ch.javasoft.smx.iface.ReadableBigIntegerMatrix;
import ch.javasoft.smx.iface.ReadableLongMatrix;
import ch.javasoft.smx.impl.AbstractDoubleMatrix;
import ch.javasoft.smx.impl.DefaultBigIntegerMatrix;
import ch.javasoft.smx.impl.DefaultBigIntegerRationalMatrix;
import ch.javasoft.smx.impl.DefaultDoubleMatrix;
import ch.javasoft.smx.ops.MatrixOperations;
import ch.javasoft.smx.ops.matrix.LongMatrixOperations;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLongMatrix
implements LongMatrix {
    private static final String NL = System.getProperty("line.separator");
    private int mColumnCount;
    private long[] mValues;

    public DefaultLongMatrix(int rowCount, int colCount) {
        this(new long[rowCount * colCount], rowCount, colCount);
    }

    public DefaultLongMatrix(long[] values, int rowCount, int columnCount) {
        if (rowCount == -1) {
            rowCount = values.length / columnCount;
        }
        if (columnCount == -1) {
            columnCount = values.length / rowCount;
        }
        if (rowCount < 0 || columnCount < 0 || rowCount * columnCount != values.length) {
            throw new IllegalArgumentException("rowCount (" + rowCount + ") * columnCount (" + columnCount + ") != number of values (" + values.length + ")");
        }
        this.mValues = values;
        this.mColumnCount = columnCount;
    }

    public DefaultLongMatrix(long[][] values, boolean rowsInDim1) {
        int colCnt;
        int rowCnt;
        if (rowsInDim1) {
            rowCnt = values.length;
            colCnt = 0;
            int row = 0;
            while (row < values.length) {
                colCnt = Math.max(colCnt, values[row].length);
                ++row;
            }
        } else {
            colCnt = values.length;
            rowCnt = 0;
            int col = 0;
            while (col < values.length) {
                rowCnt = Math.max(rowCnt, values[col].length);
                ++col;
            }
        }
        long[] vals = new long[rowCnt * colCnt];
        int row = 0;
        while (row < rowCnt) {
            int col = 0;
            while (col < colCnt) {
                int index1 = rowsInDim1 ? row : col;
                int index2 = rowsInDim1 ? col : row;
                vals[row * colCnt + col] = index2 < values[index1].length ? values[index1][index2] : 0L;
                ++col;
            }
            ++row;
        }
        this.mValues = vals;
        this.mColumnCount = colCnt;
    }

    public DefaultLongMatrix(Long[][] values, boolean rowsInDim1) {
        int colCnt;
        int rowCnt;
        if (rowsInDim1) {
            rowCnt = values.length;
            colCnt = 0;
            int row = 0;
            while (row < values.length) {
                colCnt = Math.max(colCnt, values[row].length);
                ++row;
            }
        } else {
            colCnt = values.length;
            rowCnt = 0;
            int col = 0;
            while (col < values.length) {
                rowCnt = Math.max(rowCnt, values[col].length);
                ++col;
            }
        }
        long[] vals = new long[rowCnt * colCnt];
        int row = 0;
        while (row < rowCnt) {
            int col = 0;
            while (col < colCnt) {
                int index1 = rowsInDim1 ? row : col;
                int index2 = rowsInDim1 ? col : row;
                vals[row * colCnt + col] = index2 < values[index1].length ? values[index1][index2] : 0L;
                ++col;
            }
            ++row;
        }
        this.mValues = vals;
        this.mColumnCount = colCnt;
    }

    public DefaultLongMatrix(ReadableLongMatrix mx) {
        this.mValues = mx.toLongArray();
        this.mColumnCount = mx.getColumnCount();
    }

    public static DefaultLongMatrix diag(long[] values) {
        int len = values.length;
        DefaultLongMatrix mx = new DefaultLongMatrix(new long[len * len], len, len);
        int ii = 0;
        while (ii < len) {
            mx.setValueAt(ii, ii, values[ii]);
            ++ii;
        }
        return mx;
    }

    public static DefaultLongMatrix diag(long value, int len) {
        DefaultLongMatrix mx = new DefaultLongMatrix(new long[len * len], len, len);
        int ii = 0;
        while (ii < len) {
            mx.setValueAt(ii, ii, value);
            ++ii;
        }
        return mx;
    }

    public static DefaultLongMatrix identity(int len) {
        return DefaultLongMatrix.diag(1L, len);
    }

    public LongOperations getNumberOperations() {
        return LongOperations.instance();
    }

    @Override
    public MatrixOperations<Long> getMatrixOperations() {
        return LongMatrixOperations.instance();
    }

    @Override
    public long getLongValueAt(int row, int col) {
        return this.mValues[row * this.mColumnCount + col];
    }

    @Override
    public int getSignumAt(int row, int col) {
        long val = this.getLongValueAt(row, col);
        return val == 0L ? 0 : ((double)val < 0.0 ? -1 : 1);
    }

    @Override
    public long getLongNumeratorAt(int row, int col) {
        return this.getLongValueAt(row, col);
    }

    @Override
    public long getLongDenominatorAt(int row, int col) {
        return 1L;
    }

    @Override
    public BigInteger getBigIntegerNumeratorAt(int row, int col) {
        return BigInteger.valueOf(this.getLongNumeratorAt(row, col));
    }

    @Override
    public BigInteger getBigIntegerDenominatorAt(int row, int col) {
        return BigInteger.ONE;
    }

    @Override
    public double getDoubleValueAt(int row, int col) {
        return this.getLongValueAt(row, col);
    }

    @Override
    public BigFraction getBigFractionValueAt(int row, int col) {
        return new BigFraction(this.getBigIntegerNumeratorAt(row, col), this.getBigIntegerDenominatorAt(row, col));
    }

    @Override
    public int getRowCount() {
        return this.mColumnCount > 0 ? this.mValues.length / this.mColumnCount : 0;
    }

    @Override
    public int getColumnCount() {
        return this.mColumnCount;
    }

    @Override
    public void setValueAt(int row, int col, int value) {
        this.mValues[row * this.mColumnCount + col] = value;
    }

    @Override
    public void setValueAt(int row, int col, long value) {
        this.mValues[row * this.mColumnCount + col] = value;
    }

    @Override
    public void setValueAt(int row, int col, Integer value) {
        this.setValueAt(row, col, (int)value);
    }

    @Override
    public void setValueAt(int row, int col, Long value) {
        this.setValueAt(row, col, (long)value);
    }

    @Override
    public void swapRows(int rowA, int rowB) {
        if (rowA == rowB) {
            return;
        }
        long[] tmpRow = new long[this.mColumnCount];
        System.arraycopy(this.mValues, rowA * this.mColumnCount, tmpRow, 0, this.mColumnCount);
        System.arraycopy(this.mValues, rowB * this.mColumnCount, this.mValues, rowA * this.mColumnCount, this.mColumnCount);
        System.arraycopy(tmpRow, 0, this.mValues, rowB * this.mColumnCount, this.mColumnCount);
    }

    @Override
    public void swapColumns(int colA, int colB) {
        if (colA != colB) {
            int rows = this.getRowCount();
            int row = 0;
            while (row < rows) {
                long tmp = this.getLongValueAt(row, colA);
                this.setValueAt(row, colA, this.getLongValueAt(row, colB));
                this.setValueAt(row, colB, tmp);
                ++row;
            }
        }
    }

    @Override
    public Long getNumberValueAt(int row, int col) {
        return this.getLongValueAt(row, col);
    }

    @Override
    public void toArray(long[] array) {
        if (array.length != this.mValues.length) {
            throw new IllegalArgumentException("expected array length " + this.mValues.length + " but found " + array.length);
        }
        System.arraycopy(this.mValues, 0, array, 0, array.length);
    }

    public static void toArray(ReadableLongMatrix mx, long[] array) {
        int cols;
        int rows = mx.getRowCount();
        if (array.length != rows * (cols = mx.getColumnCount())) {
            throw new IllegalArgumentException("expected array length " + rows * cols + " but found " + array.length);
        }
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                array[row * cols + col] = mx.getLongValueAt(row, col);
                ++col;
            }
            ++row;
        }
    }

    @Override
    public double[] toDoubleArray() {
        double[] array = new double[this.mValues.length];
        this.toArray(array);
        return array;
    }

    @Override
    public long[] toLongArray() {
        long[] array = new long[this.mValues.length];
        this.toArray(array);
        return array;
    }

    @Override
    public void toArray(double[] array) {
        AbstractDoubleMatrix.toArray(this, array);
    }

    @Override
    public double[] getDoubleColumn(int col) {
        return AbstractDoubleMatrix.getDoubleColumn(this, col);
    }

    @Override
    public double[][] getDoubleColumns() {
        return AbstractDoubleMatrix.getDoubleColumns(this);
    }

    @Override
    public double[] getDoubleRow(int row) {
        return AbstractDoubleMatrix.getDoubleRow(this, row);
    }

    @Override
    public double[][] getDoubleRows() {
        return AbstractDoubleMatrix.getDoubleRows(this);
    }

    @Override
    public long[] getLongColumn(int col) {
        return DefaultLongMatrix.getLongColumn(this, col);
    }

    public static long[] getLongColumn(ReadableLongMatrix mx, int col) {
        int rows = mx.getRowCount();
        long[] res = new long[rows];
        int row = 0;
        while (row < rows) {
            res[row] = mx.getLongValueAt(row, col);
            ++row;
        }
        return res;
    }

    @Override
    public long[] getLongRow(int row) {
        return DefaultLongMatrix.getLongRow(this, row);
    }

    public static long[] getLongRow(ReadableLongMatrix mx, int row) {
        int cols = mx.getColumnCount();
        long[] res = new long[cols];
        int col = 0;
        while (col < cols) {
            res[col] = mx.getLongValueAt(row, col);
            ++col;
        }
        return res;
    }

    @Override
    public long[][] getLongColumns() {
        return DefaultLongMatrix.getLongColumns(this);
    }

    public static long[][] getLongColumns(ReadableLongMatrix mx) {
        int cols = mx.getColumnCount();
        long[][] res = new long[cols][];
        int col = 0;
        while (col < cols) {
            res[col] = mx.getLongColumn(col);
            ++col;
        }
        return res;
    }

    @Override
    public long[][] getLongRows() {
        return DefaultLongMatrix.getLongRows(this);
    }

    public static long[][] getLongRows(ReadableLongMatrix mx) {
        int rows = mx.getRowCount();
        long[][] res = new long[rows][];
        int row = 0;
        while (row < rows) {
            res[row] = mx.getLongRow(row);
            ++row;
        }
        return res;
    }

    public Long[][] getNumberRows() {
        return DefaultLongMatrix.getNumberRows(this);
    }

    public static Long[][] getNumberRows(ReadableLongMatrix<Long> mx) {
        int rows = mx.getRowCount();
        int cols = mx.getColumnCount();
        Long[][] data = new Long[rows][cols];
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                data[row][col] = mx.getLongValueAt(row, col);
                ++col;
            }
            ++row;
        }
        return data;
    }

    @Override
    public String toString() {
        return DefaultLongMatrix.toString(this);
    }

    @Override
    public void writeTo(Writer writer) {
        DefaultLongMatrix.writeTo(writer, (ReadableLongMatrix)this);
    }

    @Override
    public void writeTo(OutputStream out) {
        DefaultLongMatrix.writeTo(out, (ReadableLongMatrix)this);
    }

    public static String toString(ReadableLongMatrix mx) {
        return DefaultLongMatrix.toString(mx, "{", " }", " [", "]", "", "", "", ", ");
    }

    public static void writeTo(Writer writer, ReadableLongMatrix mx) {
        DefaultLongMatrix.writeTo(writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer), mx, "{", " }", " [", "]", "", "", "", ", ");
    }

    public static void writeTo(OutputStream out, ReadableLongMatrix mx) {
        DefaultLongMatrix.writeTo(new PrintWriter(new OutputStreamWriter(out)), mx, "{", " }", " [", "]", "", "", "", ", ");
    }

    @Override
    public String toMultilineString() {
        return DefaultLongMatrix.toMultilineString(this);
    }

    @Override
    public void writeToMultiline(Writer writer) {
        DefaultLongMatrix.writeToMultiline(writer, (ReadableLongMatrix)this);
    }

    @Override
    public void writeToMultiline(OutputStream out) {
        DefaultLongMatrix.writeToMultiline(out, (ReadableLongMatrix)this);
    }

    public static String toMultilineString(ReadableLongMatrix mx) {
        return DefaultLongMatrix.toString(mx, "{" + NL, "}" + NL, " [", "]" + NL, "", " ", " ", ",");
    }

    public static void writeToMultiline(Writer writer, ReadableLongMatrix mx) {
        DefaultLongMatrix.writeTo(writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer), mx, "{" + NL, "}" + NL, " [", "]" + NL, "", " ", " ", ",");
    }

    public static void writeToMultiline(OutputStream out, ReadableLongMatrix mx) {
        DefaultLongMatrix.writeTo(new PrintWriter(new OutputStreamWriter(out)), mx, "{" + NL, "}" + NL, " [", "]" + NL, "", " ", " ", ",");
    }

    protected static String toString(ReadableLongMatrix mx, String prefix, String postfix, String rowPrefix, String rowPostfix, String rowSeparator, String colPrefix, String colPostfix, String colSeparator) {
        StringWriter sw = new StringWriter();
        DefaultLongMatrix.writeTo(new PrintWriter(sw), mx, prefix, postfix, rowPrefix, rowPostfix, rowSeparator, colPrefix, colPostfix, colSeparator);
        return sw.toString();
    }

    protected static void writeTo(PrintWriter writer, ReadableLongMatrix mx, String prefix, String postfix, String rowPrefix, String rowPostfix, String rowSeparator, String colPrefix, String colPostfix, String colSeparator) {
        int rows = mx.getRowCount();
        int cols = mx.getColumnCount();
        writer.print(prefix);
        int row = 0;
        while (row < rows) {
            if (row > 0) {
                writer.print(rowSeparator);
            }
            writer.print(rowPrefix);
            int col = 0;
            while (col < cols) {
                if (col > 0) {
                    writer.print(colSeparator);
                }
                writer.print(colPrefix);
                writer.print(mx.getLongValueAt(row, col));
                writer.print(colPostfix);
                ++col;
            }
            writer.print(rowPostfix);
            ++row;
        }
        writer.print(postfix);
        writer.flush();
    }

    @Override
    public DefaultLongMatrix clone() {
        return new DefaultLongMatrix((long[])this.mValues.clone(), -1, this.mColumnCount);
    }

    @Override
    public DefaultLongMatrix newInstance(int rows, int cols) {
        return new DefaultLongMatrix(rows, cols);
    }

    @Override
    public DefaultLongMatrix newInstance(Long[][] data, boolean rowsInDim1) {
        int cols;
        int rows;
        if (rowsInDim1) {
            rows = data.length;
            cols = rows == 0 ? 0 : data[0].length;
        } else {
            cols = data.length;
            rows = cols == 0 ? 0 : data[0].length;
        }
        long[] values = new long[rows * cols];
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                Long val = rowsInDim1 ? data[row][col] : data[col][row];
                values[row * cols + col] = val;
                ++col;
            }
            ++row;
        }
        return new DefaultLongMatrix(values, rows, cols);
    }

    @Override
    public LongMatrix toLongMatrix(boolean enforceNewInstance) {
        return enforceNewInstance ? this.clone() : this;
    }

    public LongMatrix toWritableMatrix(boolean enforceNewInstance) {
        return this.toLongMatrix(enforceNewInstance);
    }

    public LongMatrix toReadableMatrix(boolean enforceNewInstance) {
        return this.toLongMatrix(enforceNewInstance);
    }

    @Override
    public LongRationalMatrix toLongRationalMatrix(boolean enforceNewInstance) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public BigIntegerRationalMatrix toBigIntegerRationalMatrix(boolean enforceNewInstance) {
        return new DefaultBigIntegerRationalMatrix(this.toLongArray(), this.getRowCount(), this.getColumnCount());
    }

    @Override
    public DoubleMatrix toDoubleMatrix(boolean enforceNewInstance) {
        return new DefaultDoubleMatrix(this.toDoubleArray(), this.getRowCount(), this.getColumnCount());
    }

    @Override
    public void addRowToOtherRow(int srcRow, int srcFactor, int dstRow, int dstFactor) {
        this.addRowToOtherRow(srcRow, (long)srcFactor, dstRow, (long)dstFactor);
    }

    @Override
    public void addRowToOtherRow(int srcRow, long srcFactor, int dstRow, long dstFactor) {
        int cols = this.getColumnCount();
        int col = 0;
        while (col < cols) {
            this.setValueAt(dstRow, col, dstFactor * this.getLongValueAt(dstRow, col) + srcFactor * this.getLongValueAt(srcRow, col));
            ++col;
        }
    }

    @Override
    public void add(int row, int col, int value) {
        this.add(row, col, (long)value);
    }

    @Override
    public void add(int row, int col, long value) {
        this.setValueAt(row, col, this.getLongValueAt(row, col) + value);
    }

    @Override
    public void multiply(int row, int col, int factor) {
        this.multiply(row, col, (long)factor);
    }

    @Override
    public void multiply(int row, int col, long factor) {
        this.setValueAt(row, col, factor * this.getLongValueAt(row, col));
    }

    @Override
    public void multiplyRow(int row, int factor) {
        this.multiplyRow(row, (long)factor);
    }

    @Override
    public void multiplyRow(int row, long factor) {
        int cols = this.getColumnCount();
        int col = 0;
        while (col < cols) {
            this.multiply(row, col, factor);
            ++col;
        }
    }

    public int hashCode() {
        int value = this.mColumnCount;
        int ii = 0;
        while (ii < this.mValues.length) {
            value ^= (int)(this.mValues[ii] ^ this.mValues[ii] >>> 32);
            ++ii;
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof LongMatrix) {
            LongMatrix other = (LongMatrix)obj;
            int rows = this.getRowCount();
            if (rows != other.getRowCount()) {
                return false;
            }
            int cols = this.getColumnCount();
            if (cols != other.getColumnCount()) {
                return false;
            }
            int row = 0;
            while (row < rows) {
                int col = 0;
                while (col < cols) {
                    if (this.getLongValueAt(row, col) != other.getLongValueAt(row, col)) {
                        return false;
                    }
                    ++col;
                }
                ++row;
            }
            return true;
        }
        return false;
    }

    @Override
    public LongMatrix subLongMatrix(int rowStart, int rowEnd, int colStart, int colEnd) {
        DefaultLongMatrix res = new DefaultLongMatrix(rowEnd - rowStart, colEnd - colStart);
        int row = 0;
        while (row < res.getRowCount()) {
            int col = 0;
            while (col < res.getColumnCount()) {
                res.setValueAt(row, col, this.getLongValueAt(rowStart + row, colStart + col));
                ++col;
            }
            ++row;
        }
        return res;
    }

    @Override
    public LongRationalMatrix subLongRationalMatrix(int rowStart, int rowEnd, int colStart, int colEnd) {
        return this.subLongMatrix(rowStart, rowEnd, colStart, colEnd).toLongRationalMatrix(false);
    }

    @Override
    public BigIntegerRationalMatrix subBigIntegerRationalMatrix(int rowStart, int rowEnd, int colStart, int colEnd) {
        return this.subLongMatrix(rowStart, rowEnd, colStart, colEnd).toBigIntegerRationalMatrix(false);
    }

    @Override
    public DoubleMatrix subDoubleMatrix(int rowStart, int rowEnd, int colStart, int colEnd) {
        return this.subLongMatrix(rowStart, rowEnd, colStart, colEnd).toDoubleMatrix(false);
    }

    @Override
    public ReadableBigIntegerMatrix subBigIntegerMatrix(int rowStart, int rowEnd, int colStart, int colEnd) {
        return this.subLongMatrix(rowStart, rowEnd, colStart, colEnd).toBigIntegerMatrix(false);
    }

    @Override
    public DefaultLongMatrix transpose() {
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        DefaultLongMatrix tr = new DefaultLongMatrix(cols, rows);
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                tr.setValueAt(col, row, this.getLongValueAt(row, col));
                ++col;
            }
            ++row;
        }
        return tr;
    }

    @Override
    public BigInteger getBigIntegerValueAt(int row, int col) {
        return BigInteger.valueOf(this.getLongValueAt(row, col));
    }

    @Override
    public void toArray(BigInteger[] array) {
        if (array.length != this.mValues.length) {
            throw new IllegalArgumentException("expected array length " + this.mValues.length + " but found " + array.length);
        }
        int i = 0;
        while (i < array.length) {
            array[i] = BigInteger.valueOf(this.mValues[i]);
            ++i;
        }
    }

    @Override
    public BigInteger[] toBigIntegerArray() {
        BigInteger[] array = new BigInteger[this.mValues.length];
        this.toArray(array);
        return array;
    }

    @Override
    public BigIntegerMatrix toBigIntegerMatrix(boolean enforceNewInstance) {
        return new DefaultBigIntegerMatrix(this);
    }

    @Override
    public BigInteger[] getBigIntegerColumn(int col) {
        BigInteger[] theCol = new BigInteger[this.getRowCount()];
        int row = 0;
        while (row < theCol.length) {
            theCol[row] = this.getBigIntegerValueAt(row, col);
            ++row;
        }
        return theCol;
    }

    @Override
    public BigInteger[][] getBigIntegerColumns() {
        BigInteger[][] cols = new BigInteger[this.getColumnCount()][];
        int col = 0;
        while (col < cols.length) {
            cols[col] = this.getBigIntegerColumn(col);
            ++col;
        }
        return cols;
    }

    @Override
    public BigInteger[] getBigIntegerRow(int row) {
        BigInteger[] theRow = new BigInteger[this.getColumnCount()];
        int col = 0;
        while (col < theRow.length) {
            theRow[col] = this.getBigIntegerValueAt(row, col);
            ++col;
        }
        return theRow;
    }

    @Override
    public BigInteger[][] getBigIntegerRows() {
        BigInteger[][] rows = new BigInteger[this.getRowCount()][];
        int row = 0;
        while (row < rows.length) {
            rows[row] = this.getBigIntegerRow(row);
            ++row;
        }
        return rows;
    }

    @Override
    public void negate(int row, int col) {
        this.setValueAt(row, col, -this.getLongValueAt(row, col));
    }
}

