/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.impl;

import ch.javasoft.math.BigFraction;
import ch.javasoft.math.ops.BigIntegerOperations;
import ch.javasoft.smx.iface.BigIntegerMatrix;
import ch.javasoft.smx.iface.BigIntegerRationalMatrix;
import ch.javasoft.smx.iface.DoubleMatrix;
import ch.javasoft.smx.iface.LongMatrix;
import ch.javasoft.smx.iface.ReadableBigIntegerMatrix;
import ch.javasoft.smx.iface.ReadableLongMatrix;
import ch.javasoft.smx.impl.AbstractDoubleMatrix;
import ch.javasoft.smx.impl.DefaultBigIntegerRationalMatrix;
import ch.javasoft.smx.impl.DefaultDoubleMatrix;
import ch.javasoft.smx.ops.MatrixOperations;
import ch.javasoft.smx.ops.matrix.BigIntegerMatrixOperations;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBigIntegerMatrix
implements BigIntegerMatrix {
    private static final String NL = System.getProperty("line.separator");
    private int mColumnCount;
    private BigInteger[] mValues;

    public DefaultBigIntegerMatrix(int rowCount, int colCount) {
        this(new BigInteger[rowCount * colCount], rowCount, colCount);
    }

    public DefaultBigIntegerMatrix(BigInteger[] values, int rowCount, int columnCount) {
        if (rowCount == -1) {
            rowCount = values.length / columnCount;
        }
        if (columnCount == -1) {
            columnCount = values.length / rowCount;
        }
        if (rowCount < 0 || columnCount < 0 || rowCount * columnCount != values.length) {
            throw new IllegalArgumentException("rowCount (" + rowCount + ") * columnCount (" + columnCount + ") != number of values (" + values.length + ")");
        }
        this.mValues = values;
        this.mColumnCount = columnCount;
    }

    public DefaultBigIntegerMatrix(BigInteger[][] values, boolean rowsInDim1) {
        int colCnt;
        int rowCnt;
        if (rowsInDim1) {
            rowCnt = values.length;
            colCnt = 0;
            int row = 0;
            while (row < values.length) {
                colCnt = Math.max(colCnt, values[row].length);
                ++row;
            }
        } else {
            colCnt = values.length;
            rowCnt = 0;
            int col = 0;
            while (col < values.length) {
                rowCnt = Math.max(rowCnt, values[col].length);
                ++col;
            }
        }
        BigInteger[] vals = new BigInteger[rowCnt * colCnt];
        int row = 0;
        while (row < rowCnt) {
            int col = 0;
            while (col < colCnt) {
                int index1 = rowsInDim1 ? row : col;
                int index2 = rowsInDim1 ? col : row;
                vals[row * colCnt + col] = index2 < values[index1].length ? values[index1][index2] : BigInteger.ZERO;
                ++col;
            }
            ++row;
        }
        this.mValues = vals;
        this.mColumnCount = colCnt;
    }

    public DefaultBigIntegerMatrix(ReadableBigIntegerMatrix mx) {
        this.mValues = mx.toBigIntegerArray();
        this.mColumnCount = mx.getColumnCount();
    }

    public static DefaultBigIntegerMatrix diag(BigInteger[] values) {
        int len = values.length;
        DefaultBigIntegerMatrix mx = new DefaultBigIntegerMatrix(new BigInteger[len * len], len, len);
        int ii = 0;
        while (ii < len) {
            mx.setValueAt(ii, ii, values[ii]);
            ++ii;
        }
        return mx;
    }

    public static DefaultBigIntegerMatrix diag(BigInteger value, int len) {
        DefaultBigIntegerMatrix mx = new DefaultBigIntegerMatrix(new BigInteger[len * len], len, len);
        int ii = 0;
        while (ii < len) {
            mx.setValueAt(ii, ii, value);
            ++ii;
        }
        return mx;
    }

    public static DefaultBigIntegerMatrix identity(int len) {
        return DefaultBigIntegerMatrix.diag(BigInteger.ONE, len);
    }

    public BigIntegerOperations getNumberOperations() {
        return BigIntegerOperations.instance();
    }

    @Override
    public MatrixOperations<BigInteger> getMatrixOperations() {
        return BigIntegerMatrixOperations.instance();
    }

    @Override
    public int getSignumAt(int row, int col) {
        return this.getBigIntegerValueAt(row, col).signum();
    }

    @Override
    public BigInteger getBigIntegerNumeratorAt(int row, int col) {
        return this.getBigIntegerValueAt(row, col);
    }

    @Override
    public BigInteger getBigIntegerDenominatorAt(int row, int col) {
        return BigInteger.ONE;
    }

    @Override
    public double getDoubleValueAt(int row, int col) {
        return this.getBigIntegerValueAt(row, col).doubleValue();
    }

    @Override
    public BigFraction getBigFractionValueAt(int row, int col) {
        return BigFraction.valueOf(this.getBigIntegerValueAt(row, col));
    }

    @Override
    public int getRowCount() {
        return this.mColumnCount > 0 ? this.mValues.length / this.mColumnCount : 0;
    }

    @Override
    public int getColumnCount() {
        return this.mColumnCount;
    }

    @Override
    public void setValueAt(int row, int col, BigInteger value) {
        this.mValues[row * this.mColumnCount + col] = value;
    }

    @Override
    public void setValueAt(int row, int col, int value) {
        this.setValueAt(row, col, BigInteger.valueOf(value));
    }

    @Override
    public void setValueAt(int row, int col, long value) {
        this.setValueAt(row, col, BigInteger.valueOf(value));
    }

    @Override
    public void setValueAt(int row, int col, Integer value) {
        this.setValueAt(row, col, BigInteger.valueOf(value.intValue()));
    }

    @Override
    public void setValueAt(int row, int col, Long value) {
        this.setValueAt(row, col, (long)value);
    }

    @Override
    public void swapRows(int rowA, int rowB) {
        if (rowA == rowB) {
            return;
        }
        BigInteger[] tmpRow = new BigInteger[this.mColumnCount];
        System.arraycopy(this.mValues, rowA * this.mColumnCount, tmpRow, 0, this.mColumnCount);
        System.arraycopy(this.mValues, rowB * this.mColumnCount, this.mValues, rowA * this.mColumnCount, this.mColumnCount);
        System.arraycopy(tmpRow, 0, this.mValues, rowB * this.mColumnCount, this.mColumnCount);
    }

    @Override
    public void swapColumns(int colA, int colB) {
        if (colA != colB) {
            int rows = this.getRowCount();
            int row = 0;
            while (row < rows) {
                BigInteger tmp = this.getBigIntegerValueAt(row, colA);
                this.setValueAt(row, colA, this.getBigIntegerValueAt(row, colB));
                this.setValueAt(row, colB, tmp);
                ++row;
            }
        }
    }

    @Override
    public BigInteger getNumberValueAt(int row, int col) {
        return this.getBigIntegerValueAt(row, col);
    }

    public void toArray(long[] array) {
        if (array.length != this.mValues.length) {
            throw new IllegalArgumentException("expected array length " + this.mValues.length + " but found " + array.length);
        }
        System.arraycopy(this.mValues, 0, array, 0, array.length);
    }

    public static void toArray(ReadableLongMatrix mx, long[] array) {
        int cols;
        int rows = mx.getRowCount();
        if (array.length != rows * (cols = mx.getColumnCount())) {
            throw new IllegalArgumentException("expected array length " + rows * cols + " but found " + array.length);
        }
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                array[row * cols + col] = mx.getLongValueAt(row, col);
                ++col;
            }
            ++row;
        }
    }

    @Override
    public double[] toDoubleArray() {
        double[] array = new double[this.mValues.length];
        this.toArray(array);
        return array;
    }

    public long[] toLongArray() {
        long[] array = new long[this.mValues.length];
        this.toArray(array);
        return array;
    }

    @Override
    public void toArray(double[] array) {
        AbstractDoubleMatrix.toArray(this, array);
    }

    @Override
    public double[] getDoubleColumn(int col) {
        return AbstractDoubleMatrix.getDoubleColumn(this, col);
    }

    @Override
    public double[][] getDoubleColumns() {
        return AbstractDoubleMatrix.getDoubleColumns(this);
    }

    @Override
    public double[] getDoubleRow(int row) {
        return AbstractDoubleMatrix.getDoubleRow(this, row);
    }

    @Override
    public double[][] getDoubleRows() {
        return AbstractDoubleMatrix.getDoubleRows(this);
    }

    @Override
    public BigInteger[] getBigIntegerColumn(int col) {
        return DefaultBigIntegerMatrix.getBigIntegerColumn(this, col);
    }

    public static BigInteger[] getBigIntegerColumn(ReadableBigIntegerMatrix mx, int col) {
        int rows = mx.getRowCount();
        BigInteger[] res = new BigInteger[rows];
        int row = 0;
        while (row < rows) {
            res[row] = mx.getBigIntegerValueAt(row, col);
            ++row;
        }
        return res;
    }

    @Override
    public BigInteger[] getBigIntegerRow(int row) {
        return DefaultBigIntegerMatrix.getBigIntegerRow(this, row);
    }

    public static BigInteger[] getBigIntegerRow(ReadableBigIntegerMatrix mx, int row) {
        int cols = mx.getColumnCount();
        BigInteger[] res = new BigInteger[cols];
        int col = 0;
        while (col < cols) {
            res[col] = mx.getBigIntegerValueAt(row, col);
            ++col;
        }
        return res;
    }

    @Override
    public BigInteger[][] getBigIntegerColumns() {
        return DefaultBigIntegerMatrix.getBigIntegerColumns(this);
    }

    @Override
    public BigInteger[][] getBigIntegerRows() {
        return DefaultBigIntegerMatrix.getBigIntegerRows(this);
    }

    public static BigInteger[][] getBigIntegerRows(ReadableBigIntegerMatrix mx) {
        int rows = mx.getRowCount();
        BigInteger[][] res = new BigInteger[rows][];
        int row = 0;
        while (row < rows) {
            res[row] = mx.getBigIntegerRow(row);
            ++row;
        }
        return res;
    }

    public static BigInteger[][] getBigIntegerColumns(ReadableBigIntegerMatrix mx) {
        int cols = mx.getColumnCount();
        BigInteger[][] res = new BigInteger[cols][];
        int col = 0;
        while (col < cols) {
            res[col] = mx.getBigIntegerColumn(col);
            ++col;
        }
        return res;
    }

    public BigInteger[][] getNumberRows() {
        return this.getBigIntegerRows();
    }

    @Override
    public String toString() {
        return DefaultBigIntegerMatrix.toString(this);
    }

    @Override
    public void writeTo(Writer writer) {
        DefaultBigIntegerMatrix.writeTo(writer, (ReadableBigIntegerMatrix)this);
    }

    @Override
    public void writeTo(OutputStream out) {
        DefaultBigIntegerMatrix.writeTo(out, (ReadableBigIntegerMatrix)this);
    }

    public static String toString(ReadableBigIntegerMatrix mx) {
        return DefaultBigIntegerMatrix.toString(mx, "{", " }", " [", "]", "", "", "", ", ");
    }

    public static void writeTo(Writer writer, ReadableBigIntegerMatrix mx) {
        DefaultBigIntegerMatrix.writeTo(writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer), mx, "{", " }", " [", "]", "", "", "", ", ");
    }

    public static void writeTo(OutputStream out, ReadableBigIntegerMatrix mx) {
        DefaultBigIntegerMatrix.writeTo(new PrintWriter(new OutputStreamWriter(out)), mx, "{", " }", " [", "]", "", "", "", ", ");
    }

    @Override
    public String toMultilineString() {
        return DefaultBigIntegerMatrix.toMultilineString(this);
    }

    @Override
    public void writeToMultiline(Writer writer) {
        DefaultBigIntegerMatrix.writeToMultiline(writer, (ReadableBigIntegerMatrix)this);
    }

    @Override
    public void writeToMultiline(OutputStream out) {
        DefaultBigIntegerMatrix.writeToMultiline(out, (ReadableBigIntegerMatrix)this);
    }

    public static String toMultilineString(ReadableBigIntegerMatrix mx) {
        return DefaultBigIntegerMatrix.toString(mx, "{" + NL, "}" + NL, " [", "]" + NL, "", " ", " ", ",");
    }

    public static void writeToMultiline(Writer writer, ReadableBigIntegerMatrix mx) {
        DefaultBigIntegerMatrix.writeTo(writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer), mx, "{" + NL, "}" + NL, " [", "]" + NL, "", " ", " ", ",");
    }

    public static void writeToMultiline(OutputStream out, ReadableBigIntegerMatrix mx) {
        DefaultBigIntegerMatrix.writeTo(new PrintWriter(new OutputStreamWriter(out)), mx, "{" + NL, "}" + NL, " [", "]" + NL, "", " ", " ", ",");
    }

    protected static String toString(ReadableBigIntegerMatrix mx, String prefix, String postfix, String rowPrefix, String rowPostfix, String rowSeparator, String colPrefix, String colPostfix, String colSeparator) {
        StringWriter sw = new StringWriter();
        DefaultBigIntegerMatrix.writeTo(new PrintWriter(sw), mx, prefix, postfix, rowPrefix, rowPostfix, rowSeparator, colPrefix, colPostfix, colSeparator);
        return sw.toString();
    }

    protected static void writeTo(PrintWriter writer, ReadableBigIntegerMatrix mx, String prefix, String postfix, String rowPrefix, String rowPostfix, String rowSeparator, String colPrefix, String colPostfix, String colSeparator) {
        int rows = mx.getRowCount();
        int cols = mx.getColumnCount();
        writer.print(prefix);
        int row = 0;
        while (row < rows) {
            if (row > 0) {
                writer.print(rowSeparator);
            }
            writer.print(rowPrefix);
            int col = 0;
            while (col < cols) {
                if (col > 0) {
                    writer.print(colSeparator);
                }
                writer.print(colPrefix);
                writer.print(mx.getBigIntegerValueAt(row, col));
                writer.print(colPostfix);
                ++col;
            }
            writer.print(rowPostfix);
            ++row;
        }
        writer.print(postfix);
        writer.flush();
    }

    @Override
    public DefaultBigIntegerMatrix clone() {
        return new DefaultBigIntegerMatrix((BigInteger[])this.mValues.clone(), -1, this.mColumnCount);
    }

    @Override
    public DefaultBigIntegerMatrix newInstance(int rows, int cols) {
        return new DefaultBigIntegerMatrix(rows, cols);
    }

    @Override
    public DefaultBigIntegerMatrix newInstance(BigInteger[][] data, boolean rowsInDim1) {
        int cols;
        int rows;
        if (rowsInDim1) {
            rows = data.length;
            cols = rows == 0 ? 0 : data[0].length;
        } else {
            cols = data.length;
            rows = cols == 0 ? 0 : data[0].length;
        }
        BigInteger[] values = new BigInteger[rows * cols];
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                BigInteger val;
                values[row * cols + col] = val = rowsInDim1 ? data[row][col] : data[col][row];
                ++col;
            }
            ++row;
        }
        return new DefaultBigIntegerMatrix(values, rows, cols);
    }

    @Override
    public BigIntegerMatrix toBigIntegerMatrix(boolean enforceNewInstance) {
        return enforceNewInstance ? this.clone() : this;
    }

    public BigIntegerMatrix toWritableMatrix(boolean enforceNewInstance) {
        return this.toBigIntegerMatrix(enforceNewInstance);
    }

    public BigIntegerMatrix toReadableMatrix(boolean enforceNewInstance) {
        return this.toBigIntegerMatrix(enforceNewInstance);
    }

    @Override
    public BigIntegerRationalMatrix toBigIntegerRationalMatrix(boolean enforceNewInstance) {
        return new DefaultBigIntegerRationalMatrix(this);
    }

    @Override
    public DoubleMatrix toDoubleMatrix(boolean enforceNewInstance) {
        return new DefaultDoubleMatrix(this);
    }

    @Override
    public void addRowToOtherRow(int srcRow, long srcFactor, int dstRow, long dstFactor) {
        this.addRowToOtherRow(srcRow, BigInteger.valueOf(srcFactor), dstRow, BigInteger.valueOf(dstFactor));
    }

    @Override
    public void addRowToOtherRow(int srcRow, int srcFactor, int dstRow, int dstFactor) {
        this.addRowToOtherRow(srcRow, BigInteger.valueOf(srcFactor), dstRow, BigInteger.valueOf(dstFactor));
    }

    @Override
    public void addRowToOtherRow(int srcRow, BigInteger srcFactor, int dstRow, BigInteger dstFactor) {
        int cols = this.getColumnCount();
        int col = 0;
        while (col < cols) {
            BigInteger srcProd = srcFactor.multiply(this.getBigIntegerValueAt(srcRow, col));
            BigInteger dstProd = dstFactor.multiply(this.getBigIntegerValueAt(dstRow, col));
            this.setValueAt(dstRow, col, srcProd.add(dstProd));
            ++col;
        }
    }

    @Override
    public void add(int row, int col, BigInteger value) {
        this.setValueAt(row, col, value.add(this.getBigIntegerValueAt(row, col)));
    }

    @Override
    public void add(int row, int col, int value) {
        this.add(row, col, BigInteger.valueOf(value));
    }

    @Override
    public void add(int row, int col, long value) {
        this.setValueAt(row, col, BigInteger.valueOf(value));
    }

    @Override
    public void multiply(int row, int col, int factor) {
        this.multiply(row, col, BigInteger.valueOf(factor));
    }

    @Override
    public void multiply(int row, int col, long factor) {
        this.setValueAt(row, col, BigInteger.valueOf(factor));
    }

    @Override
    public void multiply(int row, int col, BigInteger factor) {
        this.setValueAt(row, col, factor.multiply(this.getBigIntegerValueAt(row, col)));
    }

    @Override
    public void multiplyRow(int row, int factor) {
        this.multiplyRow(row, BigInteger.valueOf(factor));
    }

    @Override
    public void multiplyRow(int row, long factor) {
        this.multiplyRow(row, BigInteger.valueOf(factor));
    }

    @Override
    public void multiplyRow(int row, BigInteger factor) {
        int cols = this.getColumnCount();
        int col = 0;
        while (col < cols) {
            this.multiply(row, col, factor);
            ++col;
        }
    }

    public int hashCode() {
        int value = this.mColumnCount;
        int ii = 0;
        while (ii < this.mValues.length) {
            value ^= this.mValues[ii].hashCode() ^ this.mValues[ii].hashCode() >>> 32;
            ++ii;
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof LongMatrix) {
            LongMatrix other = (LongMatrix)obj;
            int rows = this.getRowCount();
            if (rows != other.getRowCount()) {
                return false;
            }
            int cols = this.getColumnCount();
            if (cols != other.getColumnCount()) {
                return false;
            }
            int row = 0;
            while (row < rows) {
                int col = 0;
                while (col < cols) {
                    BigInteger otVal;
                    BigInteger myVal = this.getBigIntegerValueAt(row, col);
                    if (!myVal.equals(otVal = other.getBigIntegerValueAt(row, col))) {
                        return false;
                    }
                    ++col;
                }
                ++row;
            }
            return true;
        }
        return false;
    }

    @Override
    public BigIntegerMatrix subBigIntegerMatrix(int rowStart, int rowEnd, int colStart, int colEnd) {
        DefaultBigIntegerMatrix res = new DefaultBigIntegerMatrix(rowEnd - rowStart, colEnd - colStart);
        int row = 0;
        while (row < res.getRowCount()) {
            int col = 0;
            while (col < res.getColumnCount()) {
                res.setValueAt(row, col, this.getBigIntegerValueAt(rowStart + row, colStart + col));
                ++col;
            }
            ++row;
        }
        return res;
    }

    @Override
    public BigIntegerRationalMatrix subBigIntegerRationalMatrix(int rowStart, int rowEnd, int colStart, int colEnd) {
        return this.subBigIntegerMatrix(rowStart, rowEnd, colStart, colEnd).toBigIntegerRationalMatrix(false);
    }

    @Override
    public DoubleMatrix subDoubleMatrix(int rowStart, int rowEnd, int colStart, int colEnd) {
        return this.subBigIntegerMatrix(rowStart, rowEnd, colStart, colEnd).toDoubleMatrix(false);
    }

    @Override
    public DefaultBigIntegerMatrix transpose() {
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        DefaultBigIntegerMatrix tr = new DefaultBigIntegerMatrix(cols, rows);
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                tr.setValueAt(col, row, this.getBigIntegerValueAt(row, col));
                ++col;
            }
            ++row;
        }
        return tr;
    }

    @Override
    public void toArray(BigInteger[] array) {
        if (array.length != this.mValues.length) {
            throw new IllegalArgumentException("expected array length " + this.mValues.length + " but found " + array.length);
        }
        if (this.mValues != array) {
            System.arraycopy(this.mValues, 0, array, 0, this.mValues.length);
        }
    }

    @Override
    public BigInteger[] toBigIntegerArray() {
        BigInteger[] array = new BigInteger[this.mValues.length];
        this.toArray(array);
        return array;
    }

    @Override
    public BigInteger getBigIntegerValueAt(int row, int col) {
        return this.mValues[row * this.mColumnCount + col];
    }

    @Override
    public void negate(int row, int col) {
        BigInteger val = this.getBigIntegerValueAt(row, col);
        this.setValueAt(row, col, val.signum() == 0 ? BigInteger.ZERO : val.negate());
    }
}

