/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polymake.parse;

import ch.javasoft.math.BigFraction;
import ch.javasoft.math.array.parse.DataType;
import ch.javasoft.polymake.parse.DefinitionType;
import ch.javasoft.polymake.parse.PolymakeMatrixData;
import ch.javasoft.polymake.parse.PolymakeMatrixDataImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;

public class PolymakeParser {
    private final int dim;
    private final PolymakeMatrixData[] polymakeMatrixData;

    public PolymakeParser(File file) throws FileNotFoundException, IOException {
        this(new FileInputStream(file));
    }

    public PolymakeParser(InputStream in) throws IOException {
        this(new InputStreamReader(in));
    }

    public PolymakeParser(Reader reader) throws IOException {
        this(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader));
    }

    public PolymakeParser(BufferedReader reader) throws IOException {
        Keyword key = null;
        ArrayList<PolymakeMatrixData> dataList = new ArrayList<PolymakeMatrixData>(2);
        int[] ptrDim = new int[]{-1};
        Token token = new Token(reader);
        while (!token.eof() && (key = token.asKeyword()) == null) {
            token.readNextLine();
        }
        while (ptrDim[0] < 0 || dataList.isEmpty() || key != null) {
            if (key == null) {
                if (ptrDim[0] < 0) {
                    throw token.createIOException("unexpected end of file, keyword " + (Object)((Object)Keyword.DIM) + " expected");
                }
                throw token.createIOException("unexpected end of file, either of the keywords " + (Object)((Object)Keyword.VERTICES) + " or " + (Object)((Object)Keyword.FACETS) + " expected");
            }
            if (Keyword.DIM.equals((Object)key)) {
                token.readNextLine();
                int dim = this.parseDim(token);
                if (ptrDim[0] < 0) {
                    ptrDim[0] = dim;
                } else if (ptrDim[0] != dim) {
                    throw token.createIOException("dimension missmatch, DIM=" + dim + ", data expected=" + (dim + 1) + " but found=" + (ptrDim[0] + 1));
                }
            } else {
                token.readNextLine();
                dataList.add(this.parseData(token, key, ptrDim));
            }
            key = null;
            while (!token.eof() && (key = token.asKeyword()) == null) {
                token.readNextLine();
            }
        }
        this.dim = ptrDim[0];
        this.polymakeMatrixData = dataList.toArray(new PolymakeMatrixData[dataList.size()]);
    }

    private int parseDim(Token token) throws IOException {
        try {
            return Integer.parseInt(token.line.trim());
        }
        catch (Exception e) {
            throw token.createIOException("cannot parse dimension \"" + token.line + "\", e=" + e);
        }
    }

    private PolymakeMatrixData parseData(Token token, Keyword key, int[] ptrDim) throws IOException {
        DefinitionType def = key.getDefinitionType();
        if (token.eof()) {
            throw token.createIOException("unexpected end of file, expected data values for " + (Object)((Object)key));
        }
        ArrayList<DataType> rowTypes = new ArrayList<DataType>();
        ArrayList<Object> rowData = new ArrayList<Object>();
        DataType matrixType = DataType.Int;
        boolean needsConversion = false;
        String[] parts = token.split();
        while (!(token.eof() || ptrDim[0] >= 0 && parts.length != ptrDim[0] + 1)) {
            if (ptrDim[0] < 0) {
                ptrDim[0] = parts.length - 1;
            }
            DataType rowType = matrixType;
            BigFraction[] vals = new BigFraction[parts.length];
            int i = 0;
            while (i < vals.length) {
                try {
                    String str = parts[i];
                    if (str != null && str.startsWith("+")) {
                        str = str.substring(1);
                    }
                    vals[i] = BigFraction.valueOf(str);
                    DataType valType = DataType.getTightestFit(vals[i]);
                    rowType = DataType.getLoosestType(rowType, valType);
                }
                catch (Exception e) {
                    throw token.createIOException("cannot parse number \"" + parts[i] + "\", e=" + e);
                }
                ++i;
            }
            if (matrixType.isTighterThan(rowType)) {
                matrixType = rowType;
                needsConversion = !rowTypes.isEmpty();
            }
            rowTypes.add(rowType);
            rowData.add(matrixType.asVector(vals));
            token.readNextLine();
            parts = token.split();
        }
        if (needsConversion) {
            int i = 0;
            while (i < rowData.size()) {
                DataType rowType = (DataType)((Object)rowTypes.get(i));
                if (rowType.isTighterThan(matrixType)) {
                    Object looser = rowType.asLooserVector(matrixType, rowData.get(i));
                    rowData.set(i, looser);
                } else if (matrixType.isTighterThan(rowType)) {
                    throw new RuntimeException("internal error: matrix type tighter than row type");
                }
                ++i;
            }
        }
        return new PolymakeMatrixDataImpl(def, matrixType, rowData);
    }

    public DefinitionType getDefinitionType() {
        if (this.polymakeMatrixData.length > 1) {
            return DefinitionType.Both;
        }
        return this.polymakeMatrixData[0].getDefinitionType();
    }

    public int getDim() {
        return this.dim;
    }

    public PolymakeMatrixData getData(int index) {
        return this.polymakeMatrixData[index];
    }

    public PolymakeMatrixData getData(DefinitionType type) {
        int i = 0;
        while (i < this.polymakeMatrixData.length) {
            if (this.polymakeMatrixData[i].getDefinitionType().equals((Object)type)) {
                return this.polymakeMatrixData[i];
            }
            ++i;
        }
        throw new IllegalArgumentException("cannot return data for type " + (Object)((Object)type));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("polymake data, P = { dim:");
        sb.append(this.dim);
        int i = 0;
        while (i < this.polymakeMatrixData.length) {
            sb.append(" , ");
            sb.append(this.polymakeMatrixData[i]);
            ++i;
        }
        sb.append(" }");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Keyword {
        DIM,
        POINTS,
        VERTICES,
        FACETS;


        public boolean matches(String line) {
            if (line == null) {
                return false;
            }
            return line.startsWith(this.name()) && line.substring(this.name().length()).trim().length() == 0;
        }

        public static Keyword parse(String line) {
            Keyword[] keywordArray = Keyword.values();
            int n = keywordArray.length;
            int n2 = 0;
            while (n2 < n) {
                Keyword key = keywordArray[n2];
                if (key.matches(line)) {
                    return key;
                }
                ++n2;
            }
            return null;
        }

        public DefinitionType getDefinitionType() {
            switch (this) {
                case VERTICES: {
                    return DefinitionType.Vertices;
                }
                case POINTS: {
                    return DefinitionType.Vertices;
                }
                case FACETS: {
                    return DefinitionType.Facets;
                }
            }
            throw new IllegalStateException("not supported for " + (Object)((Object)this));
        }
    }

    private static class Token {
        final BufferedReader reader;
        String line;
        int lineNo = 0;

        Token(BufferedReader reader) throws IOException {
            this.reader = reader;
            this.readNextLine();
        }

        boolean eof() {
            return this.line == null;
        }

        String readNextLine() throws IOException {
            this.line = this.reader.readLine();
            ++this.lineNo;
            return this.line;
        }

        Keyword asKeyword() {
            return Keyword.parse(this.line);
        }

        String[] split() {
            return this.line.trim().split("\\s+");
        }

        IOException createIOException(String msg) {
            return new IOException("[" + this.lineNo + "] " + msg + ": " + (this.line == null ? "<end of file>" : this.line));
        }
    }
}

