/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco.transform;

import ch.javasoft.math.array.ArrayOperations;
import ch.javasoft.math.linalg.LinAlgOperations;
import ch.javasoft.polco.PolyhedralCone;
import ch.javasoft.polco.impl.AbstractInequalityCone;
import ch.javasoft.polco.transform.LogPkg;
import ch.javasoft.polco.transform.TransformHelper;
import ch.javasoft.polco.transform.TransformedPolyhedralCone;
import ch.javasoft.util.logging.LogPrintWriter;
import ch.javasoft.util.logging.Loggers;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformedInequalityCone<Num extends Number, Arr>
extends AbstractInequalityCone<Num, Arr>
implements TransformedPolyhedralCone<Num, Arr> {
    private final PolyhedralCone<Num, Arr> parent;
    private final AtomicReference<Arr[]> mxTtoOriginal = new AtomicReference();
    private Arr[] mx_B1_negTA1_B2;
    private Arr[] mx_T;
    private int[] ixI;
    private int[] ixJ;

    public TransformedInequalityCone(PolyhedralCone<Num, Arr> toTransform) {
        super(toTransform.getLinAlgOperations());
        this.parent = toTransform;
        this.transform();
    }

    @Override
    public PolyhedralCone<Num, Arr> getParentCone() {
        return this.parent;
    }

    @Override
    public PolyhedralCone<Num, Arr> getOriginalCone() {
        return TransformHelper.getOriginalCone(this);
    }

    @Override
    public Arr[] getB() {
        return this.mx_B1_negTA1_B2;
    }

    @Override
    public Num getB(int row, int col) {
        return (Num)this.getLinAlgOperations().get(this.mx_B1_negTA1_B2, row, col);
    }

    @Override
    public int getRowCountB() {
        return this.getArrayOperations().getRowCount(this.mx_B1_negTA1_B2);
    }

    @Override
    public int getDimensions() {
        return this.getArrayOperations().getColumnCount(this.mx_B1_negTA1_B2);
    }

    public ArrayOperations<Arr> getArrayOperations() {
        return this.getLinAlgOperations().getArrayOperations();
    }

    private Arr[] createT(Arr[] mxNegTA2, int[] ixI, int[] ixJ) {
        int cols = ixJ.length;
        A[] mxT = this.arrayOps.newMatrix(ixI.length + ixJ.length, ixJ.length);
        int i = 0;
        while (i < ixI.length) {
            this.arrayOps.copyMatrixRowElements(mxNegTA2, i, 0, mxT, ixI[i], 0, cols);
            ++i;
        }
        i = 0;
        while (i < ixJ.length) {
            int j = 0;
            while (j < cols) {
                this.numberArrayOps.setAll(mxT[ixJ[i]], this.numberOps.zero());
                ++j;
            }
            this.numberArrayOps.set(mxT[ixJ[i]], i, this.numberOps.one());
            ++i;
        }
        return mxT;
    }

    @Override
    public Arr[] getTransformationMatrixToParent() {
        return this.mx_T;
    }

    @Override
    public Arr transformToOriginal(Arr x2) {
        return TransformHelper.transformToOriginal(this, this.mxTtoOriginal, x2);
    }

    private void transform() {
        LinAlgOperations linalg = this.getLinAlgOperations();
        ArrayOperations<Arr> aops = this.getArrayOperations();
        Arr[] mxA = this.parent.getA();
        Arr[] mxB = this.parent.getB();
        int rows = aops.getRowCount(mxA);
        int cols = aops.getColumnCount(mxA);
        int[] rowmap = new int[rows];
        int[] colmap = new int[cols];
        int[] ptrRank = new int[1];
        Arr[] mxT = linalg.invertMaximalSubmatrix(mxA, rowmap, colmap, ptrRank);
        int rank = ptrRank[0];
        int[] ixR = rank == rows ? rowmap : TransformedInequalityCone.getIndexSet(rowmap, rank);
        this.ixI = TransformedInequalityCone.getIndexSet(colmap, rank);
        this.ixJ = TransformedInequalityCone.getComplementSet(colmap, rank);
        Arr[] mxA2 = aops.copyOfSubMatrix(mxA, ixR, this.ixJ);
        Arr[] mxB1 = aops.copyOfColumnSubMatrix(mxB, this.ixI);
        Arr[] mxB2 = aops.copyOfColumnSubMatrix(mxB, this.ixJ);
        if (Loggers.isLoggable(LogPkg.LOGGER, Level.FINE)) {
            LogPkg.LOGGER.fine("matrix " + aops.getMatrixSignatureString("A", mxA) + " has rank " + rank);
            if (rank < rows) {
                LogPkg.LOGGER.fine("using non-redundant rows of A: " + Arrays.toString(ixR));
            }
            LogPkg.LOGGER.fine("I: " + Arrays.toString(this.ixI));
            LogPkg.LOGGER.fine("J: " + Arrays.toString(this.ixJ));
            if (Loggers.isLoggable(LogPkg.LOGGER, Level.FINEST)) {
                Arr[] mxA1 = aops.copyOfSubMatrix(mxA, rowmap, this.ixI);
                LogPrintWriter finestWriter = new LogPrintWriter(LogPkg.LOGGER, Level.FINEST);
                aops.printMatrix(finestWriter, "T", mxT);
                aops.printMatrix(finestWriter, "A1", mxA1);
                aops.printMatrix(finestWriter, "A2", mxA2);
                aops.printMatrix(finestWriter, "B1", mxB1);
                aops.printMatrix(finestWriter, "B2", mxB2);
                finestWriter.flush();
            }
        }
        Arr[] mx_negT = linalg.negate(mxT);
        Arr[] mx_negTA2 = this.normalize(linalg.multiply(mx_negT, (A[])mxA2));
        this.mx_T = this.normalize(this.createT(mx_negTA2, this.ixI, this.ixJ));
        Arr[] mx_negTA1 = linalg.multiply(linalg.multiply(mxB1, (A[])mx_negT), (A[])mxA2);
        this.mx_B1_negTA1_B2 = this.normalize(linalg.add(mx_negTA1, mxB2));
        if (Loggers.isLoggable(LogPkg.LOGGER, Level.FINE)) {
            int r_negTA2 = aops.getRowCount(mx_negTA2);
            int c_negTA2 = aops.getColumnCount(mx_negTA2);
            int r_B1_negTA1_B2 = aops.getRowCount(this.mx_B1_negTA1_B2);
            int c_B1_negTA1_B2 = aops.getColumnCount(this.mx_B1_negTA1_B2);
            LogPkg.LOGGER.fine("transformed cone: P = { x1 = -T A2 x2  ,  ( -B1 T A2 + B2 ) x2 >= 0  ;  (-T A2):" + r_negTA2 + "x" + c_negTA2 + " , (-B1 T A2 + B2):" + r_B1_negTA1_B2 + "x" + c_B1_negTA1_B2 + " }");
            if (Loggers.isLoggable(LogPkg.LOGGER, Level.FINER)) {
                LogPrintWriter finerWriter = new LogPrintWriter(LogPkg.LOGGER, Level.FINER);
                aops.printMatrix(finerWriter, "(-T A2)", mx_negTA2);
                aops.printMatrix(finerWriter, "(-B1 T A2 + B2)", this.mx_B1_negTA1_B2);
                finerWriter.flush();
            }
        }
    }

    private static int[] getIndexSet(int[] set, int rank) {
        int[] ind = new int[rank];
        System.arraycopy(set, 0, ind, 0, rank);
        return ind;
    }

    private static int[] getComplementSet(int[] set, int rank) {
        int[] ind = new int[set.length - rank];
        System.arraycopy(set, rank, ind, 0, ind.length);
        return ind;
    }
}

