/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco.transform;

import ch.javasoft.math.array.ExpressionComposer;
import ch.javasoft.math.array.NumberArrayOperations;
import ch.javasoft.math.linalg.LinAlgOperations;
import ch.javasoft.math.operator.BooleanUnaryOperator;
import ch.javasoft.math.operator.UnaryOperator;
import ch.javasoft.polco.PolyhedralCone;
import ch.javasoft.polco.transform.TransformedPolyhedralCone;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransformHelper {
    public static <N extends Number, A> PolyhedralCone<N, A> getOriginalCone(PolyhedralCone<N, A> polycone) {
        while (polycone instanceof TransformedPolyhedralCone) {
            polycone = ((TransformedPolyhedralCone)polycone).getParentCone();
        }
        return polycone;
    }

    public static <N extends Number, A> A[] getTransformationMatrixToOriginal(TransformedPolyhedralCone<N, A> transformedCone) {
        LinAlgOperations lops = transformedCone.getLinAlgOperations();
        PolyhedralCone<Object, Object> parent = transformedCone.getParentCone();
        Object[] mxT = transformedCone.getTransformationMatrixToParent();
        while (parent instanceof TransformedPolyhedralCone) {
            transformedCone = (TransformedPolyhedralCone)parent;
            mxT = lops.multiply(transformedCone.getTransformationMatrixToParent(), (A[])mxT);
            parent = transformedCone.getParentCone();
        }
        UnaryOperator norm = lops.getNumberOperators().unary(UnaryOperator.Id.normalize);
        lops.getNumberArrayOperations().applyToEachElement(mxT, mxT, norm);
        return mxT;
    }

    public static <N extends Number, A> A transformToOriginal(TransformedPolyhedralCone<N, A> transformedCone, AtomicReference<A[]> matrixT, A x2) {
        A[] mxT = matrixT.get();
        if (mxT == null) {
            matrixT.compareAndSet(null, TransformHelper.getTransformationMatrixToOriginal(transformedCone));
            mxT = matrixT.get();
        }
        LinAlgOperations lops = transformedCone.getLinAlgOperations();
        UnaryOperator norm = lops.getNumberOperators().unary(UnaryOperator.Id.normalize);
        A x = lops.multiply(mxT, x2);
        lops.getNumberArrayOperations().applyToEachElement(x, x, norm);
        return x;
    }

    public static <N extends Number, A> A transformToOriginal(PolyhedralCone<N, A> polycone, A transformed) {
        if (polycone instanceof TransformedPolyhedralCone) {
            NumberArrayOperations naops = polycone.getLinAlgOperations().getNumberArrayOperations();
            ExpressionComposer composer = naops.getExpressionComposer();
            A original = ((TransformedPolyhedralCone)polycone).transformToOriginal(transformed);
            int dims = TransformHelper.getOriginalCone(polycone).getDimensions();
            Number div = (Number)composer.vectorNormDivisor().operate(original, 0, dims);
            return TransformHelper.divAndNormalize(naops, div, original);
        }
        return transformed;
    }

    private static <N extends Number, A> A divAndNormalize(NumberArrayOperations<N, A> naops, N div, A vector) {
        ExpressionComposer<N, A> composer = naops.getExpressionComposer();
        BooleanUnaryOperator<N, A> isZero = composer.isZero();
        BooleanUnaryOperator<N, A> isOne = composer.isOne();
        UnaryOperator<N, A> norm = !isZero.booleanOperate(div) && !isOne.booleanOperate(div) ? composer.normalize(composer.divFreeBy(composer.constant(div))) : composer.normalize();
        naops.applyToEachElement(vector, vector, norm);
        return vector;
    }

    private TransformHelper() {
    }
}

