/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco.metabolic;

import ch.javasoft.math.BigFraction;
import ch.javasoft.math.array.ExpressionComposer;
import ch.javasoft.math.array.NumberArrayOperations;
import ch.javasoft.math.operator.BooleanUnaryOperator;
import ch.javasoft.math.operator.UnaryOperator;
import ch.javasoft.math.operator.impl.BigFractionOperators;
import ch.javasoft.math.operator.impl.DoubleOperators;
import ch.javasoft.metabolic.FluxDistribution;
import ch.javasoft.metabolic.efm.output.AbstractOutputCallback;
import ch.javasoft.metabolic.efm.output.CallbackGranularity;
import ch.javasoft.metabolic.efm.output.EfmOutputEvent;
import ch.javasoft.polco.PolyhedralCone;
import ch.javasoft.polco.transform.TransformHelper;
import ch.javasoft.polco.xenum.ExtremeRayCallback;
import ch.javasoft.polco.xenum.ExtremeRayEvent;
import ch.javasoft.util.numeric.Zero;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EfmOutputCallbackToExtremeRayCallback<Num extends Number, Arr>
extends AbstractOutputCallback {
    private final PolyhedralCone<Num, Arr> polycone;
    private final ExtremeRayCallback<Num, Arr> callback;
    private final CallbackGranularity granularity;
    private final boolean allowLoggingDuringOutput;
    private final Zero coreZero;
    private final AtomicBoolean iterateRays = new AtomicBoolean();
    private final AtomicReference<ExtremeRayEvent<Num, Arr>> event = new AtomicReference();
    private final AtomicLong index = new AtomicLong();

    public EfmOutputCallbackToExtremeRayCallback(PolyhedralCone<Num, Arr> polycone, ExtremeRayCallback<Num, Arr> callback, CallbackGranularity granularity, boolean allowLoggingDuringOutput, Zero coreZero) {
        this.polycone = polycone;
        this.callback = callback;
        this.granularity = granularity;
        this.allowLoggingDuringOutput = allowLoggingDuringOutput;
        this.coreZero = coreZero;
    }

    @Override
    public boolean allowLoggingDuringOutput() {
        return this.allowLoggingDuringOutput;
    }

    @Override
    public CallbackGranularity getGranularity() {
        return this.iterateRays.get() ? this.granularity : CallbackGranularity.Null;
    }

    private PolyhedralCone<Num, Arr> getOriginalCone() {
        return TransformHelper.getOriginalCone(this.polycone);
    }

    private Arr transformToOriginal(Arr transformed) {
        return TransformHelper.transformToOriginal(this.polycone, transformed);
    }

    @Override
    protected void callbackPre(EfmOutputEvent evt) throws IOException {
        ExtremeRayEvent<Num, Arr> xevt = new ExtremeRayEvent<Num, Arr>(this.getOriginalCone(), evt.getEfmCount());
        this.iterateRays.set(this.callback.initialize(xevt));
        this.event.set(xevt);
        this.index.set(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void callbackEfmOut(EfmOutputEvent evt) throws IOException {
        FluxDistribution dist = evt.getEfm();
        int dims = this.polycone.getDimensions();
        if (dist.getSize() != dims) {
            throw new IOException("internal error: expected " + dims + " dimensions, but found " + dist.getSize() + " flux values");
        }
        Object xray = EfmOutputCallbackToExtremeRayCallback.convertDistToRay(this.polycone.getLinAlgOperations().getNumberArrayOperations(), this.coreZero, dist);
        long currentIndex = this.index.getAndIncrement();
        Object oray = this.transformToOriginal(xray);
        ExtremeRayEvent<Num, Arr> xevt = this.event.get();
        ExtremeRayCallback<Num, Arr> extremeRayCallback = this.callback;
        synchronized (extremeRayCallback) {
            this.callback.outputExtremeRay(xevt, currentIndex, oray);
        }
    }

    private static <N extends Number, A> A convertDistToRay(NumberArrayOperations<N, A> naops, Zero coreZero, FluxDistribution dist) {
        int len = dist.getSize();
        if (dist.getPreferredNumberClass().equals(naops.numberClass())) {
            A xray;
            if (naops.numberClass().equals(Double.class)) {
                xray = naops.arrayClass().cast(dist.getDoubleRates());
            } else {
                xray = naops.newZeroVector(len);
                int i = 0;
                while (i < len) {
                    if (dist.getRateSignum(i) != 0) {
                        Number val = dist.getNumberRate(i);
                        naops.set(xray, i, (Number)naops.numberClass().cast(val));
                    }
                    ++i;
                }
            }
            return EfmOutputCallbackToExtremeRayCallback.normalize(naops, xray);
        }
        if (dist.getPreferredNumberClass().equals(Double.class)) {
            BigFraction[] tmp = new BigFraction[len];
            int i = 0;
            while (i < len) {
                double val = dist.getDoubleRates()[i];
                tmp[i] = coreZero.isZero(val) ? BigFraction.ZERO : (coreZero.isOne(val) ? BigFraction.ONE : BigFraction.valueOfAdjusted(val, coreZero.mZeroPos));
                ++i;
            }
            NumberArrayOperations<BigFraction, BigFraction[]> fraAops = BigFractionOperators.INSTANCE.getNumberArrayOperations();
            if (naops.getNumberOperators().getDivisionSupport().mightCauseException()) {
                tmp = EfmOutputCallbackToExtremeRayCallback.squeezeVector(fraAops, tmp);
                return fraAops.getConverterTo(naops).convertVector(tmp);
            }
            A xray = fraAops.getConverterTo(naops).convertVector(tmp);
            return EfmOutputCallbackToExtremeRayCallback.normalize(naops, xray);
        }
        if (naops.getNumberOperators().getDivisionSupport().mightCauseException()) {
            if (dist.getPreferredNumberClass().equals(Double.class)) {
                NumberArrayOperations<Double, double[]> dblAops = new DoubleOperators(coreZero).getNumberArrayOperations();
                double[] tmp = EfmOutputCallbackToExtremeRayCallback.squeezeFluxDist(dblAops, coreZero, dist);
                return dblAops.getConverterTo(naops).convertVector(tmp);
            }
            NumberArrayOperations<BigFraction, BigFraction[]> fraAops = BigFractionOperators.INSTANCE.getNumberArrayOperations();
            BigFraction[] tmp = EfmOutputCallbackToExtremeRayCallback.squeezeFluxDist(fraAops, coreZero, dist);
            return fraAops.getConverterTo(naops).convertVector(tmp);
        }
        A xray = naops.newZeroVector(len);
        int i = 0;
        while (i < len) {
            if (dist.getRateSignum(i) != 0) {
                Number val = dist.getNumberRate(i);
                naops.set(xray, i, (Number)naops.convertNumber(val));
            }
            ++i;
        }
        return EfmOutputCallbackToExtremeRayCallback.normalize(naops, xray);
    }

    private static <N extends Number, A> A normalize(NumberArrayOperations<N, A> naops, A vector) {
        ExpressionComposer<N, A> composer = naops.getExpressionComposer();
        int len = naops.getArrayOperations().getLength(vector);
        Number div = (Number)composer.vectorNormDivisor().operate(vector, 0, len);
        return EfmOutputCallbackToExtremeRayCallback.divAndNormalize(naops, div, vector);
    }

    private static <N extends Number, A> A squeezeFluxDist(NumberArrayOperations<N, A> naops, Zero coreZero, FluxDistribution dist) {
        A tmp = EfmOutputCallbackToExtremeRayCallback.convertDistToRay(naops, coreZero, dist);
        return EfmOutputCallbackToExtremeRayCallback.squeezeVector(naops, tmp);
    }

    private static <N extends Number, A> A squeezeVector(NumberArrayOperations<N, A> naops, A vector) {
        ExpressionComposer<N, A> composer = naops.getExpressionComposer();
        int len = naops.getArrayOperations().getLength(vector);
        Number div = (Number)composer.vectorSqueezeDivisor().operate(vector, 0, len);
        return EfmOutputCallbackToExtremeRayCallback.divAndNormalize(naops, div, vector);
    }

    private static <N extends Number, A> A divAndNormalize(NumberArrayOperations<N, A> naops, N div, A vector) {
        ExpressionComposer<N, A> composer = naops.getExpressionComposer();
        BooleanUnaryOperator<N, A> isZero = composer.isZero();
        BooleanUnaryOperator<N, A> isOne = composer.isOne();
        UnaryOperator<N, A> norm = !isZero.booleanOperate(div) && !isOne.booleanOperate(div) ? composer.normalize(composer.divFreeBy(composer.constant(div))) : composer.normalize();
        naops.applyToEachElement(vector, vector, norm);
        return vector;
    }

    @Override
    protected void callbackPost(EfmOutputEvent evt) throws IOException {
        ExtremeRayEvent xevt = this.event.getAndSet(null);
        this.callback.terminate(xevt);
        if (!this.iterateRays.get()) {
            this.index.set(xevt.getRayCount());
        }
    }

    long getIndex() {
        return this.index.get();
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }
}

