/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.numeric.varint;

import ch.javasoft.numeric.varint.VarInt;
import ch.javasoft.numeric.varint.VarIntFactory;
import java.math.BigInteger;
import java.math.RoundingMode;

public abstract class VarIntNumber
extends Number
implements VarInt {
    private static final long serialVersionUID = 2434251503842824601L;

    public VarInt[] divideAndRemainder(VarInt val) {
        BigInteger[] divRem = this.toBigInteger().divideAndRemainder(val.toBigInteger());
        return new VarInt[]{VarIntFactory.create(divRem[0]), VarIntFactory.create(divRem[1])};
    }

    public VarIntNumber divide(VarInt val, RoundingMode roundingMode) {
        if (RoundingMode.DOWN.equals((Object)roundingMode)) {
            return this.divide(val);
        }
        VarInt[] divRem = this.divideAndRemainder(val);
        VarIntNumber intval = VarIntFactory.convert(divRem[0]);
        if (divRem[1].isZero()) {
            return intval;
        }
        VarIntNumber remval = VarIntFactory.convert(divRem[1]);
        switch (roundingMode) {
            case UP: {
                return intval.isNegative() ? intval.subtract(VarInt.ONE) : intval.add(VarInt.ONE);
            }
            case DOWN: {
                throw new RuntimeException("internal error: " + (Object)((Object)roundingMode) + " is handled above");
            }
            case CEILING: {
                return intval.isNegative() ? intval : intval.add(VarInt.ONE);
            }
            case FLOOR: {
                return intval.isNegative() ? intval.subtract(VarInt.ONE) : intval;
            }
            case HALF_UP: 
            case HALF_DOWN: 
            case HALF_EVEN: {
                int cmp;
                VarIntNumber remTwice = remval.shiftLeft(1);
                int n = cmp = intval.signum() == val.signum() ? intval.signum() * remTwice.compareTo(val) : remTwice.abs().compareTo(val.abs());
                if (RoundingMode.HALF_DOWN.equals((Object)roundingMode) || RoundingMode.HALF_EVEN.equals((Object)roundingMode) && intval.isEven()) {
                    return cmp > 0 ? (intval.isNegative() ? intval.subtract(VarInt.ONE) : intval.add(VarInt.ONE)) : intval;
                }
                return cmp >= 0 ? (intval.isNegative() ? intval.subtract(VarInt.ONE) : intval.add(VarInt.ONE)) : intval;
            }
            case UNNECESSARY: {
                throw new ArithmeticException("rounding necessary: " + this + "/" + val);
            }
        }
        throw new RuntimeException("unknown rounding mode: " + (Object)((Object)roundingMode));
    }

    public abstract VarIntNumber compact();

    public abstract VarIntNumber abs();

    public abstract VarIntNumber add(VarInt var1);

    public abstract VarIntNumber divide(VarInt var1);

    public abstract VarIntNumber gcd(VarInt var1);

    public abstract VarIntNumber max(VarInt var1);

    public abstract VarIntNumber min(VarInt var1);

    public abstract VarIntNumber pow(int var1);

    public abstract VarIntNumber remainder(VarInt var1);

    public abstract VarIntNumber mod(VarInt var1);

    public abstract VarIntNumber multiply(VarInt var1);

    public abstract VarIntNumber negate();

    public abstract VarIntNumber shiftLeft(int var1);

    public abstract VarIntNumber shiftRight(int var1);

    public abstract VarIntNumber subtract(VarInt var1);

    public boolean isZero() {
        return this.signum() == 0;
    }

    public boolean isNegative() {
        return this.signum() < 0;
    }

    public boolean isPositive() {
        return this.signum() > 0;
    }

    public boolean isNonNegative() {
        return this.signum() >= 0;
    }

    public boolean isNonPositive() {
        return this.signum() <= 0;
    }

    public byte byteValue() {
        return (byte)this.longValue();
    }

    public float floatValue() {
        return (float)this.doubleValue();
    }

    public int intValue() {
        return (int)this.longValue();
    }

    public VarIntNumber numberValue() {
        return this;
    }

    public short shortValue() {
        return (short)this.longValue();
    }

    public String toString() {
        return this.toString(10);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof VarInt) {
            return this.compareTo((VarInt)obj) == 0;
        }
        return false;
    }
}

