/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.numeric.varint;

import ch.javasoft.numeric.varint.LongVarInt;
import ch.javasoft.numeric.varint.VarInt;
import ch.javasoft.numeric.varint.VarIntFactory;
import ch.javasoft.numeric.varint.VarIntNumber;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class IntVarInt
extends VarIntNumber {
    private static final long serialVersionUID = -3452554456179800083L;
    protected final int value;

    protected IntVarInt(int value) {
        this.value = value;
    }

    protected static IntVarInt valueOf(int value) {
        return VarIntFactory.CACHE.cacheGet(value);
    }

    public VarIntNumber compact() {
        return this;
    }

    public boolean isZero() {
        return this.value == 0;
    }

    public boolean isOne() {
        return this.value == 1;
    }

    public boolean isNegative() {
        return this.value < 0;
    }

    public boolean isPositive() {
        return this.value > 0;
    }

    public boolean isNonNegative() {
        return this.value >= 0;
    }

    public boolean isNonPositive() {
        return this.value <= 0;
    }

    public boolean isEven() {
        return (1 & this.value) == 0;
    }

    public boolean testBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        return (this.value & 1 << n) != 0;
    }

    public int bitCount() {
        return Integer.bitCount(this.value >= 0 ? this.value : ~this.value);
    }

    public int bitLength() {
        return 32 - Integer.numberOfLeadingZeros(this.value >= 0 ? this.value : ~this.value);
    }

    public double doubleValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public int intValue() {
        return this.value;
    }

    public VarIntNumber abs() {
        return this.value < 0 ? IntVarInt.valueOf(-this.value) : this;
    }

    public VarIntNumber add(VarInt val) {
        if (val instanceof IntVarInt) {
            long other = ((IntVarInt)val).value;
            long sum = (long)this.value + other;
            return VarIntFactory.create(sum);
        }
        return VarIntFactory.convert(val.add(this));
    }

    public VarIntNumber divide(VarInt val) {
        if (val instanceof IntVarInt) {
            int div = ((IntVarInt)val).value;
            return div == -1 ? this.negate() : IntVarInt.valueOf(this.value / div);
        }
        if (val instanceof LongVarInt) {
            long div = ((LongVarInt)val).value;
            return div == -1L ? this.negate() : VarIntFactory.create((long)this.value / div);
        }
        return VarIntFactory.create(this.toBigInteger().divide(val.toBigInteger()));
    }

    public VarIntNumber gcd(VarInt val) {
        if (val instanceof IntVarInt) {
            return IntVarInt.valueOf(IntVarInt.gcd(this.value, ((IntVarInt)val).value));
        }
        return VarIntFactory.convert(val.gcd(this));
    }

    static int gcd(int iA, int iB) {
        iA = Math.abs(iA);
        iB = Math.abs(iB);
        if (iA < 0 || iB < 0) {
            if (((iA | iB) & 1) != 0) {
                return 1;
            }
            iA = Math.abs(iA >>> 1);
            iB = Math.abs(iB >>> 1);
        }
        if (iA == 0) {
            return iB;
        }
        if (iB == 0) {
            return iA;
        }
        int iMax = Math.max(iA, iB);
        int iMin = Math.min(iA, iB);
        while (iMax != iMin) {
            if (iMax % iMin == 0) {
                return iMin;
            }
            int tmp = iMin;
            iMin = iMax - iMax / iMin * iMin;
            iMax = tmp;
        }
        return iMin;
    }

    public VarIntNumber max(VarInt val) {
        if (val instanceof IntVarInt) {
            int other = ((IntVarInt)val).value;
            return this.value >= other ? this : VarIntFactory.convert(val);
        }
        return VarIntFactory.convert(val.max(this));
    }

    public VarIntNumber min(VarInt val) {
        if (val instanceof IntVarInt) {
            int other = ((IntVarInt)val).value;
            return this.value <= other ? this : VarIntFactory.convert(val);
        }
        return VarIntFactory.convert(val.min(this));
    }

    public VarIntNumber mod(VarInt m) {
        if (m instanceof IntVarInt) {
            int mod = ((IntVarInt)m).value;
            int rem = this.value % mod;
            return IntVarInt.valueOf(rem < 0 ? rem + mod : rem);
        }
        if (m instanceof LongVarInt) {
            long mod = ((IntVarInt)m).value;
            long rem = (long)this.value % mod;
            return VarIntFactory.create(rem < 0L ? rem + mod : rem);
        }
        return VarIntFactory.create(this.toBigInteger().mod(m.toBigInteger()));
    }

    public VarIntNumber multiply(VarInt val) {
        if (val instanceof IntVarInt) {
            long other = ((IntVarInt)val).value;
            long sum = (long)this.value * other;
            return VarIntFactory.create(sum);
        }
        return VarIntFactory.convert(val.multiply(this));
    }

    public VarIntNumber negate() {
        return VarIntFactory.create(-((long)this.value));
    }

    public VarIntNumber pow(int exponent) {
        return VarIntFactory.create(this.toBigInteger().pow(exponent));
    }

    public VarIntNumber remainder(VarInt val) {
        if (val instanceof IntVarInt) {
            return IntVarInt.valueOf(this.value % ((IntVarInt)val).value);
        }
        if (val instanceof LongVarInt) {
            return VarIntFactory.create((long)this.value % ((LongVarInt)val).value);
        }
        return VarIntFactory.create(this.toBigInteger().remainder(val.toBigInteger()));
    }

    public VarIntNumber shiftLeft(int n) {
        if (n < 0) {
            return IntVarInt.valueOf(this.value >> -n);
        }
        int space = Integer.numberOfLeadingZeros(this.value);
        if (n < space) {
            return IntVarInt.valueOf(this.value << n);
        }
        if (n < (space += 32)) {
            return VarIntFactory.create((long)this.value << n);
        }
        return VarIntFactory.create(this.toBigInteger().shiftLeft(n));
    }

    public VarIntNumber shiftRight(int n) {
        if (n < 0) {
            return this.shiftLeft(-n);
        }
        return IntVarInt.valueOf(this.value >> n);
    }

    public int signum() {
        return this.value == 0 ? 0 : (this.value < 0 ? -1 : 1);
    }

    public VarIntNumber subtract(VarInt val) {
        long other;
        if (val instanceof IntVarInt) {
            other = ((IntVarInt)val).value;
        } else if (val instanceof IntVarInt) {
            other = ((IntVarInt)val).value;
        } else {
            return VarIntFactory.create(this.toBigInteger().subtract(val.toBigInteger()));
        }
        long result = (long)this.value - other;
        if (((long)this.value ^ other) >= 0L && (result ^ other) < 0L) {
            return VarIntFactory.create(this.toBigInteger().subtract(val.toBigInteger()));
        }
        return VarIntFactory.create(result);
    }

    public BigInteger toBigInteger() {
        return BigInteger.valueOf(this.value);
    }

    public byte[] toByteArray() {
        return VarIntFactory.toByteArray(this.value);
    }

    public void writeTo(OutputStream out) throws IOException {
        VarIntFactory.writeInt(out, this.value);
    }

    public String toString(int radix) {
        return Integer.toString(this.value, radix);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int compareTo(VarInt o) {
        if (o instanceof IntVarInt) {
            return this.value - ((IntVarInt)o).value;
        }
        return -o.compareTo(this);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IntVarInt) {
            return this.value == ((IntVarInt)obj).value;
        }
        if (obj instanceof VarInt) {
            return ((VarInt)obj).equals(this);
        }
        return false;
    }
}

