/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.util;

import ch.javasoft.math.NumberOperations;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Metabolite;
import ch.javasoft.metabolic.MetaboliteRatio;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.util.LogPkg;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.util.genarr.ArrayIterable;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoichiometricMatrices {
    private static final Logger LOG = LogPkg.LOGGER;

    public static double[][] createStoichiometricMatrix(MetabolicNetwork metaNet) {
        HashMap<Metabolite, Integer> metaPos = new HashMap<Metabolite, Integer>();
        ArrayIterable<? extends Metabolite> metas = metaNet.getMetabolites();
        ArrayIterable<? extends Reaction> reacts = metaNet.getReactions();
        int ii = 0;
        while (ii < metas.length()) {
            metaPos.put(metas.get(ii), ii);
            ++ii;
        }
        double[][] result = new double[metas.length()][reacts.length()];
        int reactIndex = 0;
        while (reactIndex < reacts.length()) {
            for (MetaboliteRatio metaboliteRatio : reacts.get(reactIndex).getMetaboliteRatios()) {
                int metaIndex = (Integer)metaPos.get(metaboliteRatio.getMetabolite());
                if (result[metaIndex][reactIndex] != 0.0) {
                    LOG.warning("multiple occurrences of metabolite " + metaboliteRatio.getMetabolite() + " in reaction " + reacts.get(reactIndex).getName() + ": " + reacts.get(reactIndex));
                }
                double[] dArray = result[metaIndex];
                int n = reactIndex;
                dArray[n] = dArray[n] + metaboliteRatio.getRatio();
            }
            ++reactIndex;
        }
        return result;
    }

    public static double[][] createStoichiometricMatrixExpandReversible(MetabolicNetwork metaNet) {
        HashMap<Metabolite, Integer> metaPos = new HashMap<Metabolite, Integer>();
        ArrayIterable<? extends Metabolite> metas = metaNet.getMetabolites();
        ArrayIterable<? extends Reaction> reacts = metaNet.getReactions();
        int ii = 0;
        while (ii < metas.length()) {
            metaPos.put(metas.get(ii), ii);
            ++ii;
        }
        int reacCnt = 0;
        for (Reaction reaction : reacts) {
            if (reaction.getConstraints().isReversible()) {
                reacCnt += 2;
                continue;
            }
            ++reacCnt;
        }
        double[][] dArray = new double[metas.length()][reacCnt];
        int reactIndex = 0;
        int reversible = 0;
        for (Reaction reaction : reacts) {
            boolean forward = false;
            do {
                boolean bl = forward = !forward;
                if (!forward) {
                    ++reversible;
                }
                for (MetaboliteRatio metaboliteRatio : reacts.get(reactIndex).getMetaboliteRatios()) {
                    Metabolite meta = metaboliteRatio.getMetabolite();
                    int metaIndex = (Integer)metaPos.get(meta);
                    if (dArray[metaIndex][reactIndex + reversible] != 0.0) {
                        LOG.warning("multiple occurrences of metabolite " + metaboliteRatio.getMetabolite() + " in reaction " + reacts.get(reactIndex).getName() + ": " + reacts.get(reactIndex));
                    }
                    double[] dArray2 = dArray[metaIndex];
                    int n = reactIndex + reversible;
                    dArray2[n] = dArray2[n] + (forward ? metaboliteRatio.getRatio() : -metaboliteRatio.getRatio());
                }
            } while (forward && reaction.getConstraints().isReversible());
            ++reactIndex;
        }
        return dArray;
    }

    public static <N extends Number> N[][] createStoichiometricMatrixExpandReversible(ReadableMatrix<N> stoich, boolean[] reversible) {
        int revs = 0;
        int i = 0;
        while (i < reversible.length) {
            if (reversible[i]) {
                ++revs;
            }
            ++i;
        }
        int rows = stoich.getRowCount();
        int cols = stoich.getColumnCount();
        NumberOperations<Number> numberOps = stoich.getNumberOperations();
        Number[][] result = (Number[][])Array.newInstance(numberOps.numberClass(), rows, cols + revs);
        int row = 0;
        while (row < rows) {
            int rev = 0;
            int col = 0;
            while (col < cols) {
                result[row][col + rev] = stoich.getNumberValueAt(row, col);
                if (reversible[col]) {
                    result[row][col + ++rev] = numberOps.negate(result[row][col + rev - 1]);
                }
                ++col;
            }
            ++row;
        }
        return result;
    }

    public static boolean[][] createStoichiometricMatrixBoolean(MetabolicNetwork metaNet) {
        HashMap<Metabolite, Integer> metaPos = new HashMap<Metabolite, Integer>();
        ArrayIterable<? extends Metabolite> metas = metaNet.getMetabolites();
        ArrayIterable<? extends Reaction> reacts = metaNet.getReactions();
        int ii = 0;
        while (ii < metas.length()) {
            metaPos.put(metas.get(ii), ii);
            ++ii;
        }
        boolean[][] result = new boolean[metas.length()][reacts.length()];
        int reactIndex = 0;
        while (reactIndex < reacts.length()) {
            for (MetaboliteRatio metaboliteRatio : reacts.get(reactIndex).getMetaboliteRatios()) {
                int metaIndex = (Integer)metaPos.get(metaboliteRatio.getMetabolite());
                boolean bl = result[metaIndex][reactIndex] = metaboliteRatio.getRatio() != 0.0;
            }
            ++reactIndex;
        }
        return result;
    }

    private StoichiometricMatrices() {
    }
}

