/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.util;

import ch.javasoft.metabolic.FluxDistribution;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Metabolite;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.util.MetabolicNetworkUtil;
import ch.javasoft.util.genarr.ArrayIterable;
import ch.javasoft.util.logging.LogWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Output {
    private final PrintWriter mPrintWriter;
    private boolean mAutoFlush = true;

    public Output() {
        this(System.out);
    }

    public Output(File file) throws IOException {
        this(new FileWriter(file));
    }

    public Output(OutputStream out) {
        this(new PrintWriter(new OutputStreamWriter(out)));
    }

    public Output(Logger logger, Level level) {
        this(new LogWriter(logger, level));
    }

    public Output(Writer writer) {
        this(writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer));
    }

    public Output(PrintWriter printWriter) {
        this.mPrintWriter = printWriter;
    }

    public final void setAutoFlush(boolean set) {
        this.mAutoFlush = set;
    }

    public final boolean isAutoFlush() {
        return this.mAutoFlush;
    }

    public final PrintWriter writer() {
        return this.mPrintWriter;
    }

    public void printReactions(MetabolicNetwork net, boolean sort, boolean newLineAfterReaction) {
        this.printReactions(net.getReactions().toGenericArray(false), sort, newLineAfterReaction);
    }

    public void printReactions(Collection<? extends Reaction> reactions, boolean sort, boolean newLineAfterReaction) {
        Collection<? extends Reaction> it;
        if (sort) {
            ArrayList<? extends Reaction> arrayList = new ArrayList<Reaction>(reactions);
            Collections.sort(arrayList, new Comparator<Reaction>(){
                private final Collator mCollator = Collator.getInstance(Locale.US);

                @Override
                public int compare(Reaction o1, Reaction o2) {
                    return this.mCollator.compare(o1.getName(), o2.getName());
                }
            });
            it = arrayList;
        } else {
            it = reactions;
        }
        for (Reaction reaction : it) {
            this.printReaction(reaction, newLineAfterReaction);
        }
        if (this.mAutoFlush) {
            this.flush();
        }
    }

    public void printReaction(Reaction reac, boolean newLineAfterReaction) {
        this.mPrintWriter.print(String.valueOf(reac.getName()) + ":\t");
        this.mPrintWriter.print(reac);
        if (newLineAfterReaction) {
            this.mPrintWriter.println();
        } else {
            this.mPrintWriter.print(", ");
        }
    }

    public void printMetabolites(MetabolicNetwork net, boolean sort, boolean newLineAfterMetabolite) {
        this.printMetabolites(net.getMetabolites().toGenericArray(false), sort, newLineAfterMetabolite);
    }

    public void printMetabolites(Collection<? extends Metabolite> metabolites, boolean sort, boolean newLineAfterMetabolite) {
        Collection<? extends Metabolite> it;
        if (sort) {
            ArrayList<? extends Metabolite> arrayList = new ArrayList<Metabolite>(metabolites);
            Collections.sort(arrayList, new Comparator<Metabolite>(){
                private final Collator mCollator = Collator.getInstance(Locale.US);

                @Override
                public int compare(Metabolite r1, Metabolite r2) {
                    return this.mCollator.compare(r1.getName(), r2.getName());
                }
            });
            it = arrayList;
        } else {
            it = metabolites;
        }
        for (Metabolite metabolite : it) {
            this.mPrintWriter.print(metabolite);
            if (newLineAfterMetabolite) {
                this.mPrintWriter.println();
                continue;
            }
            this.mPrintWriter.print(", ");
        }
        if (this.mAutoFlush) {
            this.flush();
        }
    }

    public void printNetworkSize(String prefix, MetabolicNetwork net) {
        this.mPrintWriter.println(MetabolicNetworkUtil.getNetworkSizeString(prefix, net));
        if (this.mAutoFlush) {
            this.flush();
        }
    }

    public void printFluxModes(Iterable<FluxDistribution> fluxModes) {
        this.printFluxModesInternal(fluxModes);
    }

    private void printFluxModesInternal(Iterable<FluxDistribution> fluxModes) {
        Iterator<FluxDistribution> it = fluxModes.iterator();
        if (!it.hasNext()) {
            return;
        }
        MetabolicNetwork net = it.next().getNetwork();
        ArrayIterable<? extends Reaction> reacts = net.getReactions();
        int ii = 0;
        while (ii < reacts.length()) {
            if (ii > 0) {
                this.mPrintWriter.print("\t");
            }
            this.mPrintWriter.print(reacts.get(ii).getName());
            ++ii;
        }
        this.mPrintWriter.println();
        for (FluxDistribution flux : fluxModes) {
            if (flux.getSize() != reacts.length()) {
                throw new IllegalArgumentException("flux count (" + flux.getSize() + ") not equal to number of reactions (" + reacts.length() + ")");
            }
            int ii2 = 0;
            while (ii2 < flux.getSize()) {
                if (ii2 > 0) {
                    this.mPrintWriter.print("\t");
                }
                this.mPrintWriter.print(flux.getNumberRate(ii2));
                ++ii2;
            }
            this.mPrintWriter.println();
        }
        if (this.mAutoFlush) {
            this.flush();
        }
    }

    public void flush() {
        this.mPrintWriter.flush();
    }
}

