/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.parse;

import ch.javasoft.io.Files;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.parse.SbmlParser;
import ch.javasoft.metabolic.parse.junit.AbstractParseTestCase;
import java.io.File;

public abstract class SbmlTest
extends AbstractParseTestCase {
    protected static final File FOLDER_IN = new File("../metabolic-data/sbml/");
    protected static final File FOLDER_OUT = Files.getTempDir();
    protected ThreadLocal<File> fileOut = new ThreadLocal();

    public void testUrea_iAbaylyiv4() throws Exception {
        this.internalTest(new File(FOLDER_IN, "iAbaylyiv4.xml"), new File(FOLDER_OUT, "iAbaylyiv4.m"), "Extraorganism");
    }

    public void testSbml_yest_dirk1() throws Exception {
        this.internalTest(new File(FOLDER_IN, "Yeast_model_Dirk.xml"), new File(FOLDER_OUT, "Yeast_model_Dirk.m"), "external");
    }

    public void testSbml_yest_dirk2() throws Exception {
        this.internalTest(new File(FOLDER_IN, "Yeast_model_Dirk2.xml"), new File(FOLDER_OUT, "Yeast_model_Dirk2.m"), "external");
    }

    public void test_yest_jamboree_model_final_annotated() throws Exception {
        this.internalTest(new File(FOLDER_IN, "jamboree_model_final_annotated.xml"), new File(FOLDER_OUT, "jamboree_model_final_annotated.m"), "Extracellular");
    }

    public void testSmallExample() throws Exception {
        this.internalTest(new File(FOLDER_IN, "SmallExample.xml"), new File(FOLDER_OUT, "SmallExample.m"), "external");
    }

    private void internalTest(File inFile, File outFile, String externalCompartment) throws Exception {
        this.fileOut.set(outFile);
        MetabolicNetwork metaNet = new SbmlParser(externalCompartment, false).parse(inFile);
        this.internalTestOrDelegate(metaNet, null);
    }
}

